/*
**	mod_std.h	-  Definition of the standard Lite / W3-mSQL library
**
**
** Copyright (c) 1995-96  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/




/*
** Standard external function prototypes
*/

void doSplit();
void doTokSplit();
void doStrSeg();
void doChop();
void doTr();
void doSub();
void doTest();
void doSubStr();

void doPrintf();
void doFprintf();
void doEcho();
void doFatal();

void doOpen();
void doClose();
void doRead();
void doReadLn();
void doReadTok();
void doIncludeFile();

void doExit();
void doUnlink();
void doUmask();
void doChmod();
void doSleep();
void doSystem();
void doGetpid();
void doGetppid();
void doChdir();
void doMkdir();
void doRmdir();
void doRename();
void doTruncate();
void doLink();
void doSymlink();

void doStat();
void doKill();

void doTime();
void doCTime();
void doGetTzOffset();

void doGetHostByName();
void doGetHostByAddr();

void doUrlEncode();
void doSetContentType();
void doIncludeFile();

void doTime2UnixTime();
void doUnixTime2Year();
void doUnixTime2Month();
void doUnixTime2Day();
void doUnixTime2Hour();
void doUnixTime2Min();
void doUnixTime2Sec();
void doStrftime();

void doCrypt();

void doGetPwNam();
void doGetPwUid();

void doSrandom();
void doRandom();

void doTypeOf();

void initModStd();


/*
** Note : Because this is a static linked module (rather than a dynamic
** loaded module) we don't need to include the CFuntName field in the
** function table)
*/


/*
** Standard external function definitions
**
** This table maps from internal function names to the C code.
** The format is :-
**
**	{LiteName, CFunctPtr, CFunctName, NumArgs, { Arg1Type, Arg2Type..., 0}}
**
**	Setting NumArgs to -1 indicates varargs
*/


efunct_t std_efuncts[] = {
	{ "printf", doPrintf, NULL, -1, { P_TEXT, 0} },
	{ "fprintf", doFprintf, NULL, -1, { P_INT, P_TEXT, 0} },
	{ "echo", doEcho, NULL, 1, { P_TEXT, 0} },
	{ "fatal", doFatal, NULL, 1, { P_TEXT, 0} },
	{ "open", doOpen, NULL, 2, {P_TEXT, P_TEXT, 0} },
	{ "close", doClose, NULL, 1, {P_INT, 0} },
	{ "read", doRead, NULL, 2, {P_INT, P_INT, 0} },
	{ "readln", doReadLn, NULL, 1, {P_INT, 0} },
	{ "readtok", doReadTok, NULL, 2, {P_INT, P_TEXT, 0} },

	{ "exit", doExit, NULL, 1, {P_INT, 0} },
	{ "split", doSplit, NULL, 2, {P_TEXT, P_TEXT, 0}},
	{ "toksplit", doTokSplit, NULL, 2, {P_TEXT, P_TEXT, 0}},
	{ "strseg", doStrSeg, NULL, 3, {P_TEXT, P_INT, P_INT, 0}},
	{ "chop", doChop, NULL, 1, {P_TEXT, 0}},
	{ "tr", doTr, NULL, 3, {P_TEXT, P_TEXT, P_TEXT,0}},
	{ "sub", doSub, NULL, 3, {P_TEXT, P_TEXT, P_TEXT,0}},
	{ "test", doTest, NULL, 2, {P_TEXT, P_TEXT, 0}},
	{ "substr", doSubStr, NULL, 3, {P_TEXT,P_TEXT,P_TEXT,0}},

	{ "unlink", doUnlink, NULL, 1, {P_TEXT,0} },
	{ "umask", doUmask, NULL, 1, {P_INT, 0}},
	{ "chmod", doChmod, NULL, 2, {P_TEXT,P_INT,0}},
	{ "mkdir", doMkdir, NULL, 1, {P_TEXT,0} },
	{ "chdir", doChdir, NULL, 1, {P_TEXT,0} },
	{ "rmdir", doRmdir, NULL, 1, {P_TEXT,0} },
	{ "rename", doRename, NULL, 2, {P_TEXT, P_TEXT} },
	{ "truncate", doTruncate, NULL, 2, {P_TEXT, P_INT} },
	{ "link", doLink, NULL, 2, {P_TEXT, P_TEXT} },
	{ "symlink", doSymlink, NULL, 2, {P_TEXT, P_TEXT} },
	{ "sleep", doSleep, NULL, 1, {P_INT, 0}},
	{ "system", doSystem, NULL, 1, {P_TEXT,0}},
	{ "getpid", doGetpid, NULL, 0, {0}},
	{ "getppid", doGetppid, NULL, 0, {0}},
	{ "stat", doStat, NULL, 1, {P_TEXT,0}},
	{ "kill", doKill, NULL, 2, {P_INT, P_INT,0}},

	{ "time", doTime, NULL, 0, {0}},
	{ "ctime", doCTime, NULL, 1, {P_INT,0}},
	{ "getTzOffset", doGetTzOffset, NULL, 0, {0}},

	{ "gethostbyname", doGetHostByName, NULL, 1, {P_TEXT,0}},
	{ "gethostbyaddr", doGetHostByAddr, NULL, 1, {P_TEXT,0}},

	{ "urlEncode", doUrlEncode, NULL, 1, {P_TEXT,0}},
	{ "setContentType", doSetContentType, NULL, 1, {P_TEXT,0}},
	{ "includeFile", doIncludeFile, NULL, 1, {P_TEXT,0}},

	{ "time2unixtime", doTime2UnixTime, NULL, 6, {P_INT, P_INT, P_INT, 
		P_INT, P_INT, P_INT, 0}},
	{ "unixtime2year", doUnixTime2Year, NULL, 1, {P_INT, 0}},
	{ "unixtime2month", doUnixTime2Month, NULL, 1, {P_INT, 0}},
	{ "unixtime2day", doUnixTime2Day, NULL, 1, {P_INT, 0}},
	{ "unixtime2hour", doUnixTime2Hour, NULL, 1, {P_INT, 0}},
	{ "unixtime2min", doUnixTime2Min, NULL, 1, {P_INT, 0}},
	{ "unixtime2sec", doUnixTime2Sec, NULL, 1, {P_INT, 0}},
	{ "strftime", doStrftime, NULL, 2, {P_INT, P_TEXT, 0}},

	{ "crypt", doCrypt, NULL, 2, {P_TEXT, P_TEXT, 0}},

	{ "getpwnam", doGetPwNam, NULL, 1, {P_TEXT, 0}},
	{ "getpwuid", doGetPwUid, NULL, 1, {P_INT, 0}},

	{ "srandom", doSrandom, NULL, 1, {P_INT, 0}},
	{ "random", doRandom, NULL, 0, {0}},

	{ "typeof", doTypeOf, NULL, -1, {0}},

	{ NULL, 0 }
};
