/* preferences.c 
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */


#include "ml.h"

Boolean default_true  = TRUE;
Boolean default_false = FALSE;


void pref_accept();
void pref_cancel();
void pref_help();
void pref2_accept();
void pref2_cancel();
void pref2_help();





Menu preferences_menu[] = {
  { "Accept", "pref_accept", 'A',
      pref_accept, NULL, 0, NULL, NULL, BTN_ON },
  { "Cancel", "pref_cancel", 'C',
      pref_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "pref_HELP!", 'H',
      pref_help, NULL, 0, NULL, NULL, BTN_ON },
};

Menu preferences2_menu[] = {
  { "Accept", "pref2_accept", 'A',
      pref2_accept, NULL, 0, NULL, NULL, BTN_ON },
  { "Cancel", "pref_2cancel", 'C',
      pref2_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "pref2_HELP!", 'H',
      pref2_help, NULL, 0, NULL, NULL, BTN_ON },
};











struct prefinfo {
  char *name;
  int  type;
  int  category;
  void *loc;
};

static XtResource x_resources[] = {
  { "imap_server","Imap_server",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,imap_server),
      XtRImmediate, (void*) EMPTYSTR },
  { "smtp_server","Smtp_server",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,smtp_server),
      XtRImmediate, (void *) EMPTYSTR },
  { "nntp_server","Nntp_server",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,nntp_server),
      XtRImmediate, (void *) EMPTYSTR },
  { "default_cc","Default_cc",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,default_cc),
      XtRImmediate, (void *) EMPTYSTR },
  { "default_bcc","Default_bcc",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,default_bcc),
      XtRImmediate, (void *) EMPTYSTR },
  { "default_mailbox","Default_mailbox",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,default_mailbox),
      XtRImmediate, (void*) INBOX },
  { "default_savebox","Default_savebox",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,default_savebox),
      XtRImmediate, (void*) EMPTYSTR },
  { "default_action","Default_action",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,default_action),
      XtRImmediate, (void*) EMPTYSTR },
  { "url_command","Url_command",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,url_command),
      XtRImmediate, (void*) EMPTYSTR },
  { "folder_path","Folder_path",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,folder_path),
      XtRImmediate, (void*) INBOX },
  { "help_directory", "Help_directory",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,help_directory),
      XtRImmediate, (void*) DEFAULT_LIBDIR },
  { "mime_directory", "Mime_directory",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,mime_directory),
      XtRImmediate, (void*) DEFAULT_LIBDIR },
  { "signature_file", "Signature_file",
      XtRString, sizeof(char *),
      XtOffset(Preferences*, signature_file),
      XtRImmediate, (void *) EMPTYSTR },
  { "pgp_username", "Pgp_username",
      XtRString, sizeof(char *),
      XtOffset(Preferences*, pgp_username),
      XtRImmediate, (void *) EMPTYSTR },
  { "pgp_pathname", "Pgp_pathname",
      XtRString, sizeof(char *),
      XtOffset(Preferences*, pgp_pathname),
      XtRImmediate, (void *) PATH_PGP },
  { "print_command", "Print_command",
      XtRString, sizeof(char *),
      XtOffset(Preferences*, print_command),
      XtRImmediate, (void *) EMPTYSTR },
  { "reply_address", "Reply_address",
      XtRString, sizeof(char *),
      XtOffset(Preferences*,reply_address),
      XtRImmediate, (void*) EMPTYSTR },
  { "check_interval", "Check_interval",
      XtRInt, sizeof(int),
      XtOffset(Preferences*,check_interval),
      XtRString, (void*) DEFAULT_RESOURCE_CHECK_INT },
  { "read_height", "Read_height",
      XtRInt, sizeof(int),
      XtOffset(Preferences*,read_height),
      XtRString, (void*) DEFAULT_RESOURCE_HEIGHT },
  { "compose_height", "Compose_height",
      XtRInt, sizeof(int),
      XtOffset(Preferences*,compose_height),
      XtRString, (void*) DEFAULT_RESOURCE_HEIGHT },
  { "view_height", "View_height",
      XtRInt, sizeof(int),
      XtOffset(Preferences*,view_height),
      XtRString, (void*) DEFAULT_RESOURCE_HEIGHT },
  { "imap_port", "Imap_port",
      XtRInt, sizeof(int),
      XtOffset(Preferences*,imap_port),
      XtRString, (void*) DEFAULT_IMAPPORT_STR },
  { "auto_open", "Auto_open",
      XtRBoolean, sizeof (Boolean),
      XtOffset(Preferences*, auto_open),
      XtRBoolean, (void*) &default_false },
  { "mime_ask", "mime_ask",
      XtRBoolean, sizeof (Boolean),
      XtOffset(Preferences*, mime_ask),
      XtRBoolean, (void*) &default_true },
  { "developer_debug", "Developer_debug",
      XtRBoolean, sizeof (Boolean),
      XtOffset(Preferences*, developer_debug),
      XtRBoolean, (void*) &default_false },
  { "hide_empty", "Hide_empty",
      XtRBoolean, sizeof (Boolean),
      XtOffset(Preferences*, hide_empty),
      XtRBoolean, (void*) &default_false },

};

struct prefinfo prefs[] = {
  { "imap_server",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.imap_server,
    },
  { "smtp_server",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.smtp_server,
    },
  { "folder_path",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.folder_path,
    },

  { "default_action",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.default_action,
    },

  { "default_cc",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.default_cc,
    },

  { "default_bcc",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.default_bcc,
    },

  { "url_command",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.url_command,
    },

  { "nntp_server",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.nntp_server,
    },
  { "default_mailbox",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.default_mailbox,
    },
  { "default_savebox",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.default_savebox,
    },

  { "help_directory",
      PREF_TYPE_STR,
      PREF_CATEGORY_ADVANCED,
      &preferences.help_directory,
    },

  { "mime_directory",
      PREF_TYPE_STR,
      PREF_CATEGORY_ADVANCED,
      &preferences.mime_directory,
    },

  { "reply_address",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.reply_address,
    },

  { "pgp_username",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.pgp_username,
    },

  { "pgp_pathname",
      PREF_TYPE_STR,
      PREF_CATEGORY_ADVANCED,
      &preferences.pgp_pathname,
    },

  { "print_command",
      PREF_TYPE_STR,
      PREF_CATEGORY_BASIC,
      &preferences.print_command,
    },

  { "signature_file",
      PREF_TYPE_STR,
      PREF_CATEGORY_OPTION,
      &preferences.signature_file,
    },

  { "check_interval",
      PREF_TYPE_INT,
      PREF_CATEGORY_OPTION,
      &preferences.check_interval,
    },

  { "read_height",
      PREF_TYPE_INT,
      PREF_CATEGORY_OPTION,
      &preferences.read_height,
    },

  { "compose_height",
      PREF_TYPE_INT,
      PREF_CATEGORY_OPTION,
      &preferences.compose_height,
    },

  { "view_height",
      PREF_TYPE_INT,
      PREF_CATEGORY_OPTION,
      &preferences.view_height,
    },

  { "imap_port",
      PREF_TYPE_INT,
      PREF_CATEGORY_ADVANCED,
      &preferences.imap_port,
    },

  { "smtp_debug",
      PREF_TYPE_BOOL,
      PREF_CATEGORY_OPTION,
      &preferences.smtp_debug,
    },

  { "auto_open",
      PREF_TYPE_BOOL,
      PREF_CATEGORY_OPTION,
      &preferences.auto_open,
    },

  { "mime_ask",
      PREF_TYPE_BOOL,
      PREF_CATEGORY_OPTION,
      &preferences.mime_ask,
    },

  { "developer_debug",
      PREF_TYPE_BOOL,
      PREF_CATEGORY_ADVANCED,
      &preferences.developer_debug,
    },

  { "hide_empty",
      PREF_TYPE_BOOL,
      PREF_CATEGORY_ADVANCED,
      &preferences.hide_empty,
    },

};

#ifdef __STDC__
int load_defaults(void)
#else
int load_defaults()
#endif
{

  FILE * fp;
  char * filename;
  char buf[FILEBUFFLEN];
  char *ptr;
  int cnt;
  char **t;
  int *i;
  Boolean *b;
  float *f;

  int total = XtNumber(prefs);

  /* Put all string resources into allocated space */

  for(cnt = 0; cnt < total; cnt ++) 
    if(prefs[cnt].type == PREF_TYPE_STR) {
      t = (char **) prefs[cnt].loc; 
      *t = cpystr(*t);
    }

  filename = (char *) fs_get(strlen(local_auth.homedir) 
		    + strlen(PREFSFILE) + strlen(local_auth.hostname) + 8);

  sprintf(filename,"%s/%s.%s", local_auth.homedir, 
	  PREFSFILE, local_auth.hostname);

  if((fp = fopen(filename,"r")) == NULL) {
    sprintf(filename,"%s/%s", local_auth.homedir, PREFSFILE);
    if((fp = fopen(filename,"r")) == NULL) {
      free(filename);
      return(SYSCALL_FAILURE);
    }
  }




  while((fgets(buf,sizeof(buf),fp)) != NULL) {
    buf[strlen(buf)-1] = '\0';
    /* skip over junk */
    if(*buf == '#' || *buf == '!' || *buf == '\0')
      continue;

    if((strcmp(buf,BEGIN_ADDRESS_STR)) == STRMATCH) {
      load_address_book(fp);
      continue;
    }
    if((strcmp(buf,BEGIN_FILTER_STR)) == STRMATCH) {
      load_filters(fp);
      continue;
    }
    if((strcmp(buf,BEGIN_FILTER_MAP_STR)) == STRMATCH) {
      load_filter_maps(fp);
      continue;
    }


    ptr = strchr(buf,':');
    if(ptr == NULL)
      continue;
    *ptr = '\0';
    ptr ++;
                       /* if no value is set,
			* skip it, and allow the X defaults
			* to override
			*/
    if(*ptr == '\0')
      continue;
    for(cnt = 0; cnt < total; cnt ++) {
      if(strcmp(prefs[cnt].name,buf) != 0)
	continue;

      t = (char **) prefs[cnt].loc;
      i = (int *) prefs[cnt].loc;
      b = (Boolean *) prefs[cnt].loc;
      f = (float *) prefs[cnt].loc;
      
      switch(prefs[cnt].type) {
      case PREF_TYPE_INT:
	*i = atoi(ptr);
	break;
      case PREF_TYPE_STR:
	while(isspace(*ptr))
	  ptr ++;
	free(*t);
	*t = cpystr(ptr);
	break;
      case PREF_TYPE_BOOL:
	while(isspace(*ptr))
	  ptr ++;
	if((strcasecmp(ptr,"true")) == 0)
	  *b = TRUE;
	else
	  *b = FALSE;
	break;
      case PREF_TYPE_FLOAT:
	*f = (float) atof(ptr);
	break;
      default:
	break;
      }
    }
  }

  fclose(fp);
  free(filename);
  return(SYSCALL_SUCCESS);
}

#ifdef __STDC__
void save_defaults(void)
#else
void save_defaults()
#endif
{

  FILE * fp;
  char * filename;
  char * backup;
  int cnt;
  char **t;
  int *i;
  Boolean *b;
  float *f;

  int total = XtNumber(prefs);

  filename = (char *) fs_get(strlen(local_auth.homedir) 
		    + strlen(PREFSFILE) + strlen(local_auth.hostname) + 8);

  sprintf(filename,"%s/%s.%s", local_auth.homedir, 
	  PREFSFILE, local_auth.hostname);

  if(access(filename,W_OK)) 
    sprintf(filename,"%s/%s", local_auth.homedir, PREFSFILE);

  backup = (char *) fs_get(strlen(filename) + strlen(".bak") + 8);
  strcpy(backup,filename);
  strcat(backup,".bak");

  rename(filename,backup);

  fs_give((void **) &backup);

  if((fp = fopen(filename,"w")) == NULL) {
    mm_log(PREFSAVE_ERROR,WARN);
    free(filename);
    return;
  }

  fprintf(fp,"# ML Preferences:\n\n");

  for(cnt = 0; cnt < total; cnt ++) {

    t = (char **) prefs[cnt].loc;
    i = (int *) prefs[cnt].loc;
    b = (Boolean *) prefs[cnt].loc;
    f = (float *) prefs[cnt].loc;

    switch(prefs[cnt].type) {
    case PREF_TYPE_INT:
      fprintf(fp,"%s:\t\t%d\n",prefs[cnt].name,*i);
      break;
    case PREF_TYPE_STR:
      fprintf(fp,"%s:\t\t%s\n",prefs[cnt].name,*t);
      break;
    case PREF_TYPE_BOOL:
      fprintf(fp,"%s:\t\t%s\n",prefs[cnt].name,(*b) 
	      ? "true" : "false");
      break;
    case PREF_TYPE_FLOAT:
      fprintf(fp,"%s:\t\t%f\n",prefs[cnt].name,*f);
      break;
    default:
      break;
    }
  }

  save_address_book(fp);
  save_filters(fp);
  save_filter_maps(fp);

  if((fclose(fp)) == SYSCALL_SUCCESS)
    mm_log("Preferences saved.", NIL);
  else
    mm_log("Error saving preferences.", WARN);
  free(filename);

}


void get_resources(w)
     Widget w;
{

  XtGetApplicationResources(w, 
			    (char*) &preferences,
			    x_resources, 
			    XtNumber(x_resources),
			    NULL, 
			    0);
}


void sane_defaults()
{
  char buf[FILEBUFFLEN];

  if(*(preferences.reply_address) == NUL_TERM) {
    fs_give((void **) &preferences.reply_address);
    sprintf(buf,"%s <%s@%s>",
	    local_auth.fullname,local_auth.username,local_auth.hostname);
    preferences.reply_address = cpystr(buf);
  }
  if(*(preferences.imap_server) == NUL_TERM) {
    fs_give((void **) &preferences.imap_server);
    preferences.imap_server = cpystr(local_auth.hostname);
  }
  if(*(preferences.smtp_server) == NUL_TERM) {
    fs_give((void **) &preferences.smtp_server);
    preferences.smtp_server = cpystr(local_auth.hostname);
  }
  if(*(preferences.nntp_server) == NUL_TERM) {
    fs_give((void **) &preferences.nntp_server);
    preferences.nntp_server = cpystr(local_auth.hostname);
  }
  if(*(preferences.folder_path) == NUL_TERM) {
    fs_give((void **) &preferences.folder_path);
    preferences.folder_path = cpystr(local_auth.homedir);
  }
  if(preferences.read_height < 2)
    preferences.read_height = 2;
  if(preferences.compose_height < 2)
    preferences.compose_height = 2;
  if(preferences.view_height < 2)
    preferences.view_height = 2;
}


save_address_book(fp)
     FILE *fp;
{
  Address_Book_Info *info;
  if(! session.address_book)
    return(0);
  if(session.address_book->address_book_info == NULL)
    return(0);

  fprintf(fp,"\n%s\n",BEGIN_ADDRESS_STR);
  for(info = session.address_book->address_book_info; 
      info ; info = info->prev) {
    fprintf(fp,"%s\n",(info->name)    ? info->name    : EMPTYSTR); 
    fprintf(fp,"%s\n",(info->address) ? info->address : EMPTYSTR); 
    fprintf(fp,"%s\n",(info->comment) ? info->comment : EMPTYSTR); 
  }
  fprintf(fp,"%s\n",END_ADDRESS_STR);
  return(0);
}


load_address_book(fp)
     FILE *fp;
{
  char buffer[FILEBUFFLEN];
  
  Address_Book_Info *info;

  if(session.address_book == NULL) {
    session.address_book = (Address_Book *) fs_get(sizeof(Address_Book));
    session.address_book->is_realized = FALSE;
    session.address_book->address_book_info = NULL;
  }

  while((fgets(buffer,sizeof(buffer),fp)) != NULL) {
    buffer[strlen(buffer)-1] = '\0';

    if((strcmp(buffer,END_ADDRESS_STR)) == STRMATCH)
      return;
    
    info = new_address_book_info();

    info->name = cpystr(buffer);
    if(fgets(buffer,sizeof(buffer),fp)) {
      buffer[strlen(buffer)-1] = '\0';
      info->address = cpystr(buffer);
    }
    else
      info->address = cpystr(EMPTYSTR);

    if(fgets(buffer,sizeof(buffer),fp)) {
      buffer[strlen(buffer)-1] = '\0';
      info->comment = cpystr(buffer);
    }
    else
      info->comment = cpystr(EMPTYSTR);

    if(session.address_book->address_book_info == NULL)
      session.address_book->address_book_info = info;
    else {
      info->prev = session.address_book->address_book_info;
      session.address_book->address_book_info->next = info;
      session.address_book->address_book_info = info;
    }
  }
  
}



load_filters(fp)
     FILE *fp;
{
  char buffer[FILEBUFFLEN];

  Filter *prev = NULL;
  Filter *filter;

  while((fgets(buffer,sizeof(buffer),fp)) != NULL) {
    buffer[strlen(buffer)-1] = '\0';

    if((strcmp(buffer,END_FILTER_STR)) == STRMATCH)
      return;
    
    filter = new_filter();

    filter->archived = TRUE;
    filter->filter_type = FILTER_TYPE_USER;

    filter->name = cpystr(buffer);
    if(fgets(buffer,sizeof(buffer),fp)) {
      buffer[strlen(buffer)-1] = '\0';
      filter->action = cpystr(buffer);
    }
    else
      filter->action = cpystr(EMPTYSTR);

    if(fgets(buffer,sizeof(buffer),fp)) {
      buffer[strlen(buffer)-1] = '\0';
      filter->text = cpystr(buffer);
    }
    else
      filter->text = cpystr(EMPTYSTR);

    if(*filter->text == NUL_TERM) {
      free_filter(filter);
      continue;
    }

    if(session.filters)
      for(prev = session.filters; prev->next; prev = prev->next)
	;

    if(prev == NULL) {
      session.filters = filter;
      filter->prev = NULL;
    }
    else {
      filter->prev = prev;
      prev->next = filter;
    }
  }
}

save_filters(fp)
     FILE *fp;
{

  Filter *filter;

  fprintf(fp,"\n%s\n",BEGIN_FILTER_STR);
  for(filter = session.filters; filter; filter = filter->next) {
    fprintf(fp,"%s\n",(filter->name)   ? filter->name    : EMPTYSTR); 
    fprintf(fp,"%s\n",(filter->action) ? filter->action : EMPTYSTR); 
    fprintf(fp,"%s\n",(filter->text)   ? filter->text : EMPTYSTR); 
  }
  fprintf(fp,"%s\n",END_FILTER_STR);
  return(0);
}


save_filter_maps(fp)
     FILE *fp;
{

  Filter_Map *filter_map;

  fprintf(fp,"\n%s\n",BEGIN_FILTER_MAP_STR);
  for(filter_map = session.filter_map; 
      filter_map; filter_map = filter_map->next) {
    fprintf(fp,"%s\n",(filter_map->mailboxname)   
	    ? filter_map->mailboxname : EMPTYSTR); 
    fprintf(fp,"%s\n",(filter_map->filename) 
	    ? filter_map->filename : EMPTYSTR); 
  }
  fprintf(fp,"%s\n",END_FILTER_MAP_STR);
  return(0);
}


load_filter_maps(fp)
     FILE *fp;
{
  char buffer[FILEBUFFLEN];
  char *ptr = NULL;
  Filter_Map *prev = NULL;
  Filter_Map *filter_map;

  while((fgets(buffer,sizeof(buffer),fp)) != NULL) {
    buffer[strlen(buffer)-1] = '\0';

    if((strcmp(buffer,END_FILTER_MAP_STR)) == STRMATCH)
      return;
    
    filter_map = new_filter_map();

    filter_map->mailboxname = cpystr(buffer);
    if(fgets(buffer,sizeof(buffer),fp)) {
      buffer[strlen(buffer)-1] = '\0';
      filter_map->filename = cpystr(buffer);
    }
    else
      filter_map->filename = cpystr(EMPTYSTR);

    ptr = strrchr(buffer,'.');
    if(ptr) {
      ptr ++;
      filter_map->sequence = atoi(ptr);
    }

    if(session.filter_map)
      for(prev = session.filter_map; prev->next; prev = prev->next)
	;

    if(prev == NULL) 
      session.filter_map = filter_map;
    else
      prev->next = filter_map;
  }
}


void make_prefs_window(w,zilch,xp)
     Widget w;
     XtPointer zilch;
     XtPointer xp;
{
  
  Arg args[ARGLISTSIZE];
  int n = 0;
  Position x,y;
  Widget form, menubar, label1, label2, label3;
  
  Prefst *prefst;

  if(! session.prefst) {
    prefst = (Prefst *) fs_get(sizeof(Prefst));
    session.prefst = prefst;
    prefst->is_realized = FALSE;
  }
  else
    prefst = session.prefst;

  if(prefst->is_realized == TRUE) {
    XRaiseWindow(display,XtWindow(prefst->shell));
    return;
  }


  get_pointer_position(top, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  XtSetArg(args[n], XtNallowShellResize, TRUE); n ++;
  prefst->shell = XtCreateWidget("Preferences",
				 topLevelShellWidgetClass, top,
				 args, n); n = 0;

  XmAddTabGroup(prefst->shell);

  form = XmCreateForm(prefst->shell, "form", args, n ); n = 0;

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form, "menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, preferences_menu,
		      XtNumber(preferences_menu),
		      BTN_ON, prefst);

  label1 = create_label(form,menubar,"Mail server configuration");

  prefst->imapname =
    create_text_field(form, label1, 
		      "IMAP Server        :", 
		      preferences.imap_server,64, NULL, NULL);

  prefst->mailname =
    create_text_field(form, prefst->imapname, 
		      "Default Mailbox    :", 
		      preferences.default_mailbox,64, NULL, NULL);

  prefst->smtpname =
    create_text_field(form, prefst->mailname, 
		      "SMTP Server        :", 
		      preferences.smtp_server,64, NULL, NULL);
  
  prefst->replname =
    create_text_field(form, prefst->smtpname,
		      "Reply-To Address   :", 
		      preferences.reply_address,64, NULL, NULL);

  prefst->sigfile =
    create_text_field(form, prefst->replname,
		      "Signature File     :", 
		      preferences.signature_file,64, NULL, NULL);
  
  label2 = create_label(form, prefst->sigfile,"Miscellaneous configuration");

  prefst->nntpname =
    create_text_field(form, label2,
		      "NNTP (News) Server :", 
		      preferences.nntp_server,64, NULL, NULL);

  prefst->prntcmd =
    create_text_field(form, prefst->nntpname, 
		      "Print Command      :", 
		      preferences.print_command,64, NULL, NULL);

  prefst->pgpname =
    create_text_field(form, prefst->prntcmd,
		      "PGP Default Name   :", 
		      preferences.pgp_username,64, NULL, NULL);

  prefst->pgppath =
    create_text_field(form, prefst->pgpname,
		      "PGP path name      :", 
		      preferences.pgp_pathname,64, NULL, NULL);

  prefst->fldrpath =
    create_text_field(form, prefst->pgppath, 
		      "Mail Folder Path   :", 
		      preferences.folder_path,64, NULL, NULL);

  prefst->helpdir =
    create_text_field(form, prefst->fldrpath,
		      "ML Help Directory  :", 
		      preferences.help_directory,64, pref_accept, prefst);


  XtManageChild(form);
  XtManageChild(prefst->shell);
  prefst->is_realized = TRUE;

}

void make_prefs2_window(w,zilch,xp)
     Widget w;
     XtPointer zilch;
     XtPointer xp;
{
  
  Arg args[ARGLISTSIZE];
  char tmp[FILEBUFFLEN];

  int n = 0;
  Position x,y;
  Widget form, menubar, label1, label2, label3;
  
  Pref2st *pref2st;

  if(! session.pref2st) {
    pref2st = (Pref2st *) fs_get(sizeof(Pref2st));
    session.pref2st = pref2st;
    pref2st->is_realized = FALSE;
  }
  else
    pref2st = session.pref2st;

  if(pref2st->is_realized == TRUE) {
    XRaiseWindow(display,XtWindow(pref2st->shell));
    return;
  }


  get_pointer_position(top, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  XtSetArg(args[n], XtNallowShellResize, TRUE); n ++;
  pref2st->shell = XtCreateWidget("More Preferences",
				 topLevelShellWidgetClass, top,
				 args, n); n = 0;

  XmAddTabGroup(pref2st->shell);

  form = XmCreateForm(pref2st->shell, "form", args, n ); n = 0;

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form, "menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, preferences2_menu,
		      XtNumber(preferences2_menu),
		      BTN_ON, pref2st);


  pref2st->dfl_action =
    create_text_field(form, menubar, 
		      "Default View Action   :", 
		      preferences.default_action,64, NULL, NULL);

  pref2st->url_command =
    create_text_field(form, pref2st->dfl_action, 
		      "URL View command      :", 
		      preferences.url_command,64, NULL, NULL);

  pref2st->savebox =
    create_text_field(form, pref2st->url_command, 
		      "Default Save Mailbox  :", 
		      preferences.default_savebox,64, NULL, NULL);
  
  pref2st->mime_dir =
    create_text_field(form, pref2st->savebox,
		      "MIME config directory :", 
		      preferences.mime_directory,64, NULL, NULL);
  pref2st->defcc =
    create_text_field(form, pref2st->mime_dir,
		      "Default CC address    :",
		      preferences.default_cc,64, NULL, NULL);

  pref2st->defbcc =
    create_text_field(form, pref2st->defcc,
		      "Default BCC address   :", 
		      preferences.default_bcc,64, NULL, NULL);


  label2 = create_label(form, pref2st->defbcc,"Numeric options");

  sprintf(tmp,"%lu",preferences.check_interval);


  pref2st->check_interval =
    create_text_field(form, label2,
		      "Mail check interval  :", 
		      tmp,64, NULL, NULL);
  
  sprintf(tmp,"%lu",preferences.view_height);

  pref2st->view_height =
    create_text_field(form, pref2st->check_interval,
		      "View window height   :", 
		      tmp,64, NULL, NULL);

  sprintf(tmp,"%lu",preferences.read_height);

  pref2st->read_height =
    create_text_field(form, pref2st->view_height, 
		      "Read window height   :", 
		      tmp,64, NULL, NULL);

  sprintf(tmp,"%lu",preferences.compose_height);

  pref2st->compose_height =
    create_text_field(form, pref2st->read_height,
		      "Compose window height:", 
		      tmp,64, NULL, NULL);

  sprintf(tmp,"%lu",preferences.imap_port);

  pref2st->imap_port =
    create_text_field(form, pref2st->compose_height,
		      "IMAP TCP port        :", 
		      tmp,64, NULL, NULL);

  label3 = create_label(form, pref2st->imap_port,"Toggle options");

  sprintf(tmp,"%s", (preferences.smtp_debug == TRUE) ? "true" : "false" );

  pref2st->smtp_debug =
    create_text_field(form, label3, 
		      "SMTP debug/trace     :", 
		      tmp,64, NULL, NULL);

  sprintf(tmp,"%s", (preferences.auto_open == TRUE) ? "true" : "false" );

  pref2st->auto_open =
    create_text_field(form, pref2st->smtp_debug,
		      "Auto open mailbox    :", 
		      tmp,64, NULL, NULL);


  sprintf(tmp,"%s", (preferences.hide_empty == TRUE) ? "true" : "false" );

  pref2st->hide_empty =
    create_text_field(form, pref2st->auto_open,
		      "Hide Empty Views     :", 
		      tmp,64, pref2_accept, pref2st);


  XtManageChild(form);
  XtManageChild(pref2st->shell);
  pref2st->is_realized = TRUE;

}




void pref_accept(w,prefst,xp)
     Widget w;
     Prefst *prefst;
     XtPointer xp;
{

  set_watch_cursors();

  fs_give((void **) &preferences.imap_server);
  preferences.imap_server = GetTextField(prefst->imapname);

  fs_give((void **) &preferences.smtp_server);
  preferences.smtp_server = GetTextField(prefst->smtpname);

  fs_give((void **) &preferences.nntp_server);
  preferences.nntp_server = GetTextField(prefst->nntpname);

  fs_give((void **) &preferences.default_mailbox);
  preferences.default_mailbox = GetTextField(prefst->mailname);

  fs_give((void **) &preferences.reply_address);
  preferences.reply_address = GetTextField(prefst->replname);

  fs_give((void **) &preferences.pgp_username);
  preferences.pgp_username = GetTextField(prefst->pgpname);

  fs_give((void **) &preferences.pgp_pathname);
  preferences.pgp_pathname = GetTextField(prefst->pgppath);

  fs_give((void **) &preferences.signature_file);
  preferences.signature_file = GetTextField(prefst->sigfile);

  fs_give((void **) &preferences.print_command);
  preferences.print_command = GetTextField(prefst->prntcmd);

  fs_give((void **) &preferences.folder_path);
  preferences.folder_path = GetTextField(prefst->fldrpath);

  fs_give((void **) &preferences.help_directory);
  preferences.help_directory = GetTextField(prefst->helpdir);

  save_defaults();
  XtDestroyWidget(prefst->shell);
  prefst->is_realized = FALSE;

  reset_cursors();

}


void pref2_accept(w,pref2st,xp)
     Widget w;
     Pref2st *pref2st;
     XtPointer xp;
{

  char *tmp;
  unsigned long n = 0;

  set_watch_cursors();

  fs_give((void **) &preferences.default_action);
  preferences.default_action = GetTextField(pref2st->dfl_action);

  fs_give((void **) &preferences.url_command);
  preferences.url_command = GetTextField(pref2st->url_command);

  fs_give((void **) &preferences.default_savebox);
  preferences.default_savebox = GetTextField(pref2st->savebox);

  fs_give((void **) &preferences.mime_directory);
  preferences.mime_directory = GetTextField(pref2st->mime_dir);

  fs_give((void **) &preferences.default_cc);
  preferences.default_cc = GetTextField(pref2st->defcc);

  fs_give((void **) &preferences.default_bcc);
  preferences.default_bcc = GetTextField(pref2st->defbcc);


  tmp = GetTextField(pref2st->check_interval);
  n = atoi(tmp);
  if(n > 0)
    preferences.check_interval = n;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->view_height);
  n = atoi(tmp);
  if(n > 0)
    preferences.view_height = n;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->read_height);
  n = atoi(tmp);
  if(n > 0)
    preferences.read_height = n;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->compose_height);
  n = atoi(tmp);
  if(n > 0)
    preferences.compose_height = n;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->imap_port);
  n = atoi(tmp);
  if(n > 0)
    preferences.imap_port = n;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->smtp_debug);
  if((strcasecmp(tmp,"true")) == STRMATCH)
    preferences.smtp_debug = TRUE;
  else
    preferences.smtp_debug = FALSE;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->auto_open);
  if((strcasecmp(tmp,"true")) == STRMATCH)
    preferences.auto_open = TRUE;
  else
    preferences.auto_open = FALSE;
  fs_give((void **) &tmp);

  tmp = GetTextField(pref2st->hide_empty);
  if((strcasecmp(tmp,"true")) == STRMATCH)
    preferences.hide_empty = TRUE;
  else
    preferences.hide_empty = FALSE;
  fs_give((void **) &tmp);


  save_defaults();
  XtDestroyWidget(pref2st->shell);
  pref2st->is_realized = FALSE;

  reset_cursors();

}





void pref_cancel(w,prefst,xp)
     Widget w;
     Prefst *prefst;
     XtPointer xp;
{

  XtDestroyWidget(prefst->shell);
  prefst->is_realized = FALSE;

}


void pref2_cancel(w,pref2st,xp)
     Widget w;
     Pref2st *pref2st;
     XtPointer xp;
{

  XtDestroyWidget(pref2st->shell);
  pref2st->is_realized = FALSE;

}


void pref_help(w,prefst,xp)
     Widget w;
     Prefst *prefst;
     XtPointer xp;
{

  help(top,"HELP - Preferences", "preferences.help");

}

void pref2_help(w,pref2st,xp)
     Widget w;
     Pref2st *pref2st;
     XtPointer xp;
{

  help(top,"HELP - Preferences", "preferences2.help");

}





