/* ml.h 
 *
 *
 * $Author: mtm $
 * $Date: 1994/11/08 01:29:33 $
 * $Id: ml.h,v 1.1 1994/11/08 01:29:33 mtm Exp mtm $
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1995 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log: ml.h,v $
 * Revision 1.1  1994/11/08  01:29:33  mtm
 * Initial revision
 *
 * 
 */

#ifndef __ML_H__
#define __ML_H__


/***************************************************************************
 *                      Global Includes                                    *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/time.h>
#include <time.h>
#include <dirent.h>


#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xresource.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/CascadeB.h>
#include <Xm/BulletinB.h>
#include <Xm/MenuShell.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <Xm/PanedW.h>
#include <Xm/ScrollBar.h>

#include "imap/c-client/mail.h"
#include "imap/c-client/misc.h"

#include "buttons.h"
#include "preferences.h"
#include "parse.h"
#include "structures.h"


/***************************************************************************
 *                   Global definitions                                    *
 ***************************************************************************/

#define PROGRAM              "ML"
#ifndef VERSION
#define VERSION              "1.0b3"
#endif

#ifndef DEFAULT_LIBDIR
#define DEFAULT_LIBDIR             "/usr/local/lib/ml"
#endif /* DEFAULT_LIBDIR */

/*   PGP configuration. Program assumes PGP 2.6.2 behaviour.   */

#ifndef PATH_PGP
#define PATH_PGP                   "/usr/local/bin/pgp"
#endif /* PATH_PGP */

#define PGP_SIGN_CMD "PGPPASSFD=0; export PGPPASSFD; pgp -fastu '%s' > %s"
#define PGP_CRYP_CMD "PGPPASSFD=0; export PGPPASSFD; pgp -featu '%s' %s > %s"
#define PGP_BOTH_CMD "PGPPASSFD=0; export PGPPASSFD; pgp -feastu '%s' %s > %s"
#define PGP_KV_CMD   "pgp -kv"
#define PGP_KADD_CMD "PGPPASSFD=0; export PGPPASSFD; pgp -fka > %s"
#define PGP_VRFY_CMD "PGPPASSFD=0; export PGPPASSFD; pgp %s -o %s > %s"
#define PGP_DECR_CMD "PGPPASSFD=0; export PGPPASSFD; pgp %s -o %s > %s"

#define PGP_SIGN 1
#define PGP_CRYP 2
#define PGP_BOTH 3
#define PGP_VRFY 4
#define PGP_DECR 5
#define PGP_KADD 6

#define PGP_MESSAGE_STR   "-----BEGIN PGP MESSAGE-----"
#define PGP_PUBLICK_STR   "-----BEGIN PGP PUBLIC KEY BLOCK-----"
#define PGP_SIGNATU_STR   "-----BEGIN PGP SIGNATURE-----"



#define MLNOTIFY 739    /* something the c-client probably won't use... */

/* IMAP flag strings */

#define DELETED_FLAG         "\\Deleted"
#define SEEN_FLAG            "\\Seen"
#define RECENT_FLAG          "\\Recent"
#define FLAGGED_FLAG         "\\Flagged"
#define ANSWERED_FLAG        "\\Answered"
#define DRAFT_FLAG           "\\Draft"

#define MAIL_BEHAVIOUR         0
#define NEWS_BEHAVIOUR         1

#define SYSCALL_SUCCESS        0 
#define SYSCALL_FAILURE        (-1)

#define STRMATCH               0
#define LISTMATCH              0
#define LISTNOMATCH            1
#define SUBSTRING              1

#define ARGLISTSIZE            32
#define FILEBUFFLEN            2048
#define MESSAGE_ID_LENGTH      256    /* length for sent Message-ID and date */
#define STATUSWIN_HEIGHT       8
#define STATUSWIN_WIDTH        64
#define AUTHSTR_WIDTH          32
#define CURRTIMESIZE           16
#define TABSIZE                8
#define COMPOSEWIDTH           80
#define VISIBLE_ATTACHMENTS    3
#define NUL_TERM               '\0'
#define EMPTYSTR               ""
#define PASSWORD_PATTERN       0x59
#define PASSWD_CHAR            '*'
#define PASSWD_STR             "*"
#define LFCHAR                 '\n'
#define LFSTR                  "\n"
#define CRCHAR                 '\r'
#define CRSTR                  "\r"
#define SPACECHAR              ' '
#define SPACESTR               " "
#define TABCHAR                '\t'
#define TABSTR                 "\t"
#define COLONCHAR              ':'
#define SEMICOLONCHAR          ';'
#define PATH_SEPARATOR_CHAR    '/'
#define PATH_SEPARATOR_STR     "/"
#define TYPE_SEPARATOR_CHAR    '/'
#define TYPE_SEPARATOR_STR     "/"
#define ROOTDIR_STR            "/"
#define THISDIR_STR            "."
#define PARENTDIR_STR          ".."
#define COMMENT_CHAR           '#'
#define FILE_PATTERN_STR       "*"

#define TEXT_TYPE_STR          "text"
#define MULTI_TYPE_STR         "multipart"
#define MESSAGE_TYPE_STR       "message"
#define APPL_TYPE_STR          "application"
#define AUDIO_TYPE_STR         "audio"
#define IMAGE_TYPE_STR         "image"
#define VIDEO_TYPE_STR         "video"
#define OTHER_TYPE_STR         "other"

#define PART_ONE_STR           "1"         
#define HEADER_TAB_LEN         12
#define PLAINSUBTYPE           "plain"
#define NOSUBTYPE              "NO-SUBTYPE"
#define COMPOSETAG             "$COMPOSE="
#define EMPTYMULTIWARN   "Attempt to send empty multipart. (Fixed.)"
#define BLANK_STR        "                                                  "
#define INBOX                "INBOX"
#define LOGTIME_FMT          "[%a %l:%M %p] "
#define CHECKMSG             "Check completed"
#define PREFSAVE_ERROR       "Preferences could not be saved!\n"
#define MIME_LOAD_ERR_FMT    "Could not load MIME types file '%s'."


#define DEFAULT_RESOURCE_STR       EMPTYSTR
#define DEFAULT_RESOURCE_CHECK_INT "120"
#define DEFAULT_RESOURCE_HEIGHT    "14"
#define DEFAULT_IMAPPORT_STR       "143"
#define DEFAULT_IMAPPORT           143

#define MAILBOX_TYPE_MAIL          0
#define MAILBOX_TYPE_NEWS          1

#define BEGIN_FORWARD              "\n--- Begin Forwarded Message ---\n"
#define END_FORWARD                "\n--- End Forwarded Message ---\n"

/* Compose messages */

#define NNTP_OPEN_ERR        "NNTP open failed."
#define NNTP_SEND_ERR        "NNTP send failed."
#define SMTP_OPEN_ERR        "SMTP open failed."
#define SMTP_SEND_ERR        "SMTP send failed."
#define MAILSENT             "Mail sent."
#define NEWSSENT             "News sent."
#define NEW_MESSAGE_STR      "New Message"
#define FAKEPART             "EMPTY ATTACHMENT"
#define ATTACHMENTS_STR      "Attachments:"
#define MULTI_NOT_EMPTY      "Cannot delete multipart. It is not empty."
#define ML_DRAFT_HEADER      "#-- ML SAVED DRAFT --#"
#define NOT_A_DRAFT          "File does not appear to be a draft."
#define DEFAULTEDITWRAPCOL_STR  "72"
#define DEFAULTSTRIP_STR        ">"
#define DEFAULTINSERT_STR       ">  "

#define DEFAULT_REPLY_SUBJECT "Re: (No Subject)"

#define FROM_TEXT            "From:"
#define TO_TEXT              "To:"
#define NG_TEXT              "Newsgroups:"
#define SUBJECT_TEXT         "Subject:"
#define CC_TEXT              "Cc:"
#define BCC_TEXT             "Bcc:"

#define FILE_GO_HOME         "**Home**"
#define FILE_GO_UP           "**Up One Level**"



/* Authentication messages */

#define AUTHLABELSTR          "Authenticate to: %s"
#define USERNAMESTR           "Username :"
#define PASSWORDSTR           "Password :"
#define UNKNOWNSTR            "Unknown"

/* Local filenames used by program. */

#define PREFSFILE             ".mlprefs"
#define FILTERFILE            ".mlfilters"

/* 
 * Filenames for MIME configuration under preferences.mime_dir 
 * (default is $LIBDIR). See mime.c for file format information.
 */

#define MIMETYPESFILE         "mime.types"      /* list of known MIME types */
#define MIMEMAPFILE           "mime.map"        /* file suffix to type map  */
#define MIMEHANDLERFILE       "mime.handlers"   /* external viewer config   */

#define BEGIN_ADDRESS_STR     "*--Begin Address Entries--*"
#define END_ADDRESS_STR       "*--End Address Entries--*"
#define BEGIN_FILTER_STR      "*--Begin Filter Entries--*"
#define END_FILTER_STR        "*--End Filter Entries--*"
#define BEGIN_FILTER_MAP_STR  "*--Begin Filter Map Entries--*"
#define END_FILTER_MAP_STR    "*--End Filter Map Entries--*"


/**************************************************************************
 *                          Global Variables                              *
 **************************************************************************/

extern Widget top;                                                /* ml.c */
extern Widget status;                                             /* ml.c */
extern XtAppContext context;                                      /* ml.c */
extern Preferences preferences;                                   /* ml.c */
extern Local_Auth local_auth;                                     /* ml.c */
extern Session session;                                           /* ml.c */
extern Display *display;                                          /* ml.c */
/**************************************************************************
 *         Global variables and constants defined elsewhere               *
 **************************************************************************/

extern char GLOBAL_text_translations[];                     /* textfncs.c */
extern char GLOBAL_text_field_translations[];               /* textfncs.c */
extern char GLOBAL_nonterminal_text_field_translations[];   /* textfncs.c */
extern char GLOBAL_terminal_text_field_translations[];      /* textfncs.c */
extern char GLOBAL_modal_list_translations[];               /* textfncs.c */
extern char GLOBAL_button_translations[];                   /* textfncs.c */
extern char        last_notify_string[];                    /* imapfncs.c */
extern MAILSTREAM *last_notify_stream;                      /* imapfncs.c */
extern Filename_Map *external_filename_map;                     /* mime.c */
extern Mime_Type  *mime_types;                                  /* mime.c */
extern Cursor clock_cursor;                                 /* winfuncs.c */
extern Cursor top_left_cursor;                              /* winfuncs.c */
extern Cursor pirate_cursor;                                /* winfuncs.c */



/**************************************************************************
 *                 Now include our function prototypes                    *
 *    We do this last so that all of the types will have been defined     *
 **************************************************************************/
#include "prototypes.h"


#endif /* __ML_H__ */

