/* miscfncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"


Mailbox *find_mailbox_from_mailstream(mailstream)
     MAILSTREAM *mailstream;
{
  Mailbox *mailbox;

  for(mailbox = session.mailboxes; mailbox ; mailbox = mailbox->next)
    if(mailbox->mailstream == mailstream)
      return(mailbox);

  return(NULL);

}

Filter_Map *new_filter_map()
{
  Filter_Map *filter_map = (Filter_Map *) fs_get(sizeof(Filter_Map));

  filter_map->mailboxname   = NULL;
  filter_map->filename      = NULL;
  filter_map->sequence      = 0;
  filter_map->next          = NULL;

  return(filter_map);
}

Filter_Map *get_filter_map(lview)
     Lview *lview;
{
  Filter_Map *filter_map = NULL;
  
  if((lview == NULL) 
     || (lview->mailbox == NULL) 
     || (lview->mailbox->imapname == NULL))
    return(NULL);

  for(filter_map = session.filter_map; filter_map; 
      filter_map = filter_map->next) {
    if((strcmp(filter_map->mailboxname,
	       lview->mailbox->imapname)) == STRMATCH)
      return(filter_map);
  }
  return(NULL);

}

Filter_Map *generate_filter_map(lview)
     Lview *lview;
{
  char buffer[MAXPATHLEN];
  Filter_Map *prev = NULL;
  Filter_Map *filter_map = new_filter_map();
 
  filter_map->mailboxname = cpystr(lview->mailbox->imapname);
 
  if(session.filter_map == NULL) {
    session.filter_map = filter_map;
    sprintf(buffer,"%s/%s.1", local_auth.homedir,FILTERFILE);
    filter_map->sequence = 1;
    filter_map->filename = cpystr(buffer);
  }
  else {
    for(prev = session.filter_map; prev->next; prev = prev->next)
      ;
    filter_map->sequence = prev->sequence + 1;
    sprintf(buffer,"%s/%s.%d",local_auth.homedir,
	    FILTERFILE, filter_map->sequence);
    filter_map->filename = cpystr(buffer);
    prev->next = filter_map;
  }

  (void) save_defaults();
  return(filter_map);
}



Server_List *new_server_list()
{

  Server_List *server_list = (Server_List *) fs_get(sizeof(Server_List));

  server_list->name           = NULL;
  server_list->type           = MAILBOX_TYPE_MAIL;
  server_list->active         = FALSE;
  server_list->mailbox_list   = NULL;
  server_list->next           = NULL;
  server_list->prev           = NULL;

  return(server_list);

}

Mailbox_List *new_mailbox_list()
{

  Mailbox_List *mailbox_list = (Mailbox_List *) fs_get(sizeof(Mailbox_List));

  mailbox_list->name      = NULL;
  mailbox_list->next      = NULL;
  mailbox_list->prev      = NULL;

  return(mailbox_list);

}

void free_message_list(message_list, recurse, free_messages) 
     Message_List *message_list;
     Boolean recurse;
     Boolean free_messages;
{

  if(message_list == NULL)
    return;
  if(recurse)
    free_message_list(message_list->next, recurse, free_messages);
  if(free_messages)
    free_message(message_list->message);
  fs_give((void **) &message_list);
  return;

}

Mailbox *new_mailbox()
{

  Mailbox *mailbox = (Mailbox *) fs_get(sizeof(Mailbox));

  mailbox->mailstream     = NULL;
  mailbox->host           = NULL;
  mailbox->mailboxname    = NULL;
  mailbox->imapname       = NULL;
  mailbox->type           = MAILBOX_TYPE_MAIL;
  mailbox->fetched        = FALSE;
  mailbox->has_new_mail   = FALSE;
  mailbox->nmsgs          = 0L;
  mailbox->found          = NULL;
  mailbox->flags_changed  = 0L;
  mailbox->update_needed  = 0;
  mailbox->refresh_needed = 0;
  mailbox->timer          = (XtIntervalId) 0;
  mailbox->next           = NULL;
  mailbox->prev           = NULL;

  return(mailbox);

}


void free_mailbox(mailbox)
     Mailbox *mailbox;
{

  if(mailbox != NULL) {
    if(mailbox->host)
      fs_give((void **) &mailbox->host);
    if(mailbox->mailboxname)
      fs_give((void **) &mailbox->mailboxname);
    if(mailbox->imapname)
      fs_give((void **) &mailbox->imapname);

    if(mailbox->found)
      free_message_list(mailbox->found,TRUE,FALSE);

    fs_give((void **) &mailbox);
  }
  return;
}


View *new_view()
{

  View *view = (View *) fs_get(sizeof(View));
  
  view->is_realized       = FALSE;
  view->list_is_realized  = FALSE;
  view->hide_empty        = preferences.hide_empty;
  return view;

}


Lview *new_lview()
{

  Lview *lview = (Lview *) fs_get(sizeof(Lview));

  lview->title            = NULL;
  lview->mailstream       = NULL;
  lview->mailbox          = NULL;
  lview->message_list     = NULL;
  lview->count            = 0L;
  lview->num_selected     = 0L;
  lview->has_new          = FALSE;
  lview->selected         = FALSE;
  lview->number           = 0L;
  lview->button_state     = BTN_ON;
  lview->level            = 0;
  lview->scripting        = FALSE;
  lview->script_arg       = NULL;
  lview->script_header    = HEADER_UNKNOWN;

  lview->filter           = NULL;
  lview->parent           = NULL;
  lview->next             = NULL;
  lview->prev             = NULL;
  
  return(lview);


}


void free_lview(lview)
     Lview *lview;
{
  if(lview) {
    if(lview->title)
      fs_give((void **) &lview->title);
    if(lview->script_arg)
      fs_give((void **) &lview->script_arg);

    fs_give((void **) &lview);
  }

  return;
}


Filter *new_filter()
{

  Filter *filter = (Filter *) fs_get(sizeof(Filter));

  filter->mailboxname     = NULL;
  filter->name            = NULL;
  filter->text            = NULL;
  filter->action          = NULL;
  filter->search_tree     = NULL;
  filter->search_types    = 0L;
  filter->archived        = FALSE;
  filter->filter_type     = FILTER_TYPE_UNKNOWN;
  filter->number          = 0L;
  filter->next            = NULL;
  filter->prev            = NULL;

  return(filter);

}

void free_filter(filter)
     Filter *filter;
{
  if(filter) {
    if(filter->mailboxname) 
      fs_give((void **) &filter->mailboxname);
    if(filter->name)
      fs_give((void **) &filter->name);
    if(filter->action)
      fs_give((void **) &filter->action);
    if(filter->text)
      fs_give((void **) &filter->text);

    cut_down_the_tree(filter->search_tree);

    fs_give((void **) &filter);
  }
  return;
}


Message_List *new_message_list()
{

  Message_List *message_list = (Message_List *) fs_get(sizeof(Message_List));

  message_list->message     = NULL;
  message_list->selected    = NULL;
  message_list->number      = 0L;
  message_list->prev        = NULL;
  message_list->next        = NULL;

  return(message_list);

}
     

Message *new_message()
{

  Message *message = (Message *) fs_get(sizeof(Message));
  
  message->msgno            = 0L;
  message->mailbox          = NULL;
  message->mailstream       = NULL;
  message->envelope         = NULL;
  message->body             = NULL;
  message->longcache        = NULL;
  message->viewline         = NULL;
  message->in_view          = FALSE;
  message->header           = NULL;
  message->text             = NULL;
  message->ext_text         = NULL;

  return(message);

}


void free_message(message)
     Message *message;
{

  if(message == NULL)
    return;

  if(message->viewline)
    XmStringFree(message->viewline);

  if(message->header)
    fs_give((void **) &message->header);

  if(message->text)
    fs_give((void **) &message->text);

  if(message->ext_text)
    fs_give((void **) &message->ext_text);

  fs_give((void **) &message);

}




Edit *new_edit()
{
  Edit *edit = (Edit *) fs_get(sizeof(Edit));
  
  edit->is_realized         = FALSE;
  edit->buffer              = NULL;
  edit->begin               = 0;
  edit->end                 = 0;

  return(edit);

}


void free_edit(edit)
     Edit *edit;
{
  if(edit->buffer)
    fs_give((void **) &edit->buffer);
  fs_give((void **) &edit);

}


Dir_Struct *new_dir_struct()
{

  Dir_Struct *dir_struct = (Dir_Struct *) fs_get(sizeof(Dir_Struct));

  dir_struct->name       = NULL;
  dir_struct->directory  = FALSE;
  dir_struct->next       = NULL;

  return(dir_struct);

}

void free_dir_structs(dir_struct)
     Dir_Struct *dir_struct;
{
  if(dir_struct == NULL)
    return;
  free_dir_structs(dir_struct->next);
  if(dir_struct->name)
    fs_give((void **) &dir_struct->name);
  fs_give((void **) &dir_struct);

  return;
}


Address_Book_Info *new_address_book_info()
{

  Address_Book_Info *address_book_info =
    (Address_Book_Info *) fs_get(sizeof(Address_Book_Info));

  address_book_info->name    = NULL;
  address_book_info->address = NULL;
  address_book_info->comment = NULL;
  address_book_info->next    = NULL;
  address_book_info->prev    = NULL;

  return(address_book_info);

}


void free_address_book_info(address_book_info)
     Address_Book_Info *address_book_info;
{
  if(address_book_info == NULL)
    return;

  if(address_book_info->name)
    fs_give((void **) &address_book_info->name);
  if(address_book_info->address)
    fs_give((void **) &address_book_info->address);
  if(address_book_info->comment)
    fs_give((void **) &address_book_info->comment);
  
  fs_give((void **) &address_book_info);

}



Read_Info *new_read_info() 
{

  Read_Info *read_info = (Read_Info *) fs_get(sizeof(Read_Info));

  read_info->message_type     = MESSAGE_NORMAL;
  read_info->mailbox_type     = MAILBOX_TYPE_MAIL;
  read_info->mailstream       = NULL;
  read_info->msgno            = 0L;
  read_info->fetched          = FALSE;
  read_info->server           = NULL;
  read_info->current_part_str = NULL;
  read_info->base_part_str    = NULL;
  read_info->short_header     = NULL;
  read_info->header           = NULL;
  read_info->current_text     = NULL;
  read_info->alt_text         = NULL;
  read_info->current_part     = NULL;
  read_info->body             = NULL;
  read_info->envelope         = NULL;
  read_info->attachments      = NULL;
  read_info->button_state     = BTN_ON | BTN_LONG_HEADER;
  read_info->number           = 0L;
  read_info->selection        = 0L;
  read_info->show_long_header = FALSE;
  read_info->show_entire      = FALSE;
  read_info->show_alt         = FALSE;
  read_info->rfc_msg_leaf     = FALSE;
  read_info->part_list        = NULL;
  read_info->next             = NULL;
  read_info->prev             = NULL;

  return(read_info);

}


void free_read_info(read_info)
     Read_Info *read_info;
{

  if(read_info == NULL)
    return;
  read_info->msgno = 0L;
  if(read_info->current_part_str)
    fs_give((void **) &read_info->current_part_str);
  if(read_info->base_part_str)
    fs_give((void **) &read_info->base_part_str);
  if(read_info->short_header)
    fs_give((void **) &read_info->short_header);
  if(read_info->header)
    fs_give((void **) &read_info->header);
  if(read_info->current_text)
    fs_give((void **) &read_info->current_text);
  if(read_info->alt_text)
    fs_give((void **) &read_info->alt_text);
  if(read_info->part_list)
    destroy_part_list(read_info->part_list);


  fs_give((void **) &read_info);

}

Read *new_read()
{

  Read *read = (Read *) fs_get(sizeof(Read));
  
  read->current       = NULL;
  read->read_info     = NULL;
  read->is_realized   = FALSE;

  return(read);

}



Mime_Handler *new_mime_handler()
{
  Mime_Handler *mime_handler = (Mime_Handler *) fs_get(sizeof(Mime_Handler));

  mime_handler->type          = TYPEOTHER;
  mime_handler->subtype       = NULL;
  mime_handler->view_builtin  = FALSE;
  mime_handler->builtin       = NULL;
  mime_handler->view          = NULL;
  mime_handler->compose       = NULL;
  mime_handler->next          = NULL;

  return(mime_handler);

}
