/* filefncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"


Widget append_shell;




void dir_accept();
void dir_cancel();
void dir_dir_select();
void dir_dir_enter();
void dir_file_select();
void dir_stuff();
void dir_sort();
void dir_select_filter();
void dir_apply_filter();
void dir_hide_dot();
void dir_show_dot();
void dir_help();
int get_append_mode();


Menu dir_option_menu[] = {

  { "Hide Dot Files", "DIR_HIDE", 'H',
      dir_hide_dot, NULL, 0, NULL, NULL, BTN_HIDEDOT },
  { "Show Dot Files", "DIR_SHOW", 'S',
      dir_show_dot, NULL, 0, NULL, NULL, BTN_NOHIDEDOT },

};

Menu dir_menu[] = {
  { "Accept", "DIR_ACCEPT", 'A',
      dir_accept, NULL, 0, NULL, NULL, BTN_ON },
  { "Cancel", "DIR_CANCEL", 'C',
      dir_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Options", "DIR_OPTIONS", 'O',
      NULL, dir_option_menu, XtNumber(dir_option_menu), NULL, NULL, BTN_ON },

  { "Help", "DIR_HELP!", 'H',
      dir_help, NULL, 0, NULL, NULL, BTN_ON },
};


char *file_select(w,initial_dir,initial_pattern,initial_file,
		  op_write,op_append)
     Widget w;
     char *initial_dir;
     char *initial_pattern;
     char *initial_file;
     Boolean op_write;
     Boolean *op_append;
{
  Arg args[ARGLISTSIZE];
  int n = 0;
  XtTranslations translations;
  Position x, y;
  char *filename = NULL;
  int append_mode;
  Dirview *dirview;
  Widget form, menubar, label1, label2, label3;

  set_watch_cursors();
  dirview = (Dirview *) fs_get(sizeof(Dirview));
  dirview->done = 0;
  dirview->recurse = 0;
  dirview->ignore_dot = TRUE;
  dirview->button_state = BTN_HIDEDOT;

  XtSetArg(args[n], XmNallowShellResize, TRUE ); n ++;

  get_pointer_position(w, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  if(op_write == TRUE)
    XtSetArg(args[n], XmNtitle, "Save to File:");
  else
    XtSetArg(args[n], XmNtitle, "Read from File:");
  n ++;


  dirview->shell = XtCreatePopupShell("Files",
				      transientShellWidgetClass, w,
				      args, n ); n = 0;

  XmAddTabGroup(dirview->shell);

  form = XmCreateForm(dirview->shell, "form", args, n); n = 0;


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form,"menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, 
		      dir_menu, XtNumber(dir_menu), BTN_ON, dirview);

  if(initial_dir)
    dirview->cwd = cpystr(initial_dir);
  else
    dirview->cwd = cpystr(local_auth.homedir);

  dirview->dir_struct = NULL;

  dirview->dir_path = 
    create_text_field(form, menubar,
		      "Directory:", dirview->cwd, 32, dir_dir_enter, dirview);

  dirview->dir_pattern = 
    create_text_field(form, dirview->dir_path,
		      "Filter   :", 
		      (initial_pattern) ? initial_pattern : FILE_PATTERN_STR,
		      32, dir_select_filter, dirview);

  dirview->dir_file =
    create_text_field(form,dirview->dir_pattern,
		      "Filename :", initial_file, 32, dir_accept, dirview );

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_WIDGET    ); n ++;
  XtSetArg(args[n], XmNtopWidget,       dirview->dir_file  ); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM      ); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION  ); n ++;
  XtSetArg(args[n], XmNrightPosition,   50                 ); n ++;
  XtSetArg(args[n], XmNborderWidth,     0                  ); n ++;

  label1 = XmCreateLabel(form, "Directories", args, n);       n = 0;
  XtManageChild(label1);

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_WIDGET    ); n ++;
  XtSetArg(args[n], XmNtopWidget,       dirview->dir_file  ); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_POSITION  ); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM      ); n ++;
  XtSetArg(args[n], XmNleftPosition,    50                 ); n ++;
  XtSetArg(args[n], XmNborderWidth,     0                  ); n ++;

  label2 = XmCreateLabel(form, "Files", args, n);             n = 0;
  XtManageChild(label2);


  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n ++;
  XtSetArg(args[n], XmNlistSizePolicy,XmCONSTANT); n ++;
  XtSetArg(args[n], XmNvisibleItemCount, 15 ); n ++; 
  XtSetArg(args[n], XmNselectionPolicy,XmSINGLE_SELECT); n ++;
  dirview->dir_dirlist = XmCreateScrolledList(form,"dirlist",args,n); n = 0;
  XtAddCallback(dirview->dir_dirlist,	XmNsingleSelectionCallback, 
		dir_dir_select, dirview);
  XtAddCallback(dirview->dir_dirlist,	XmNdefaultActionCallback, 
		dir_dir_select, dirview);
  translations = 
    XtParseTranslationTable(GLOBAL_modal_list_translations);
  XtOverrideTranslations(dirview->dir_dirlist,translations);

  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, label1); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n ++;
  XtSetArg(args[n], XmNrightPosition, 50); n ++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n ++;

  XtSetValues(XtParent(dirview->dir_dirlist), args, n); n = 0;

  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n ++;
  XtSetArg(args[n], XmNlistSizePolicy,XmCONSTANT); n ++;
  XtSetArg(args[n], XmNvisibleItemCount, 15 ); n ++; 
  XtSetArg(args[n], XmNselectionPolicy,XmSINGLE_SELECT); n ++;
  dirview->dir_filelist = 
    XmCreateScrolledList(form,"filelist",args,n); n = 0;
  XtAddCallback(dirview->dir_filelist,	XmNsingleSelectionCallback, 
		dir_file_select, dirview);
  XtAddCallback(dirview->dir_filelist,	XmNdefaultActionCallback, 
		dir_accept, dirview);
  translations = 
    XtParseTranslationTable(GLOBAL_modal_list_translations);
  XtOverrideTranslations(dirview->dir_filelist,translations);


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, label2); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n ++;
  XtSetArg(args[n], XmNleftPosition, 50); n ++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n ++;

  XtSetValues(XtParent(dirview->dir_filelist), args, n); n = 0;

  XtManageChild(dirview->dir_dirlist);
  XtManageChild(dirview->dir_filelist);

  check_buttons(dir_menu, XtNumber(dir_menu),dirview->button_state);

  XtManageChild(form);
  XtManageChild(dirview->shell);
  set_pirate_cursors();

  dir_stuff(dirview);

  XtPopup(dirview->shell,XtGrabExclusive);
  
  modal_main_loop(&dirview->done);
  
  XtPopdown(dirview->shell);
  XtDestroyWidget(dirview->shell);
  XFlush(display);
  
  
  if((dirview->pathname) && (*(dirview->pathname) != NUL_TERM)) {
    if(*dirview->pathname == PATH_SEPARATOR_CHAR)
      filename = cpystr(dirview->pathname);
    else {
      filename = (char *) fs_get(MAXPATHLEN + 1);
      strcpy(filename,dirview->cwd);
      if(filename[strlen(filename) - 1] != PATH_SEPARATOR_CHAR)
	strcat(filename,PATH_SEPARATOR_STR);
      strcat(filename,dirview->pathname);
    }
  }

  free_dir_structs(dirview->dir_struct);
  if(dirview->pathname)
    fs_give((void **) &dirview->pathname);
  if(dirview->cwd)
    fs_give((void **) &dirview->cwd);

  fs_give((void **) &dirview);

  if(filename != NULL && (op_write == TRUE)) {

    append_mode = get_append_mode(w,filename);
    if(append_mode == (-1)) {
      fs_give((void **) &filename);
      filename = NULL;
    }
    if(append_mode == 1)
      *op_append = FALSE;
    if(append_mode == 2)
      *op_append = TRUE;

  }

  reset_cursors();

  return(filename);


}

void append_cancel();
void append_overwrite();
void append_append();
void append_help();


Menu append_menu[] = {
  { "Cancel", "append_cancel", 'C',
      append_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Overwrite", "append_overwrite", 'O',
      append_overwrite, NULL, 0, NULL, NULL, BTN_ON },
  { "Append", "append_append", 'A',
      append_append, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "append_HELP!", 'H',
      append_help, NULL, 0, NULL, NULL, BTN_ON },
};



int get_append_mode(w,filename)
     Widget w;
     char *filename;
{
  Arg args[ARGLISTSIZE];
  int n = 0;
  Position x, y;
  int append_mode = 0;
  Widget form, menubar, label;
  struct stat st;

  if((stat(filename,&st)) == SYSCALL_FAILURE)
    return(1);

  if(! S_ISREG(st.st_mode)) {
    mm_log("Selected file is not a regular file.", WARN);
    return(-1);
  }

  XtSetArg(args[n], XmNallowShellResize, TRUE ); n ++;

  get_pointer_position(w, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  append_shell = XtCreatePopupShell("File Options",
				      transientShellWidgetClass, w,
				      args, n ); n = 0;

  form = XmCreateForm(append_shell, "form", args, n); n = 0;


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form,"menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, 
		      append_menu, XtNumber(append_menu), 
		      BTN_ON, &append_mode);

  
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, menubar); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n ++;

  label = XmCreateLabel(form, "File exists. Please choose option.",
			args,n); n = 0;
  XtManageChild(label);
  XtManageChild(form);
  XtManageChild(append_shell);
  XtPopup(append_shell, XtGrabExclusive);

  modal_main_loop(&append_mode);
  
  XtPopdown(append_shell);
  XtDestroyWidget(append_shell);
  XFlush(display);

  return(append_mode);

}


void append_cancel(w,append_mode,xp)
     Widget w;
     int *append_mode;
     XtPointer xp;
{
  *append_mode = (-1);
}

void append_overwrite(w,append_mode,xp)
     Widget w;
     int *append_mode;
     XtPointer xp;
{
  *append_mode = 1;
}

void append_append(w,append_mode,xp)
     Widget w;
     int *append_mode;
     XtPointer xp;
{
  *append_mode = 2;
}

void append_help(w,append_mode,xp)
     Widget w;
     int *append_mode;
     XtPointer xp;
{
  help(append_shell,"File Options", "fileoption.help");
}




void dir_dir_select(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XmListCallbackStruct *xp;
{
  
  char *str;
  char *ptr;
  char *newdir;

  XmStringGetLtoR(xp->item,XmSTRING_DEFAULT_CHARSET,&str);
  if(strcmp(str,FILE_GO_HOME) == STRMATCH) 
    newdir = cpystr(local_auth.homedir);
  else { 
    if(strcmp(str,FILE_GO_UP) == STRMATCH) {
      newdir = GetTextField(dirview->dir_path);
      if(((ptr = strrchr(newdir,PATH_SEPARATOR_CHAR)) != NULL)
	 && (ptr > newdir))
	*ptr = NUL_TERM;
      if(ptr == newdir)
	*(ptr + 1) = NUL_TERM;
    }
    else {
      AppendText(dirview->dir_path,PATH_SEPARATOR_STR);
      AppendText(dirview->dir_path,str);
      newdir = GetTextField(dirview->dir_path);
    }
  }

  fs_give((void **) &str);
  dir_set(dirview,newdir);
  fs_give((void **) &newdir);

}

void dir_dir_enter(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XmListCallbackStruct *xp;
{
  
  char *newdir = GetTextField(dirview->dir_path);
  dir_set(dirview,newdir);
  fs_give((void **) &newdir);
  XmProcessTraversal(w,XmTRAVERSE_NEXT_TAB_GROUP);

}



void dir_file_select(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XmListCallbackStruct *xp;
{

  char *str;

  XmStringGetLtoR(xp->item,XmSTRING_DEFAULT_CHARSET,&str);
  XmTextSetString(dirview->dir_file,str);

  fs_give((void **) &str);

  XmListDeselectAllItems(dirview->dir_filelist);

}


void dir_accept(w,dirview,e)
     Widget w;
     Dirview *dirview;
     XEvent *e;
{
  
  dirview->pathname = XmTextGetString(dirview->dir_file);
  if(*dirview->pathname == NUL_TERM) {
    fs_give((void **) &dirview->pathname);
    dirview->pathname = NULL;
  }

  dirview->done = 1;


}


void dir_cancel(w,dirview,e)
     Widget w;
     Dirview *dirview;
     XEvent *e;
{
 
  dirview->pathname = NULL;
  dirview->done = 1;


}


void dir_hide_dot(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XtPointer xp;
{
  dirview->ignore_dot = TRUE;
  dirview->button_state |= BTN_HIDEDOT;
  dirview->button_state &= ~(BTN_NOHIDEDOT);


  dir_apply_filter(w,dirview,xp);

  check_buttons(dir_menu, XtNumber(dir_menu),dirview->button_state);

}


void dir_show_dot(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XtPointer xp;
{
  dirview->ignore_dot = FALSE;
  dirview->button_state &= ~(BTN_HIDEDOT);
  dirview->button_state |= BTN_NOHIDEDOT;

  dir_apply_filter(w,dirview,xp);

  check_buttons(dir_menu, XtNumber(dir_menu),dirview->button_state);


}

void dir_select_filter(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XtPointer xp;
{
  dir_apply_filter(w,dirview,xp);
  XmProcessTraversal(w,XmTRAVERSE_NEXT_TAB_GROUP);
}


void dir_help(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XtPointer xp;
{

  help(dirview->shell,"Help - File Selection","fileselect.help");
}



void dir_apply_filter(w,dirview,xp)
     Widget w;
     Dirview *dirview;
     XtPointer xp;
{

  Dir_Struct *dir_struct;
  char *pattern;
  XmString xstr;

  XmListDeselectAllItems(dirview->dir_dirlist);
  XmListDeleteAllItems(dirview->dir_dirlist);
  XmListDeselectAllItems(dirview->dir_filelist);
  XmListDeleteAllItems(dirview->dir_filelist);

  pattern = GetTextField(dirview->dir_pattern);

  xstr = XmStringCreateSimple(FILE_GO_HOME);
  XmListAddItemUnselected(dirview->dir_dirlist,xstr,0);
  XmStringFree(xstr);

  xstr = XmStringCreateSimple(FILE_GO_UP);
  XmListAddItemUnselected(dirview->dir_dirlist,xstr,0);
  XmStringFree(xstr);
  
  for(dir_struct = dirview->dir_struct;
      dir_struct;
      dir_struct = dir_struct->next) {
    if((dirview->ignore_dot) && (*dir_struct->name == '.'))
      continue;
    
    if((dir_struct->directory == FALSE) 
       && (wildmat(dir_struct->name,pattern) == 0))
      continue;

    xstr = XmStringCreateSimple(dir_struct->name);
    if(dir_struct->directory) 
      XmListAddItemUnselected(dirview->dir_dirlist,xstr,0);
    else
      XmListAddItemUnselected(dirview->dir_filelist,xstr,0);
    XmStringFree(xstr);
  }

  return;


}



dir_set(dirview,path)
     Dirview *dirview;
     char *path;
{
  if(dirview->cwd) 
    fs_give((void **) &dirview->cwd);
  dirview->cwd = cpystr(path);
  XmTextSetString(dirview->dir_path,path);
  dir_stuff(dirview);

}


void dir_stuff(dirview)
     Dirview *dirview;
{

  DIR *d;
  struct dirent *e;
  Dir_Struct *dir_struct;
  char filename[MAXPATHLEN];
  struct stat st;

  XDefineCursor(display,XtWindow(dirview->shell), clock_cursor);
  XFlush(display);

  /* 
   * A few precautions. Since the dirview->cwd string and dir_path window
   * have already been updated, we don't know where we came from if this fails.
   * So we default to going home on failure. BUT, we need to also make
   * sure we can do THAT. That's why the recursion counter. If we can't
   * go home, no sense going on, so we hardwire a "cancel" operation.
   * In any event, let the user know something wierd is going on.
   */

  if((d = opendir(dirview->cwd)) == NULL) {
    mm_log("Can't access directory. Resetting to home directory.",WARN);
    if(dirview->recurse < 2) {
      dirview->recurse ++;
      dir_set(dirview,local_auth.homedir);
    }
    else {
      mm_log("Can't access home directory. Operation cancelled.",ERROR);
      dirview->pathname = NULL;
      dirview->done = TRUE;
    }
    XBell(display,1000);
    XUndefineCursor(display,XtWindow(dirview->shell));
    XFlush(display);
    return;
  }
  
  dirview->recurse = 0;

  free_dir_structs(dirview->dir_struct);
  dirview->dir_struct = NULL;

  while((e = readdir(d)) != NULL) {
    if((strcmp(e->d_name,THISDIR_STR) == STRMATCH)
       || (strcmp(e->d_name,PARENTDIR_STR) == STRMATCH))
      continue;
    sprintf(filename,"%s/%s",dirview->cwd,e->d_name);
    if(stat(filename,&st) != SYSCALL_SUCCESS)
      continue;

    dir_struct = new_dir_struct();
    dir_struct->name = cpystr(e->d_name);
    dir_struct->directory = (S_ISDIR(st.st_mode)) ? TRUE : FALSE;
    dir_struct->next = dirview->dir_struct;
    dirview->dir_struct = dir_struct;

  }

  closedir(d);

  dir_sort(dirview);

  dir_apply_filter(dirview->shell,dirview,NULL);

  XUndefineCursor(display,XtWindow(dirview->shell));
  XFlush(display);
}


int dir_compare(name1,name2)
     Dir_Struct **name1, **name2;
{

  return(strcmp((*(name1))->name,(*(name2))->name));

}


void dir_sort(dirview)
     Dirview *dirview;
{

  Dir_Struct **sort;
  Dir_Struct *dir_struct;
  int n = 0;
  int total = 0;


  for(dir_struct = dirview->dir_struct; 
      dir_struct; dir_struct = dir_struct->next)
    total ++;

  if(total < 2)
    return;

  sort = (Dir_Struct **) fs_get(total * sizeof(Dir_Struct *));

  
  for(dir_struct = dirview->dir_struct; 
      dir_struct; dir_struct = dir_struct->next) {
    sort[n] = dir_struct;
    n ++;
  }

  qsort((char *) sort, total, sizeof(Dir_Struct **), dir_compare);

  for(n = 0; n < total; n ++) {
    dir_struct = sort[n];
    if(n == 0)
      dirview->dir_struct = dir_struct;
    if(n < (total - 1))
      dir_struct->next = sort[n + 1];
    else
      dir_struct->next = NULL;
  }
  
  fs_give((void **) &sort);

}

