/* buttons.h
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */


typedef struct _menu_structure_ {
  char                       *label;
  char                       *name;
  char                       mnemonic;
  void                       (*func)();
  struct _menu_structure_    *sub_menu;
  int                        size;
  caddr_t                    data;
  Widget                     widget;
  unsigned long              statemap;
} Menu;



/* Global menu states */

#define BTN_ON          ((unsigned long) 0 )       /* always on         */
#define BTN_INSENSITIVE ((unsigned long) 1 << 0 )  /* always disabled   */
#define BTN_NOSELECTION ((unsigned long) 1 << 1 )  /* no items selected */
#define BTN_SELECTION   ((unsigned long) 1 << 2 )  /* item(s) selected  */
#define BTN_NOPREV      ((unsigned long) 1 << 3 )  /* no prev window    */
#define BTN_NONEXT      ((unsigned long) 1 << 4 )  /* no next window    */
#define BTN_ISNEWS      ((unsigned long) 1 << 5 )  /* a newsgroup       */

/* Read, Compose, View menu states */

#define BTN_NOKEYWORDS        ((unsigned long) 1 << 6)
#define BTN_NOATTACH          ((unsigned long) 1 << 7)
#define BTN_NOATTACHSELECT    ((unsigned long) 1 << 8)
#define BTN_NOSIGFILE         ((unsigned long) 1 << 9)
#define BTN_NOPGP             ((unsigned long) 1 << 10)
#define BTN_SHORT_HEADER      ((unsigned long) 1 << 11)
#define BTN_LONG_HEADER       ((unsigned long) 1 << 12)
#define BTN_SHOW_ENTIRE       ((unsigned long) 1 << 13)
#define BTN_SHOW_CODED        ((unsigned long) 1 << 14)
#define BTN_SHOW_NORMAL       ((unsigned long) 1 << 15)

/* Main menu states */

#define BTN_NOMAILBOXESOPEN      ((unsigned long) 1 << 16) 

/* file selector menu states */

#define BTN_NOHIDEDOT            ((unsigned long) 1 << 17)
#define BTN_HIDEDOT              ((unsigned long) 1 << 18)

/* mailbox selector menu states */ 

#define BTN_MAILBOX_NOEDIT       ((unsigned long) 1 << 19)
#define BTN_MAILBOX_DONEWS       ((unsigned long) 1 << 20)
#define BTN_MAILBOX_DOMAIL       ((unsigned long) 1 << 21)
#define BTN_OLD_SERVER           ((unsigned long) 1 << 22)
