/* buttons.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */


#include "ml.h"

void flush_windows();


/*
 * void create_menu_buttons();
 *
 * Creates cascading menus on a menubar (parent widget must be a menubar).
 * If a menulist item already contains a callback data item it will
 * be used. Otherwise the data passed to the function will be used.
 * A button name containing the string "HELP!" will be set up on the
 * right hand side of the menubar. Names should be unique. This allows
 * us to track down the buttons later and change their state or callback,
 * regardless of the label -- which may have been changed.
 * Button state is determined by the menulist->state variable. Each bit
 * indicates a condition this button should be checked against ( a '1' bit
 * indicates the button should be insensitive when the condition matches.
 * The state variable passed to this function is used to determine initial 
 * sensitive state. 
 */


#ifdef __STDC__
void create_menu_buttons(char *title, Widget menu, 
			 Menu *menulist, int size,
			 unsigned long state, XtPointer callback)
#else
void create_menu_buttons(title, menu, menulist, size, state, callback )
     char *title;
     Widget menu;
     Menu *menulist;
     int size;
     unsigned long state;
     XtPointer callback;
#endif
{
  Arg args[ARGLISTSIZE];
  int n = 0;
  int cnt;
  WidgetList buttons;
  XmString label;

  buttons = (WidgetList) XtMalloc(size * sizeof(Widget));

  for(cnt = 0; cnt < size; cnt ++) {
    if(menulist[cnt].func) {
      label = XmStringCreateSimple(menulist[cnt].label);
      XtSetArg(args[n], XmNlabelString, label); n ++;
      XtSetArg(args[n], XmNborderWidth, 0); n ++;
      if(menulist[cnt].mnemonic) {
	XtSetArg(args[n], XmNmnemonic, menulist[cnt].mnemonic); n ++;
      }
      if(state &  menulist[cnt].statemap) {
	XtSetArg(args[n],XmNsensitive, FALSE); n ++;
      }
      buttons[cnt] = XmCreateCascadeButton(menu, NULL, args, n); n = 0;
      menulist[cnt].widget = buttons[cnt];
      XmStringFree(label);
      XtAddCallback(buttons[cnt],XmNactivateCallback, flush_windows, NULL );
      XtAddCallback(buttons[cnt],XmNactivateCallback, menulist[cnt].func, 
		    (menulist[cnt].data) ? menulist[cnt].data : callback);
    }
    else {
      Widget submenu;
      submenu = XmCreatePulldownMenu(menu,menulist[cnt].label,NULL,0);
      label = XmStringCreateSimple(menulist[cnt].label);
      XtSetArg(args[n], XmNlabelString, label); n ++;
      XtSetArg(args[n], XmNsubMenuId, submenu); n ++;
      XtSetArg(args[n], XmNborderWidth, 0); n ++;
      if(menulist[cnt].mnemonic) {
	XtSetArg(args[n], XmNmnemonic, menulist[cnt].mnemonic); n ++;
      }
      if(state &  menulist[cnt].statemap) {
	XtSetArg(args[n],XmNsensitive, FALSE); n ++;
      }
      buttons[cnt] = XmCreateCascadeButton(menu, NULL, args, n); n = 0;
      menulist[cnt].widget = buttons[cnt];
      XmStringFree(label);
      create_menu_buttons(menulist[cnt].label, submenu, menulist[cnt].sub_menu,
			  menulist[cnt].size, state, callback);
    }
  }
  XtManageChildren(buttons, size);
  for(cnt = 0; cnt < size; cnt ++) {
    if((strstr(menulist[cnt].name,"HELP!")) != NULL) {
      XtSetArg(args[n],XmNmenuHelpWidget, buttons[cnt]); n ++;
      XtSetValues(menu, args, n);
      n = 0;
    }
  }
  
  return;
}
      



void check_buttons(menulist, size, state)
     Menu *menulist;
     int size;
     unsigned long state;
{


  Arg args[ARGLISTSIZE];
  int n = 0;
  int cnt;

  for(cnt = 0; cnt < size; cnt ++) {
    if(menulist[cnt].func) {
      if(state &  menulist[cnt].statemap) {
	XtSetArg(args[n],XmNsensitive, FALSE); n ++;
      }
      else {
	XtSetArg(args[n],XmNsensitive, TRUE); n ++;
      }
      XtSetValues(menulist[cnt].widget, args, n); n = 0;
    }
    else {
      if(state &  menulist[cnt].statemap) {
	XtSetArg(args[n],XmNsensitive, FALSE); n ++;
      }
      else {
	XtSetArg(args[n],XmNsensitive, TRUE); n ++;
      }
      XtSetValues(menulist[cnt].widget, args, n); n = 0;
      check_buttons(menulist[cnt].sub_menu,menulist[cnt].size,state);
    }
  }
}



void flush_windows(w,xp,cb) 
     Widget w;
     XtPointer xp;
     XtPointer cb;
{

  XFlush(display);

}
