/*
 * Program:	Operating-system dependent routines -- Altos SVR4 version
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	10 April 1992
 * Last Edited:	30 November 1994
 *
 * Copyright 1994 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made
 * available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "tcp_unix.h"		/* must be before osdep includes tcp.h */
#include "mail.h"
#include "osdep.h"
#undef flock
#include <ctype.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/tiuser.h>
#include <sys/stropts.h>
#include <sys/poll.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <pwd.h>
#include <sys/file.h>
#include <sys/socket.h>
#include "misc.h"

extern int sys_nerr;
extern char *sys_errlist[];

#define toint(c)	((c)-'0')
#define isodigit(c)	(((unsigned)(c)>=060)&((unsigned)(c)<=067))

#define DIR_SIZE(d) d->d_reclen

#define pid_t short		/* may not be known on all ASV systems */

#include "strstr.c"
#include "fs_unix.c"
#include "ftl_unix.c"
#include "nl_unix.c"
#include "env_unix.c"
#include "tcp_unix.c"
#include "log_std.c"
#include "gr_waitp.c"
#include "strerror.c"
#include "flock.c"
#include "gettime.c"
#include "scandir.c"
#include "tz_sv4.c"
#include "ingroups.c"
#include "memmove.c"

/* Emulator for BSD gethostid() call
 * Returns: unique identifier for this machine
 */

unsigned long gethostid ()
{
  /* No gethostid() here, so just fake it and hope things turn out okay. */
  return (unsigned long) 0xdeadface;
}


/* Emulator for BSD fsync() call
 * Accepts: file name
 * Returns: 0 if successful, -1 if failure
 */

int fsync (fd)
	int fd;
{
  sync ();
  return 0;
}


/* Emulator for BSD writev() call
 * Accepts: file name
 *	    I/O vector structure
 *	    Number of vectors in structure
 * Returns: 0 if successful, -1 if failure
 */

int writev (fd,iov,iovcnt)
	int fd;
	struct iovec *iov;
	int iovcnt;
{
  int c,cnt;
  if (iovcnt <= 0) return (-1);
  for (cnt = 0; iovcnt != 0; iovcnt--, iov++) {
    c = write (fd,iov->iov_base,iov->iov_len);
    if (c < 0) return -1;
    cnt += c;
  }
  return cnt;
}


/* Emulator for BSD setgroups() routine
 * Accepts: number of groups
 *          group matrix
 */

int setgroups (n,grps)
	int n;
	int grps[NGROUPS];
{
  return 0;			/* no-op for now */
}
