/*
 * Copyright (c) 1991, 1992, 1993 
 * Regents of the University of Michigan.  All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifdef DOS
#include "protoud.h"
#define strncasecmp(a, b, n)	strnicmp(a, b, n)
#define strcasecmp(a, b)	stricmp(a, b)
#define MAX_VALUES	8
#else
#define MAX_VALUES	150
#endif /* end of DOS ifdef */

/*
 *  Friendly map file used by ldap_friendly_name.
 */
#define LDAP_FRIENDLY_MAP_FILE	"/usr/local/etc/ldapfriendly"

/*
 *  Names are parsed somewhat like 'awk' parses them.  This is the
 *  maximum number of components we store away.
 *
 *  The isnamesepartor() macro should return TRUE if x is equal to one of the
 *  characters that delimits name fields.  The ignorechar() macro should
 *  return TRUE if it is equal to a character that should be ignored when
 *  parsing names.
 */
#define MAX_NAME_COMPS		8
#define isnamesepartor(x)	(isspace(x))
#define isignorechar(x)		(((x) == '.') || ((x) == '_'))

/*
 *  Quite often a search will turn up more than one match.  When it does we
 *  print out a list of the matches, and ask the user to select the one that
 *  s/he wants.  This defines how many we will save and show.
 */
#define MAX_NUM_NAMES		128

/*
 *  We allow the user to specify a list of filters to use when performing a
 *  search.  This defines the maximum number of permitted filters to try.
 */
#define MAX_SEARCH_PATH		16

/*
 *  When a user displays a group, we will automatically print out this many
 *  members and subscribers.  If the number is greater than this, we will
 *  prompt the user before printing them.
 */
#define TOO_MANY_TO_PRINT	16

/*
 *  This is the size of buffers we use to ask the user questions that can be
 *  answered with something short, like a 'yes' or 'no'.
 */
#define RESP_SIZE		16

/*
 *  Used to specify the operation in x_group().
 */
#define G_JOIN		0
#define G_RESIGN	1

/*
 *  Start-up defaults.
 *
 *	o Our config file
 *	o A per-user config file which takes precedence
 *	o The name that we use when initially binding
 *	o The DN that we use when initally binding
 *	o The password associated with this DN
 *	o The authentication method to use
 *	o The default LDAP server to use
 *	o The number of lines on a tty
 *	o The base to use when beginning a search
 *	o The place to create groups
 */
#define CONFIG_FILE		"/etc/ud.conf"
#define USER_CONFIG_FILE	".udrc"
#define DEFAULT_BOUND_AS	"Nobody"
#ifdef UOFM
#define UD_USER			"cn=ud, ou=Miscellaneous Servers, o=University of Michigan, c=US"
#else
#define UD_USER			NULL
#endif
#define UD_PASSWD		NULL
#ifdef KERBEROS
#define UD_AUTH_METHOD		LDAP_AUTH_KRBV4
#else
#define UD_AUTH_METHOD		LDAP_AUTH_SIMPLE
#endif
#define DEFAULT_SERVER		"ldap"
#define DEFAULT_LINES		24
#define WHERE_SEARCHES_START	"o=University of Michigan, c=US"
#define WHERE_GROUPS_LIVE	"ou=User Groups, ou=Groups, o=University of Michigan, c=US"

/*
 *  BSD-style signals or Sys V?
 */
#if defined(BSD) && BSD >= 199006 || defined(sparc) || defined(ultrix) || defined (NeXT) || defined(_AIX) || defined(VMS) || defined(__osf__)
#define SIG_FN	void		/* signal-catching functions return void */
#else
#ifdef SYSV
#define SYSV_SIGNALS
#define SIG_FN	void		/* signal-catching functions return void */
#else
#define SIG_FN	int		/* signal-catching functions return int */
#endif
#endif

/*
 *  Just in case we need them.
 */
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif


/* 
 *  Debug masks.
 */
#define	D_TRACE		0x0001
#define	D_FIND		0x0002
#define D_GROUPS	0x0004
#define D_MODIFY	0x0008
#define D_PARSE		0x0010
#define D_PRINT		0x0020
#define D_AUTHENTICAT	0x0040

/*
 *  These are the structures we use when parsing an answer we get from the LDAP
 *  server.
 */
struct attribute {
	int number_of_values;
	char *quipu_name;
	char *output_string;
	char **values;
};

#define LAST_ATTRIBUTE	(23 + 1)

struct entry2 {
	char may_join;
	int  subscriber_count;
	char *DN;
	char *name;
	struct attribute attrs[LAST_ATTRIBUTE];
};
