/*
	DNR.c - DNR library for MPW

	(c) Copyright 1988 by Apple Computer.  All rights reserved
	
	Modifications by Jim Matthews, Dartmouth College, 5/91
	Further modifications by Steve Falkenburg, Apple MacDTS 8/91
	Changes to remove globals by Gavin Eadie, U Michigan 9/92
	Changes to hide internal routines (static added) by Mark Smith, U Michigan 4/93
*/

#include <Errors.h>
#include <Folders.h>
#include <GestaltEqu.h>
#include <Memory.h>
#include <OSUtils.h>
#include <Resources.h>
#include <ToolUtils.h>
#include <Traps.h>

#include "AddressXLation.h"

#ifdef THINK_C
	#define	_Gestalt	0xA1AD
#endif

#define OPENRESOLVER	1L
#define CLOSERESOLVER	2L
#define STRTOADDR		3L
#define	ADDRTOSTR		4L
#define	ENUMCACHE		5L
#define ADDRTONAME		6L
#define	HINFO			7L
#define MXINFO			8L


TrapType GetTrapType(unsigned long );
Boolean TrapAvailable(unsigned long );
void GetSystemFolder(short * , long * );
void GetCPanelFolder(short * , long * );
short SearchFolderForDNRP(long , long , short , long );
short OpenOurRF(void );


OSErr OpenResolver(struct dnr_struct * dnr_global, char * fileName) {
	short refnum;
	OSErr rc;
	
	if (dnr_global->dnr != nil)						//	resolver already loaded
		return(noErr);
		
	/* open the MacTCP driver to get DNR resources. Search for it based on
	   creator & type rather than simply file name */	
	refnum = OpenOurRF();

	/* ignore failures since the resource may have been installed in the 
	   System file if running on a Mac 512Ke */
	   
	/* load in the DNR resource package */
	dnr_global->codeHndl = GetIndResource('dnrp', 1);
	if (dnr_global->codeHndl == nil) {				//	can't open DNR
		return(ResError());
	}
	
	DetachResource(dnr_global->codeHndl);
	if (refnum != -1) {
		CloseWD(refnum);							//	fix
		CloseResFile(refnum);
	}
		
	/* lock the DNR resource since it cannot be relocated while opened */
	MoveHHi(dnr_global->codeHndl);					// fix
	HLock(dnr_global->codeHndl);
	dnr_global->dnr = (DNRProcPtr) *dnr_global->codeHndl;
	
	/* call open resolver */
	rc = (*dnr_global->dnr)(OPENRESOLVER, fileName);
	if (rc != noErr) {
		/* problem with open resolver, flush it */
		HUnlock(dnr_global->codeHndl);
		DisposHandle(dnr_global->codeHndl);
		dnr_global->dnr = nil;
	}
	return(rc);
}


OSErr CloseResolver(struct dnr_struct * dnr_global) {
	if (dnr_global->dnr == nil)
		return (notOpenErr);						//	resolver not loaded
		
	/* call close resolver */
	(void) (*dnr_global->dnr)(CLOSERESOLVER);

	/* release the DNR resource package */
	HUnlock(dnr_global->codeHndl);
	DisposHandle(dnr_global->codeHndl);
	dnr_global->dnr = nil;
	return(noErr);
}


OSErr StrToAddr(struct dnr_struct * dnr_global, char * hostName, struct hostInfo * rtnStruct, ResultProcPtr resultproc, char * userDataPtr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	return((*dnr_global->dnr)(STRTOADDR, hostName, rtnStruct, resultproc, userDataPtr));
}
	

OSErr AddrToStr(struct dnr_struct * dnr_global, unsigned long addr, char * addrStr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	(*dnr_global->dnr)(ADDRTOSTR, addr, addrStr);
	return(noErr);
}
	

OSErr EnumCache(struct dnr_struct * dnr_global, EnumResultProcPtr resultproc, char * userDataPtr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	return((*dnr_global->dnr)(ENUMCACHE, resultproc, userDataPtr));
}
	
	
OSErr AddrToName(struct dnr_struct * dnr_global, unsigned long addr, struct hostInfo * rtnStruct, ResultProcPtr resultproc, char * userDataPtr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	return((*dnr_global->dnr)(ADDRTONAME, addr, rtnStruct, resultproc, userDataPtr));
}


extern OSErr HInfo(struct dnr_struct * dnr_global, char * hostName, struct returnRec * returnRecPtr, ResultProc2Ptr resultProc, char * userDataPtr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	return((*dnr_global->dnr)(HINFO, hostName, returnRecPtr, resultProc, userDataPtr));
}
	

extern OSErr MXInfo(struct dnr_struct * dnr_global, char * hostName, struct returnRec * returnRecPtr, ResultProc2Ptr resultProc, char * userDataPtr) {
	if (dnr_global->dnr == nil)
		return(notOpenErr);							//	resolver not loaded
		
	return((*dnr_global->dnr)(MXINFO, hostName, returnRecPtr, resultProc, userDataPtr));
}


static TrapType GetTrapType(unsigned long theTrap) {
	if (BitAnd(theTrap, 0x0800) > 0)
		return(ToolTrap);
	else
		return(OSTrap);
}
	
static Boolean TrapAvailable(unsigned long trap) {
	TrapType trapType = ToolTrap;
	unsigned long numToolBoxTraps;

	if (NGetTrapAddress(_InitGraf, ToolTrap) == NGetTrapAddress(0xAA6E, ToolTrap))
		numToolBoxTraps = 0x200;
	else
		numToolBoxTraps = 0x400;

	trapType = GetTrapType(trap);
	if (trapType == ToolTrap) {
		trap = BitAnd(trap, 0x07FF);
		if (trap >= numToolBoxTraps)
			trap = _Unimplemented;
	}
	return(NGetTrapAddress(trap, trapType) != NGetTrapAddress(_Unimplemented, ToolTrap));

}

static void GetSystemFolder(short * vRefNumP, long * dirIDP) {
	SysEnvRec info;
	long wdProcID;
	
	SysEnvirons(1, &info);
	if (GetWDInfo(info.sysVRefNum, vRefNumP, dirIDP, &wdProcID) != noErr) {
		*vRefNumP = 0;
		*dirIDP = 0;
	}
}

static void GetCPanelFolder(short * vRefNumP, long * dirIDP) {
	Boolean hasFolderMgr = false;
	long feature;
	
	if (TrapAvailable(_Gestalt)) if (Gestalt(gestaltFindFolderAttr, &feature) == noErr) hasFolderMgr = true;
	if (!hasFolderMgr) {
		GetSystemFolder(vRefNumP, dirIDP);
		return;
	}
	else {
		if (FindFolder(kOnSystemDisk, kControlPanelFolderType, kDontCreateFolder, vRefNumP, dirIDP) != noErr) {
			*vRefNumP = 0;
			*dirIDP = 0;
		}
	}
}
	
/* SearchFolderForDNRP is called to search a folder for files that might contain the 'dnrp' resource */
static short SearchFolderForDNRP(long targetType, long targetCreator, short vRefNum, long dirID) {
	HParamBlockRec fi;
	Str255 filename;
	short refnum;
	
	fi.fileParam.ioCompletion = nil;
	fi.fileParam.ioNamePtr = filename;
	fi.fileParam.ioVRefNum = vRefNum;
	fi.fileParam.ioDirID = dirID;
	fi.fileParam.ioFDirIndex = 1;
	
	while (PBHGetFInfo(&fi, false) == noErr) {
		/* scan system folder for driver resource files of specific type & creator */
		if (fi.fileParam.ioFlFndrInfo.fdType == targetType &&
			fi.fileParam.ioFlFndrInfo.fdCreator == targetCreator) {
			/* found the MacTCP driver file? */
			refnum = HOpenResFile(vRefNum, dirID, filename, fsRdPerm);
			if (GetIndResource('dnrp', 1) == NULL)
				CloseResFile(refnum);
			else
				return refnum;
		}
		/* check next file in system folder */
		fi.fileParam.ioFDirIndex++;
		fi.fileParam.ioDirID = dirID;	/* PBHGetFInfo() clobbers ioDirID */
	}
	return (-1);
}	

/* OpenOurRF is called to open the MacTCP driver resources */

static short OpenOurRF() {
	short refnum;
	short vRefNum;
	long dirID;
	
	/* first search Control Panels for MacTCP 1.1 */
	GetCPanelFolder(&vRefNum, &dirID);
	if (-1 != (refnum = SearchFolderForDNRP('cdev', 'ztcp', vRefNum, dirID)))
		return(refnum);
		
	/* next search System Folder for MacTCP 1.0.x */
	GetSystemFolder(&vRefNum, &dirID);
	if (-1 != (refnum = SearchFolderForDNRP('cdev', 'mtcp', vRefNum, dirID)))
		return(refnum);
		
	/* finally, search Control Panels for MacTCP 1.0.x */
	GetCPanelFolder(&vRefNum, &dirID);
	return (refnum = SearchFolderForDNRP('cdev', 'mtcp', vRefNum, dirID));
}	
