/*
 *  Copyright (c) 1990 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  modrdn.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1990 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#include "lber.h"
#include "ldap.h"
#include <stdio.h>
#include <string.h>

/*
 * ldap_modrdn - initiate an ldap (and X.500) modifyRDN operation. Parameters:
 *
 *	ld		LDAP descriptor
 *	dn		DN of the object to modify
 *	newrdn		RDN to give the object
 *
 * Example:
 *	msgid = ldap_modrdn( ld, dn, newrdn );
 */

ldap_modrdn( ld, dn, newrdn )
LDAP	*ld;
char	*dn;
char	*newrdn;
{
	BerElement	*ber;

	/*
	 * A modify rdn request looks like this:
	 *	ModifyRDNRequet ::= SEQUENCE {
	 *		entry	DistinguishedName,
	 *		newrdn	RelativeDistinguishedName
	 *	}
	 */

	Debug( LDAP_DEBUG_TRACE, "ldap_modrdn\n", 0, 0, 0 );

	/* create a message to send */
	if ( (ber = ber_alloc()) == NULLBER ) {
		ld->ld_errno = LDAP_LOCAL_ERROR;
		return( -1 );
	}

	if ( ber_printf( ber, "{it{{ss}}}", ++ld->ld_msgid, LDAP_REQ_MODRDN, dn,
	    newrdn ) == -1 ) {
		ld->ld_errno = LDAP_ENCODING_ERROR;
		ber_free( ber, 1 );
		return( -1 );
	}

	/* send the message */
	if ( ber_flush( &ld->ld_sb, ber, 1 ) != 0 ) {
		ld->ld_errno = LDAP_SERVER_DOWN;
		return( -1 );
	}

	ld->ld_errno = LDAP_SUCCESS;
	return( ld->ld_msgid );
}

ldap_modrdn_s( ld, dn, newrdn )
LDAP		*ld;
char		*dn;
char		*newrdn;
{
	int		msgid;
	LDAPMessage	*res;

	if ( (msgid = ldap_modrdn( ld, dn, newrdn )) == -1 )
		return( ld->ld_errno );

	if ( ldap_result( ld, msgid, 1, (struct timeval *) NULL, &res ) == -1 )
		return( ld->ld_errno );

	return( ldap_result2error( ld, res, 1 ) );
}

