/* general.f -- translated by f2c (version of 22 July 1992  22:54:52).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    integer ierr;
} gerror_;

#define gerror_1 gerror_

struct {
    doublereal pi, tol;
} gconst_;

#define gconst_1 gconst_

struct {
    integer iprt, msglvl;
} gprint_;

#define gprint_1 gprint_


/*     The following code was excerpted from: initcb.f */

/* Subroutine */ int initcb_(tolin)
doublereal *tolin;
{
    /* System generated locals */
    doublereal d__1, d__2;

    /* Builtin functions */
    double acos();

    /* Local variables */
    static doublereal epsp1, eps;


/*     Written and copyright by: */
/*        Barry Joe, Dept. of Computing Science, Univ. of Alberta */
/*        Edmonton, Alberta, Canada  T6G 2H1 */
/*        Phone: (403) 492-5757      Email: barry@cs.ualberta.ca */

/*     Purpose: Initialize global variables in common blocks */
/*        GERROR, GCONST, and GPRINT. The latter is used for */
/*        printing debugging information. */

/*     Input parameters: */
/* 	 TOLIN - relative tolerance used to determine TOL */

/*     Output parameters in common blocks: */
/*        IERR - error code, initialized to 0 */
/*        PI - ACOS(-1.0D0) */
/*        TOL - relative tolerance MAX(TOLIN,100.0D0*EPS) where */
/*              EPS is approximation to machine epsilon */
/*        IPRT - standard output unit 6 */
/*        MSGLVL - message level, initialized to 0 */



    gerror_1.ierr = 0;
    gconst_1.pi = acos(-1.);
    eps = 1.;
L10:
    eps /= 2.;
    epsp1 = eps + 1.;
    if (epsp1 > 1.) {
	goto L10;
    }
/* Computing MAX */
    d__1 = *tolin, d__2 = eps * 100.;
    gconst_1.tol = max(d__1,d__2);
    gprint_1.iprt = 6;
    gprint_1.msglvl = 0;
} /* initcb_ */


/*     The following code was excerpted from: rotiar.f */

/* Subroutine */ int rotiar_(n, arr, shift)
integer *n, *arr, *shift;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer a, b, i, j, k, l, m, r, t, sh;


/*     Written and copyright by: */
/*        Barry Joe, Dept. of Computing Science, Univ. of Alberta */
/*        Edmonton, Alberta, Canada  T6G 2H1 */
/*        Phone: (403) 492-5757      Email: barry@cs.ualberta.ca */

/*     Purpose: Rotate elements of integer array. */

/*     Input parameters: */
/* 	 N - number of elements of array */
/* 	 ARR(0:N-1) - integer array */
/*        SHIFT - amount of (left) shift or rotation; ARR(SHIFT) on input 
*/
/*              becomes ARR(0) on output */

/*     Updated parameters: */
/* 	 ARR(0:N-1) - rotated integer array */


    sh = *shift % *n;
    if (sh < 0) {
	sh += *n;
    }
    if (sh == 0) {
	return 0;
    }
    a = *n;
    b = sh;
L20:
    r = a % b;
    a = b;
    b = r;
    if (r > 0) {
	goto L20;
    }
    m = *n / a - 1;
    i__1 = a - 1;
    for (i = 0; i <= i__1; ++i) {
	t = arr[i];
	k = i;
	i__2 = m;
	for (j = 1; j <= i__2; ++j) {
	    l = k + sh;
	    if (l >= *n) {
		l -= *n;
	    }
	    arr[k] = arr[l];
	    k = l;
/* L30: */
	}
	arr[k] = t;
/* L40: */
    }
} /* rotiar_ */

