/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*****************************************************************************
 *
 * File:	mesh.h
 *
 * Description:	contains header information for the mesh generation routines
 * 
 *****************************************************************************/

# ifndef _MESH_H
# define _MESH_H

# define LOG	2
# define LINEAR 1

typedef struct _curve {
   unsigned	numvc;
   double	(*vcl) [2];
} *Curve;

typedef struct _trimesh {
   double	tolin;		/* relative tolerance			*/
   double	angspc;		/* angular spacing			*/
   double	angtol;		/* angular tolerance			*/
   double	kappa;		/* */
   double	dmin;		/* min distribution function variation 	*/
   int		min;		/* minimum number to generate		*/
   int		max;		/* maximum number to generate		*/
   unsigned	numcurves;	/* number of curves (first is boundary)	*/
   Curve	*curves; 	/* array of curve structures		*/
} *TriMesh;

typedef struct _line {
   double	xs,ys,zs;
   double	xe,ye,ze;
   unsigned	rule;
   unsigned	number;
} *Line;

typedef struct _grid {
   double	xs,ys,zs;
   double	xe,ye,ze;
   unsigned	xnumber;
   unsigned	ynumber;
   unsigned	znumber;
} *Grid;

typedef struct triplet {
   double	x,y,z;
} Triplet;

typedef struct gpair {
   double	x,y;
} GPair;

unsigned GenerateGrid ( );
unsigned GenerateTriMesh ( );

# endif
