/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

# ifndef _Tree_h
# define _Tree_h
# ifndef _Item_h
# include "Item.h"
# endif

typedef struct tree *Tree;

# if defined (__STDC__) || defined (__GNUC__)

extern Tree TreeCreate        (ItemComparator);
extern int  TreeDestroy       (Tree);
extern int  TreeIterate       (Tree);
extern int  TreeSize          (Tree);

extern int  TreePreorder      (Tree);
extern int  TreeInorder       (Tree);
extern int  TreePostorder     (Tree);

extern Item TreeInsert        (Tree, Item);
extern Item TreeDelete        (Tree, Item);
extern Item TreeSearch        (Tree, Item);

extern Item TreeMinimum       (Tree);
extern Item TreeMaximum       (Tree);
extern Item TreePredecessor   (Tree, Item);
extern Item TreeSuccessor     (Tree, Item);

extern int  TreeSetIterator   (Tree, ItemIterator);
extern int  TreeSetDestructor (Tree, ItemDestructor);
extern int  TreeSetDuplicator (Tree, ItemDuplicator);

# else

extern Tree TreeCreate        ( );
extern int  TreeDestroy       ( );
extern int  TreeIterate       ( );
extern int  TreeSize          ( );

extern int  TreePreorder      ( );
extern int  TreeInorder       ( );
extern int  TreePostorder     ( );

extern Item TreeInsert        ( );
extern Item TreeDelete        ( );
extern Item TreeSearch        ( );

extern Item TreeMinimum       ( );
extern Item TreeMaximum       ( );
extern Item TreePredecessor   ( );
extern Item TreeSuccessor     ( );

extern int  TreeSetIterator   ( );
extern int  TreeSetDestructor ( );
extern int  TreeSetDuplicator ( );

# endif

# endif /* _Tree_h */
