/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/AsciiText.h>
# include <X11/Xaw/Form.h>
# include <X11/Xaw/Label.h>
# include <X11/Xaw/Dialog.h>
# include <X11/Xaw/Viewport.h>
# include <X11/Shell.h>
# include "Drawing.h"
# include "dialog.h"
# include "forms.h"
# include "globals.h"
# include "procedures.h"

 
static unsigned OkayButton  = 1;
static unsigned SaveButton  = 2;
static unsigned PrintButton = 3;

static void DrawingButtonActions ();
static void OutputButtonActions ();

Widget CreateDrawingShell ()
{
   Arg	        arglist[10];
   Cardinal     count;
   Widget       formwidget,
		buttonwidget;

   drawingShell = XtCreatePopupShell
                ("drawingShell", transientShellWidgetClass, toplevel, NULL, 0);

   formwidget = XtCreateManagedWidget
                ("form", formWidgetClass, drawingShell, NULL, 0);

   count = 0;
   XtSetArg (arglist [count], XtNgrid, False); count ++;

   drawing = XtCreateManagedWidget
	        ("drawing", drawingWidgetClass, formwidget, arglist, count);

   count = 0;
   XtSetArg (arglist [count], XtNlabel, ""); count++;
   XtSetArg (arglist [count], XtNborderWidth, 0); count++;
   XtSetArg (arglist [count], XtNtop, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNbottom, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNleft, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNright, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNfromVert, drawing); count++;

   buttonwidget  = XtCreateManagedWidget 
                ("buttons", dialogWidgetClass, formwidget, arglist, count); 

   XawDialogAddButton (buttonwidget, "okay", DrawingButtonActions, &OkayButton);
   XawDialogAddButton (buttonwidget,"print",DrawingButtonActions,&PrintButton);
   XawDialogAddButton (buttonwidget,"save",DrawingButtonActions,&SaveButton);

   return drawingShell;
}

Widget CreateOutputShell ()
{
   Arg	        arglist[10];
   Cardinal     count;
   Widget       formwidget,
		buttonwidget;

   outputShell   = XtCreatePopupShell
                ("outputShell", transientShellWidgetClass, toplevel, NULL, 0);

   formwidget    = XtCreateManagedWidget
                ("form", formWidgetClass, outputShell, NULL, 0);

   count = 0;
   XtSetArg (arglist [count], XtNeditType, XawtextEdit); count++;
   XtSetArg (arglist [count], XtNtype, XawAsciiFile); count++;
   outputwin     = XtCreateManagedWidget
                ("outputwin", asciiTextWidgetClass, formwidget, arglist, count);

   XawTextDisplayCaret (outputwin, False);

   count = 0;
   XtSetArg (arglist [count], XtNlabel, ""); count++;
   XtSetArg (arglist [count], XtNborderWidth, 0); count++;
   XtSetArg (arglist [count], XtNtop, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNbottom, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNleft, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNright, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNfromVert, outputwin); count++;

   buttonwidget  = XtCreateManagedWidget 
                ("buttons", dialogWidgetClass, formwidget, arglist, count); 

   XawDialogAddButton (buttonwidget, "okay", OutputButtonActions,&OkayButton);
   XawDialogAddButton (buttonwidget, "save", OutputButtonActions,&SaveButton);
   XawDialogAddButton (buttonwidget, "print", OutputButtonActions,&PrintButton);

   	/*
	 * This is a kludge because the stupid widget won't initialize
	 * as read-only with no file specified, so we'll just send all
	 * keyboard input from this widget into the dialog widget.
	 */

   XtSetKeyboardFocus (formwidget, buttonwidget);

   return outputShell;
}

static void OutputButtonActions (w, client_data, call_data)
   Widget 	w;
   XtPointer	client_data,
		call_data;
{
   unsigned    selected = *(unsigned *) client_data;
 
   unsigned    dialog_status;
   String      ans;

   if (selected == OkayButton) 
      XtPopdown (outputShell); 

   else if (selected == SaveButton) {
      dialog_status = PopupDialog (file_dialog, "Save as:", "", &ans);
      if (dialog_status == Okay && ans != NULL) 
         XawAsciiSaveAsFile (XawTextGetSource (outputwin),  ans);
   }

   else if (selected == PrintButton) 
      PrintEditContents (outputwin);
}

static void DrawingButtonActions (w, client_data, call_data)
   Widget	w;
   XtPointer	client_data,
		call_data;
{
   unsigned selected = *(unsigned *) client_data;

   if (selected == OkayButton)
      XtPopdown (drawingShell);
   else if (selected == PrintButton)
      PrintWidgetXWD (drawing);
   else if (selected == SaveButton)
      SaveWidgetXWD (drawing); 
}
