/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/****************************************************************************
* 
* File:		print.c
* 
* Description:	contains functions to print an AsciiText widget or to
*		print an XWD of any widget (i.e. the drawing widget)
*		or save that XWD to a file.
*
****************************************************************************/

# include <stdio.h>
# include <string.h>
# include <unistd.h>
# include <malloc.h>
# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/AsciiText.h>
# include "forms.h"
# include "dialog.h"
# include "globals.h"
# include "procedures.h"

int DumpWidget ( );

void PrintEditContents (w)
   Widget	w;
{
   FILE		*printer,
		*input;
   char		*tempfile;
   char		buffer [80];
   Boolean	status;
 
   tempfile = tempnam (NULL,"xfelt");

   status = XawAsciiSaveAsFile (XawTextGetSource (w), tempfile);
   input = fopen (tempfile, "r");
  
   if (input == NULL || status == False) {
      PopupDialog (error_dialog,"error creating print files",NULL,NULL);
      fclose (input);
      unlink (tempfile);
      return;
   }

   if ((printer = popen (lp_command, "w")) == NULL) {
      PopupDialog (error_dialog,"could not access print command",NULL,NULL);
      return;
   }

   while (fgets (buffer, 80, input) != NULL)
      fprintf (printer,"%s",buffer);

   fflush (printer);

   fclose (input);
   pclose (printer);
   unlink (tempfile);

   free (input);
   free (printer);
   free (tempfile);
}

void PrintWidgetXWD (widget)
   Widget	widget;
{
   FILE		*lp,
		*xpr,
		*dump;
   char		*tempfile;
   char		buffer;
   char		command [1024];
 
   tempfile = tempnam (NULL,"xfelt");

   dump = fopen (tempfile, "w");
  
   if (dump == NULL) {
      PopupDialog (error_dialog,"error creating print files",NULL,NULL);
      fclose (dump);
      unlink (tempfile);
      return;
   }

   if(DumpWidget (widget, dump)) {
      fclose (dump);
      unlink (tempfile);
      return;
   }

   fclose (dump);
  
   strcpy (command, xpr_command);
   strcat (command, " ");
   strcat (command, tempfile);

   if ((xpr = popen (command, "r")) == NULL) {
      PopupDialog (error_dialog,"could not access xpr command",NULL,NULL);
      return;
   }
   if ((lp = popen (lp_graphics, "w")) == NULL) {
      PopupDialog (error_dialog,"could not access print command",NULL,NULL);
      return;
   }

   while (fread (&buffer, 1, 1, xpr))
      fwrite (&buffer,1,1,lp);

   fflush (lp);

   pclose (lp);
   pclose (xpr);
   unlink (tempfile);
   free (lp);
   free (xpr);
   free (tempfile);
}

void SaveWidgetXWD (widget)
   Widget	widget;
{
   String	xwd_file;
   FILE		*output;
   unsigned	selected;

   selected = PopupDialog (file_dialog,"Save XWD as:","",&xwd_file);
   if (selected != Okay) 
      return;

   output = fopen (xwd_file, "w");
   if (output == NULL) {
      PopupDialog (error_dialog,"could not open file for writing",NULL,NULL);
      return;
   }
 
   if (DumpWidget (widget, output)) {
      fclose (output);
      unlink (xwd_file);
      return;
   }

   fclose (output); 

   return;
}
