/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
*
* File:		panel.c
*
* Description:	
*
* History:	by Jason I. Gobat and Darren C. Atkinson
*
*************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <unistd.h>
# include <string.h>
# include <malloc.h>
# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Shell.h>
# include <X11/Xaw/AsciiText.h>
# include "dialog.h"
# include "forms.h"
# include "globals.h"
# include "procedures.h"

Boolean QuerySave ();
void XawAsciiSourceSaved ();

void OpenFile ()
{
   String	ans;
   unsigned	selected;
   Arg		arglist [2];
   
   if (XawAsciiSourceChanged (XawTextGetSource (editwin)))
      if (!QuerySave ()) return;
         
   selected = PopupDialog (file_dialog, "File to load:", "", &ans);

   if (selected == Okay) {
      if (access (ans, F_OK) == 0) {
         if (access (ans, R_OK | W_OK) != 0)
            PopupDialog (error_dialog, 
                "file is not accessible, check file permissions", NULL, NULL);
         else {
            filename = ans;
            UpdateLabel ();
            XtSetArg (arglist [0], XtNstring, ans);
            XtSetValues (editwin, arglist, 1);
            XawAsciiSourceSaved (XawTextGetSource (editwin));
         }
      }
      else
         PopupDialog (error_dialog, "file does not exist", NULL, NULL);
   } 
}

void WriteNamedFile ()
{
   String	ans;
   unsigned	selected;

   selected = PopupDialog (file_dialog, "Save as:", "", &ans);
   if (selected == Okay) {
      filename = ans;
      UpdateLabel ();
      WriteFeltFile ();
   }
}

void WriteFeltFile ()
{
   Boolean status;

   if (filename != NULL) {
      status =  XawAsciiSaveAsFile (XawTextGetSource (editwin),filename);
      if (status == False) {
         PopupDialog (error_dialog, "could not save file", NULL, NULL);
         return;
      }
      XawAsciiSourceSaved (XawTextGetSource (editwin));
   }
   else
      WriteNamedFile ();
}

void StartNew ()
{
   Arg	arglist [1];

   if (XawAsciiSourceChanged (XawTextGetSource(editwin)))
      if (!QuerySave ()) return; 

   filename = NULL;
   UpdateLabel ();

   XtSetArg (arglist [0], XtNstring, filename);
   XtSetValues (editwin, arglist, 1);
   XawAsciiSourceSaved (XawTextGetSource (editwin));
}

Boolean QuerySave ()
{
    unsigned	selected;

    selected = PopupDialog (qsave_dialog, "Changes not saved, save now?", 
                  NULL, NULL);

    if (selected == Yes) {
       WriteFeltFile ();
       return True;
    }
    else if (selected == Cancel) return False;
  
    return True;
}
    
void Quit ()
{
   if (XawAsciiSourceChanged (XawTextGetSource (editwin)))
      if (!QuerySave ()) return;

   XtUnmapWidget (toplevel);
   XtDestroyApplicationContext (app_context);
   exit (0);
} 

void ExecuteFelt ()
{
   char         *felt,
		command [1024],
		cmd_line [1024];
   char         *temp_in,
	        *temp_out,
		*temp_graph,
	        *temp_error;
   Arg	        arglist[1];
   Boolean      status;
   int		sys_stat;

   felt = felt_command;

   if ((access (felt, X_OK)) != 0) {
      PopupDialog (error_dialog, "invalid path for Felt executable",NULL,NULL);
      return;
   }

   temp_in    = tempnam (NULL,"xfelt");
   temp_out   = tempnam (NULL,"xfelt");
   temp_error = tempnam (NULL,"xfelt");

   if (draw2d || draw3d)
      temp_graph = tempnam (NULL, "xfelt");

   status = XawAsciiSaveAsFile (XawTextGetSource (editwin), temp_in);

   if (status == False) {
      PopupDialog (error_dialog, "error creating temporary files", NULL, NULL);
      unlink (temp_in);
      return;
   }

   strcpy (command, felt);
   if (nocpp)
      strcat (command," -nocpp");
   if (material)
      strcat (command," -summary");
   if (draw2d || draw3d) {
      strcat (command, " -graphics ");
      strcat (command, temp_graph);
   }
   sprintf (cmd_line,"%s %s > %s 2> %s",command,temp_in,temp_out,temp_error);

   sys_stat = system (cmd_line);
   if (sys_stat > 0) {
      XtSetArg (arglist [0], XtNstring, temp_error);
      XtSetValues (outputwin, arglist, 1);
      PopupDialog(error_dialog,"Felt errors found in input file",NULL,NULL);
      XtPopup (outputShell, XtGrabNone);
   }
   else if (sys_stat < 0) 
      PopupDialog (error_dialog, "Could not execute Felt", NULL, NULL);
   else {
      XtSetArg (arglist [0], XtNstring, temp_out);
      XtSetValues (outputwin, arglist, 1);
      XtPopup (outputShell, XtGrabNone);
      
      if (draw2d) 
         DrawStructure2D (temp_graph);
      else if (draw3d)
         DrawStructure3D (temp_graph);
   }

   unlink (temp_in);
   unlink (temp_out); 
   unlink (temp_error);

   if (draw2d || draw3d) {
      unlink (temp_graph);
      free (temp_graph);
   }

   free (temp_in);
   free (temp_out);
   free (temp_error);
}

void UpdateLabel ()
{
   Arg 	arglist [1];

   if (filename != NULL)
      XtSetArg (arglist [0], XtNtitle, filename);
   else
      XtSetArg (arglist [0], XtNtitle, "UnNamed");

   XtSetValues (toplevel, arglist, 1);
}

void ConfigureXFelt ()
{
   String		result[4];
   extern EntryRecord	setup_entries;
   unsigned		status;
   unsigned		i;
   static String	suggestion[4];
   static unsigned	flag = 1; 
   
   if (flag) {
      for (i = 0 ; i < 4 ; i++)
         suggestion[i] = (String) malloc (sizeof(char)*256);
      flag = 0;
   }

   sprintf (suggestion [0],"%s",felt_command); 
   sprintf (suggestion [1],"%s",lp_command); 
   sprintf (suggestion [2],"%s",lp_graphics); 
   sprintf (suggestion [3],"%s",xpr_command); 

   FillTextBuffers (setup_form, setup_entries, suggestion);
   status = GetEntryFormValues (setup_form, setup_entries, result);
   if (status) {
      felt_command = result[0];
      lp_command   = result[1];
      lp_graphics  = result[2];
      xpr_command  = result[3];
   }
} 

void FlipDrawToggle (w, event, params, num_params)
   Widget	w;
   XEvent	*event;
   String	*params;
   Cardinal	*num_params;
{       
   if (atoi (params[0])  == 2)
      draw2d = FlipToggleState (option_form, 2);
   else if (atoi (params[0]) == 3)
      draw3d = FlipToggleState (option_form, 3);
}

void SetFeltOptions ()
{
   Boolean	          result[4];
   extern ToggleRecord    option_entries;
   unsigned		  status;

   status = GetToggleFormValues (option_form, option_entries, result, NULL);

   if (status) {
      nocpp = result [0];
      material = result [1];
      draw2d = result [2];
      draw3d = result [3];
   }
} 
