/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		globals.c
*
* Description:	Contains declarations for the uninitialized global
*		variables
*
**************************************************************************/

# include <X11/Intrinsic.h>
# include <X11/Xaw/AsciiText.h>
# include "dialog.h"
# include "forms.h"

/* Global widgets */

XtAppContext app_context;

Widget control;
Widget editwin;
Widget outputShell;
Widget outputwin;
Widget form;
Widget toplevel;
Widget drawingShell;
Widget drawing;

Pixmap question;
Pixmap computer;
Pixmap truss;


/* Global dialogs */

Dialog *proceed_dialog;
Dialog *error_dialog;
Dialog *info_dialog;
Dialog *file_dialog;
Dialog *qsave_dialog;

ToggleForm      *option_form;
TextEntryForm   *setup_form;

Boolean	    nocpp = False;
Boolean     material = False;
Boolean     draw2d = False;
Boolean     draw3d = False;

char	        *clipboard = NULL;
XawTextPosition clipboard_length = 0;

String filename = NULL;

String felt_command;
String lp_command;
String xpr_command;
String lp_graphics;
