/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/**************************************************************************
* 
* File:		util.c
*
* Description:	contains various utility functions.
*
**************************************************************************/

# include <stdio.h>
# include <string.h>
# include <stdlib.h>
# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/Simple.h>
# include "fe.h"
# include "dialog.h"
# include "forms.h"
# include "util.h"
# include "Drawing.h"
# include "Tree.h"
# include "globals.h"
# include "procedures.h"

char *GetTextCoordinates (rx,ry,rz)
   float	*rx,
		*ry;
   float        *rz;
{
   String	result;
   Arg		arglist [2];
   Cardinal	count;
   float	x,y,z;
   int		status;
   int		desired;
   static char	buffer [256];

   count = 0; 
   XtSetArg (arglist [count], XtNstring, &result); count++;
   XtGetValues (entry, arglist, count);

   if (ry == NULL && rz == NULL) {
      desired = 1;
      status = sscanf (result, "%f %s",&x,buffer);
   }
   else if (rz == NULL) {
      desired = 2;
      status = sscanf (result, "%f%*[, ]%f %s",&x,&y,buffer);
   }
   else {
      desired = 3;
      status = sscanf (result, "%f%*[, ]%f%*[, ]%f %s",&x,&y,&z,buffer);
   }

   count = 0; 
   XtSetArg (arglist [count], XtNstring, ""); count++;
   XtSetValues (entry, arglist, count);
   
   if (status == desired) {
      *rx = x;
      if (ry != NULL)
         *ry = y;
      if (rz != NULL)
         *rz = z;

      return NULL;
   } 
   else {
      XBell (XtDisplay (toplevel), 20); 
      return buffer;
   }
}

char *GetTextNumber (number)
   unsigned	*number;
{
   String	result;
   static char  buffer [256];
   Arg		arglist [2];
   Cardinal	count;
   char		*ptr;
   unsigned	success;
   long 	num;

   count = 0; 
   XtSetArg (arglist [count], XtNstring, &result); count++;
   XtGetValues (entry, arglist, count);

   success = 1;

   num = strtol (result, &ptr, 10);
   if (*ptr == 0) 
      *number = num;
   else {
      success = 0;
      (void) strcpy (buffer, result);
   }

   count = 0; 
   XtSetArg (arglist [count], XtNstring, ""); count++;
   XtSetValues (entry, arglist, count);
   
   if (success) 
      return NULL;
   else {
      XBell (XtDisplay (toplevel), 20); 
      return buffer;
   }
}

String GetTextString ()
{
   String	result;
   String	copy;
   Arg		arglist [1];

   XtSetArg (arglist [0], XtNstring, &result); 
   XtGetValues (entry, arglist, 1);

   if (strcmp (result, "") == 0)
      copy = NULL;
   else
      copy = XtNewString (result);

   XtSetArg (arglist [0], XtNstring, ""); 
   XtSetValues (entry, arglist, 1);

   return copy;
}


static void    (*function) ( );


void DoDeleteGroup (box, x1, y1, x2, y2)
    Figure box;
    float  x1, y1, x2, y2;
{
    Point    points [4];
    Figure  *figures;
    unsigned nfigures;


    points [0].x = x1;
    points [0].y = y1;
    points [1].x = x1;
    points [1].y = y2;
    points [2].x = x2;
    points [2].y = y2;
    points [3].x = x2;
    points [3].y = y1;

    figures = DW_SearchArea (drawing, points, 4, &nfigures);
    function (figures, nfigures);
    DW_RemoveFigure (drawing, box);
    SetNormalMode ( );
}


void DeleteGroupCB (w, client_data, call_data)
    Widget    w;
    XtPointer client_data;
    XtPointer call_data;
{
    static Point     corner;
    static Figure    box;
    DrawingReport   *report;
    FigureAttributes attributes;


    report = (DrawingReport *) call_data;

    switch (report -> event -> type) {
    case ButtonPress:
	if (report -> event -> xbutton.button > 2) {
	    SetNormalMode ( );
	    return;
	}

	corner = report -> unsnapped;
	ChangeStatusLine ("- Select second corner -", False);
	DW_SetInteractive (w, True);
	box = DW_DrawRectangle (w, True, corner.x, corner.y, 0.0, 0.0);
	break;

    case MotionNotify:
	attributes.width = report -> snapped.x - corner.x;
	attributes.height = report -> unsnapped.y - corner.y;
	DW_SetAttributes (w, box, DW_FigureSize, &attributes);
	break;

    case ButtonRelease:
	DW_SetInteractive (w, False);
	DoDeleteGroup (box, corner.x, corner.y, report -> unsnapped.x,
			report -> unsnapped.y);
	break;
    }
}


void DeleteGroupAP ( )
{
    static unsigned corner_number = 0;
    static float    xl, xr, yb, yt;
    Figure          box;
    char           *status;


    if (corner_number == 0) {
	status = GetTextCoordinates (&xl, &yb, NULL);
	if (status == NULL) {
	    corner_number ++;
	    ChangeStatusLine ("Select second corner:", True);
	}
    } else if (corner_number == 1) {
	status = GetTextCoordinates (&xr, &yt, NULL);
	if (status == NULL) {
	    corner_number = 0;
	    box = DW_DrawRectangle (drawing, True, xl, yb, xr - xl, yt - yb);
	    DoDeleteGroup (box, xl, yb, xr, yt);
	}
    }
}


void DeleteGroup (call_data, op)
    XtPointer  call_data;
    void     (*op) ( );
{
    Arg arglist [1];


    function = op;

    XtSetArg (arglist [0], XtNcursorName, "left_ptr");
    XtSetValues (drawing, arglist, 1);

    ChangeStatusLine ("Select first corner:", True);

    XtRemoveAllCallbacks (drawing, XtNbuttonCallback);
    XtAddCallback (drawing, XtNbuttonCallback, DeleteGroupCB, NULL);

    XtOverrideTranslations (entry,
	XtParseTranslationTable ("<Key>Return: DeleteGroupAP()"));

    if (DW_SetForeground (drawing, tool_color) == False)
	(void) DW_SetForeground (drawing, "black");

    if (call_data != NULL)
	DeleteGroupCB (drawing, NULL, call_data);
}
