/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
* 
* File:		procedures.h
*
* Description:	Contains function prototypes for the various specific
*		callback and action routines
*
*************************************************************************/

# ifndef _PROCEDURES_H
# define _PROCEDURES_H

	/*
 	 * a bunch of routines that I'm too busy to classify
	 */

void SelectCallback ();
	 
void EditAddNode ();
void SetActiveElementType ();
void GetForceDefinition ();
void GetMaterialDefinition ();
void GetConstraintDefinition ();
void SetActiveForce ();
void SetActiveMaterial ();

void ToggleSnapStatus ();
void ToggleGridStatus ();
void GetCanvasParameters ();
void SaveWidgetXWD ();
void GetConfiguration ();

void ZoomAll ();
void ZoomStart ();
void ZoomAP ();
void ZoomSelect ();
void ZoomEnd ();

void OpenFile ();
int WriteVFeltFile ();
int  ReadFeltFile ();
void WriteVelvetFile ();
void ReadVelvetFile ();
String FormVelvetFilename ();
void WriteMaterialFile ();
void OpenMaterialFile ();
void WriteNamedFile ();
void StartNew ();
void RestoreOriginal ();
Boolean QuerySave ();

void QuitVelvet ();

void ParseEntryLine ();
void ActionToPanelConverter ();
void AssignQuitAbort ();
void QuitEdit ();
void AbortEdit ();
void SetEditMode ();
void SetNormalMode ();
void ChangeStatusLine ();
void UpdateTitle ();
void SetShellTitle ();
void DoNothing ();

	/*
	 * for the construction tools
	 */

void ToolsDeleteFigure ();
void DeleteToolCB ();
void ToolsDrawLine ();
void DoLineCB ();
void DoLineAP ();
void ToolsDrawCircle ();
void DoCircleCB ();
void DoCircleAP ();
void ToolsDrawArc ();
void DoArcCB ();
void ToolsDrawRectangle ();
void DoRectangleCB ();
void DoRectangleAP ();
void ToolsDrawText ();
void DoTextAP ();
void DoTextCB ();
void ToolsDrawPolygon ();
void DoPolygonMotionCB ();
void DoPolygonButtonCB ();
void DeleteGroupAP ();
int  figure_cmp ();

	/*
	 * for editing the node list
	 */

void AddNodeCB ();
void AddNodeAP ();
void DoAddNode ();
void DeleteNodeCB ();
void DeleteNodeAP ();
void EditNodeNumber ();
void EditNodeAP ();
void EditNodeCB ();
void MoveNodeNumber ();
void MoveNodeAP ();
void MoveNodeCB ();
void WalkNodeAP ();
void WalkNodeCB ();
void QuitMoveNode ();
void EditDeleteNode ();
void GetNodeInformation ();
void DoMoveNode ();
void EditNodeInfo ();
int DrawNode ();

	/*
	 * for editing the element list
	 */

void GetElementInformation ();
void EditElementInfo ();
void AddElementCB ();
void AddElementAP ();
void DoAddElement ();
void EditAddElement ();
void EditDeleteElement ();
void DeleteEltCB ();
void DeleteEltAP ();
void EditElementNumber ();
void EditElementCB ();
void EditElementAP ();
int DrawElement ();
void AbortAddElement ();

void EditMaterialInfo ();
void DeleteMaterial ();

void EditForceInfo ();
void ApplyForceCB ();
void ApplyForceAP ();
void EditApplyForce ();
void DeleteForce ();

void GetDistributedDefinition ();
void SetActiveDistributed ();
void EditDistributedInfo ();
void DeleteDistributed ();
void EditApplyLoad ();
void ApplyLoadCB ();
void ApplyLoadAP ();

void DeleteConstraint ();
void EditApplyConstraint ();
void SetActiveConstraint ();
void EditConstraintInfo ();
void ApplyConstraintCB ();
void ApplyConstraintAP ();

void SetupGridGeneration ();
void SetupTriangleGeneration ();
void GenerateElements ();
void GridAP ();
void GridCB ();
void DoGrid ();
void ToggleNumberStatus ();

void FinishCurve ();
void AbortTriMesh ();
void AddCurvePointAP ();
void AddCurvePointCB ();
void DoAddCurvePoint ();
void BackupOnePoint ();

	/*
	 * defining and solving the problem
	 */

void DefineProblem ();
void CompactOperation ();


	/*
	 * miscellaneous functions
	 */

void SetShellTitle ();
void UpdateOutputWindow ();
void CreateInformationShell ();
Widget CreateOutputShell ();
void DeleteGroup ();
void PanelCallback ();
void SetNodeNumbering ();
void SetElementNumbering ();
void GatherDistributedNames ();
void GatherConstraintNames ();
void GatherMaterialNames ();
void GatherForceNames ();
void BufferErrors ();
int  DumpWidget ();

# endif
