/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		globals.h
*
* Description:	This file contains various global information for
*		the velvet routines.
*
*************************************************************************/

# ifndef _GLOBALS_H
# define _GLOBALS_H

# define Float2Arg(x)     (*((XtArgVal *) &(x)))

/* Global widgets */

extern XtAppContext app_context;

extern Widget bottom;
extern Widget control;
extern Widget coord;
extern Widget drawing;
extern Widget entry;
extern Widget form;
extern Widget status;
extern Widget toplevel;
extern Widget viewport;
extern Widget quitbutton;
extern Widget abortbutton;

extern Widget outputwin;
extern Widget outputShell;
extern Widget nodeShell;
extern Widget nodewin;
extern Widget elementShell;
extern Widget elementwin;

extern Pixmap checkmark;
extern Pixmap question;
extern Pixmap menu16;
extern Pixmap truss;

/* Global dialogs */

extern Dialog *proceed_dialog;
extern Dialog *error_dialog;
extern Dialog *info_dialog;
extern Dialog *file_dialog;
extern Dialog *qsave_dialog;

/* Global value forms */

extern TextEntryForm *force_form;
extern TextEntryForm *material_form;
extern TextEntryForm *canvas_form;
extern TextEntryForm *config_form;
extern TextEntryForm *load_form;
extern TextEntryForm *node_form;
extern TextEntryForm *element_form;
extern TextEntryForm *trimesh_form;

extern ToggleForm *constraint_form;
extern ListForm *material_list;
extern ListForm *element_list;
extern ListForm *force_list;
extern ListForm *constraint_list;
extern ListForm *load_list;

/* The current configuration */

extern String	elt_color;
extern String 	node_color;
extern String 	label_font;
extern String	tool_color;
extern String	text_font;

/* some global values */

extern Boolean   changeflag;
extern Boolean	 snap_status;
extern Boolean	 grid_status;
extern Boolean	 edit_mode;
extern Boolean   number_status;
extern Boolean   sensitive_menus;

/* the actual finite element stuff */

extern Node	 *node;
extern unsigned  numnodes;
extern Element   *element;
extern unsigned  numelts;

extern String title;
extern char filename [ ];

extern Node displayed_node;
extern Element displayed_element;

extern String *material_names;
extern Material active_material;
extern int active_material_number;

extern String *constraint_names;
extern Constraint active_constraint;
extern int active_constraint_number;

extern String *force_names;
extern Force active_force;
extern int active_force_number;

extern String *distributed_names;
extern Distributed active_distributed;
extern int active_distributed_number;

extern Definition active_definition;
extern int active_definition_number;

/* extern the definitions that we initialize in velvet.c */

extern float	 snap_size;
extern float     grid_size;
extern float	 xmin;
extern float	 xmax;
extern float	 ymin;
extern float	 ymax;

extern Tree      figure_tree;


/* some basically private stuff for the main applic, but ... */

/* Unique ids for each menu item on the control panel */

typedef enum {
    AddNode, DeleteNode, EditNode, MoveNodeId,
    AddElt, DeleteElt, SetType, Generate, EditElement,
    DefMaterial, SetMaterial, EditMaterial, DelMaterial,
    OpenMaterial, SaveMaterial,
    DefForce, SetForce, EditForce, DelForce, ApplyForce,
    DefConstraint, SetConstraint, EditConstraint, DelConstraint, ApplyConstraint,
    DefLoad, SetLoad, EditLoad, DelLoad, ApplyLoad,
    Solve, Define, Parameters, ZoomOut, ZoomIn, SaveXWD,
    SnapOnOff, NumbersOnOff, GridOnOff, Configure,
    LineTool, Circle, Arc, Rectangle, Polygon, DeleteTool, Text,
    NewId, Open, Save, SaveAs, Restore, Exit,
    Info, Quit, Abort
} PanelId;


typedef struct {
    char	*name;
    WidgetClass *class;
    Cardinal	 numentries;
    struct {
	char	*name;
	PanelId  id;
	Widget	 widget;
    } menuentry [8];
    Widget 	 button;
    Widget	 menu;
} Panel;


typedef struct {
   char     *name;
   PanelId  id;
} TextCommand;

# endif
