/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

# include <stdio.h>
# include "fe.h"
# include "error.h"
# include "allocate.h"
# include "mesh.h"

int main (argc, argv)
   int		argc;
   char		*argv [ ];
{
   Element	*element;
   Node		*node;
   unsigned	numnodes;
   unsigned	numelts;
   Line		*line;
   Grid		*grid;
   TriMesh	*trimesh;
   unsigned	i,j;
   unsigned	numlines,
		numgrids,
		numtrimeshes;

   GetGenerator (stdin, &line, &grid, &trimesh, 
                        &numlines, &numgrids, &numtrimeshes);

   for (i = 0 ; i < numgrids ; i++) {
      GenerateGrid (grid[i], &element, &node, &numelts, &numnodes, 0, 0);

      printf ("nodes\n");
      for (j = 1 ; j <= numnodes ; j++)
         printf ("%d   x=%f   y=%f   z=%f\n",node[j] -> number,
                                             node[j] -> x,
					     node[j] -> y,
					     node[j] -> z);

      printf ("\ntruss elements\n");
      for (j = 1 ; j <= numelts ; j++)
         printf ("%d nodes=[%d,%d]\n",element[j] -> number,
                                      element[j] -> node[1] -> number,
                                      element[j] -> node[2] -> number);
   }

   printf ("\nend\n");
   return 0;
}
