/* winfuncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"

#include <X11/cursorfont.h>

/* globals */

Cursor clock_cursor = 0;
Cursor top_left_cursor = 0;
Cursor pirate_cursor = 0;


Cursor create_left_cursor();
Cursor create_clock_cursor();
Cursor create_pirate_cursor();

Widget help_shell = NULL;
void help_dismiss();
void help_help();
void display_text();
void help();


void create_cursors(display)
     Display *display;
{
  clock_cursor = create_clock_cursor(display);
  top_left_cursor = create_left_cursor(display);
  pirate_cursor = create_pirate_cursor(display);
}



Cursor
create_left_cursor(display)
     Display *display;
{
  return XCreateFontCursor(display, XC_top_left_arrow);
}

Cursor
create_pirate_cursor(display)
     Display *display;
{
  return XCreateFontCursor(display, XC_pirate);
}


Cursor
create_clock_cursor(display)
     Display *display;
{
  return XCreateFontCursor(display, XC_watch);
}

void
display_fontcursor(display, w, cursor)
     Display *display;
     Window w;
     Cursor cursor;
{
  if (cursor) {
    XDefineCursor (display, w, cursor);
  }
}

void
reset_cursor(display, w)
     Display *display;
     Window w;
{
  XUndefineCursor (display, w);
  XFlush(display);
}


void set_watch_cursors()
{

  session.busy = TRUE;
  XDefineCursor(display, XtWindow(top), clock_cursor);
  XDefineCursor(display, XtWindow(status), clock_cursor);

  if(session.view && session.view->is_realized) {
    XDefineCursor(display, 
		  XtWindow(session.view->shell), clock_cursor);
    if(session.view->list_is_realized)
      XDefineCursor(display, 
		    XtWindow(session.view->list_shell), clock_cursor);
  }    

  if(session.edfilter && session.edfilter->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.edfilter->shell), clock_cursor);

  if(session.address_book && session.address_book->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.address_book->shell), clock_cursor);

  if(session.compose && session.compose->is_realized) {
    XDefineCursor(display, 
		  XtWindow(session.compose->shell), clock_cursor);
    if(session.compose->edit->is_realized)
      XDefineCursor(display,
		    XtWindow(session.compose->edit->shell), clock_cursor);
  }

  if(session.read && session.read->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.read->shell), clock_cursor);

  if(session.prefst && session.prefst->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.prefst->shell), clock_cursor);


  XFlush(display);
}


void set_pirate_cursors()
{
  session.busy = TRUE;
  XDefineCursor(display, XtWindow(top), pirate_cursor);
  XDefineCursor(display, XtWindow(status), pirate_cursor);

  if(session.view && session.view->is_realized) {
    XDefineCursor(display, 
		  XtWindow(session.view->shell), pirate_cursor);
    if(session.view->list_is_realized)
      XDefineCursor(display, 
		    XtWindow(session.view->list_shell), pirate_cursor);
  }    

  if(session.edfilter && session.edfilter->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.edfilter->shell), pirate_cursor);

  if(session.address_book && session.address_book->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.address_book->shell), pirate_cursor);
  if(session.compose && session.compose->is_realized) {
    XDefineCursor(display, 
		  XtWindow(session.compose->shell), pirate_cursor);
    if(session.compose->edit->is_realized)
      XDefineCursor(display,
		    XtWindow(session.compose->edit->shell), clock_cursor);
  }

  if(session.read && session.read->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.read->shell), pirate_cursor);


  if(session.prefst && session.prefst->is_realized)
    XDefineCursor(display, 
		  XtWindow(session.prefst->shell), pirate_cursor);

  XFlush(display);

}


void reset_cursors()
{
  XUndefineCursor(display, XtWindow(top));
  XUndefineCursor(display, XtWindow(status));

  if(session.view && session.view->is_realized) {
    XUndefineCursor(display, XtWindow(session.view->shell));
    if(session.view->list_is_realized)
      XUndefineCursor(display, XtWindow(session.view->list_shell));
  }    

  if(session.edfilter && session.edfilter->is_realized)
    XUndefineCursor(display,XtWindow(session.edfilter->shell));

  if(session.address_book && session.address_book->is_realized)
    XUndefineCursor(display,XtWindow(session.address_book->shell));

  if(session.compose && session.compose->is_realized) {
    XUndefineCursor(display,XtWindow(session.compose->shell));
    if(session.compose->edit->is_realized)
      XUndefineCursor(display,
		      XtWindow(session.compose->edit->shell));
  }

  if(session.read && session.read->is_realized)
    XUndefineCursor(display,XtWindow(session.read->shell));

  if(session.prefst && session.prefst->is_realized)
    XUndefineCursor(display,XtWindow(session.prefst->shell));

  XFlush(display);
  session.busy = FALSE;
}

void get_pointer_position(w,x,y)
     Widget w;
     Position *x;
     Position *y;
{
    Arg args[ARGLISTSIZE];
    int n = 0;

    Window junk1, junk2;
    int root_x, root_y, junkX, junkY;
    unsigned int junkM;
	
    if (XQueryPointer(XtDisplay(w), XtWindow(w), 
		      &junk1,  &junk2, 
		      &root_x, &root_y, 
		      &junkX,  &junkY, 
		      &junkM) == FALSE) 
      return;

    *x = (short) root_x;
    *y = (short) root_y;
    return;

}


/* To determine if an item in a list widget was selected or deselected */

#ifdef __STDC__
Boolean is_selected(XmListCallbackStruct *ptr, unsigned long num)
#else
Boolean is_selected(ptr,num)
     XmListCallbackStruct *ptr;
     unsigned long num;
#endif
{
  register int i;
  for(i = 0; i < ptr->selected_item_count; i ++) {
    if(ptr->selected_item_positions[i] == num)
      return(TRUE);
  }
  return(FALSE);

}


Widget create_label(form,below,string)
     Widget form;
     Widget below;
     char *string;
{
  Arg args[ARGLISTSIZE];
  int n = 0;
  Widget label;

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_WIDGET ); n ++;
  XtSetArg(args[n], XmNtopWidget,       below           ); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM   ); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM   ); n ++;
  XtSetArg(args[n], XmNborderWidth,     0               ); n ++;

  label = XmCreateLabel(form, string, args, n);            n = 0;
  XtManageChild(label);

  return(label);

}





Widget create_text_field(form,below,label_string,string,width,fn,data)
     Widget form;
     Widget below;
     char *label_string;
     char *string;
     int width;
     XtPointer fn;
     XtPointer data;
{
  Arg args[ARGLISTSIZE];
  int n = 0;
  XtTranslations translations;
  Widget this_widget;
  Widget label;
  char *ptr = NULL;
  char buffer[FILEBUFFLEN];
  

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_WIDGET ); n ++;
  XtSetArg(args[n], XmNtopWidget,       below           ); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM   ); n ++;
  XtSetArg(args[n], XmNborderWidth,     0               ); n ++;

  label = XmCreateLabel(form, label_string, args, n);      n = 0;
  XtManageChild(label);

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_WIDGET ); n ++;
  XtSetArg(args[n], XmNtopWidget,       below           ); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM   ); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_WIDGET ); n ++;
  XtSetArg(args[n], XmNleftWidget,      label           ); n ++;
  XtSetArg(args[n], XmNcolumns,         width           ); n ++;

  /* 
   * Just to make a more sensible widget name. Not sure if it's
   * worth the trouble.
   */

  strcpy(buffer,label_string);
  for(ptr = buffer; *ptr; ptr ++)
    if((isspace(*ptr)) || (*ptr == COLONCHAR))
      *ptr = NUL_TERM;
  strcat(buffer,"_text");

  this_widget = XmCreateTextField(form, buffer, args, n);  n = 0;
  XtManageChild(this_widget);

  if(string)
    AppendText(this_widget,string);

  translations = XtParseTranslationTable(GLOBAL_text_field_translations);
  XtOverrideTranslations(this_widget,translations);

  if(fn) {
    translations = 
      XtParseTranslationTable(GLOBAL_terminal_text_field_translations);
    XtOverrideTranslations(this_widget,translations);  
    XtAddCallback(this_widget, XmNactivateCallback, (XtCallbackProc) fn, data);
  }
  else {
    translations = 
      XtParseTranslationTable(GLOBAL_nonterminal_text_field_translations);
    XtOverrideTranslations(this_widget,translations);
  }

  XtAddCallback(this_widget, XmNmodifyVerifyCallback, 
		(XtCallbackProc) text_field_edit, NULL);


  return(this_widget);
}




Menu help_help_menu[] = {
  { "Dismiss", "HELP_DISMISS", 'D',
      help_dismiss, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "HELP_HELP!", 'H',
      help_help, NULL, 0, NULL, NULL, BTN_ON },
};




void help(w,title,filename)
     Widget w;
     char *title;
     char *filename;
{
  char buffer[MAXPATHLEN];
  sprintf(buffer,"%s/%s",preferences.help_directory,filename);
  display_text(w,title,buffer,NULL);

}

void display_text(w,title,filename,string)
     Widget w;
     char *title;
     char *filename;
     char *string;
{


  Arg args[ARGLISTSIZE];
  int n = 0;
  Position x, y;
  Widget shell, form, menubar, text;
  XtTranslations translations;

  FILE *fp;
  char buffer[FILEBUFFLEN];


  if(filename) {
    if((fp = fopen(filename,"r")) == NULL) {
      sprintf(buffer,"Could not open file '%s'.",filename);
      mm_log(buffer,WARN);
      return;
    }
  }

  XtSetArg(args[n], XmNtitle, title); n ++;
  XtSetArg(args[n], XmNallowShellResize, TRUE); n ++;
  shell = XtCreateWidget("HELP",
			 topLevelShellWidgetClass,
			 w, args, n ); n = 0;

  form = XmCreateForm(shell, "form", args, n); n = 0;

  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form,"menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar,
		      help_help_menu, XtNumber(help_help_menu), 
		      0, shell);


  XtSetArg(args[n], XmNeditable, FALSE);                          n ++;
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT);             n ++;
  XtSetArg(args[n], XmNwordWrap, TRUE);                          n ++;
  XtSetArg(args[n], XmNrows,     16);              n ++;
  XtSetArg(args[n], XmNcolumns,  80);               n ++;
  XtSetArg(args[n], XmNscrollVertical, TRUE);                    n ++;
  XtSetArg(args[n], XmNscrollHorizontal, FALSE );                n ++;
  text = XmCreateScrolledText(form, "help_text", args, n);
  n = 0;

  translations = XtParseTranslationTable(GLOBAL_text_translations);
  XtOverrideTranslations(text, translations);

  XtManageChild(text);

  if(filename) {
    while(fgets(buffer,sizeof(buffer),fp))
      AppendText(text,buffer);
    fclose(fp);
  }
  else 
    XmTextSetString(text,string);


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);          n ++;
  XtSetArg(args[n], XmNtopWidget, menubar);                      n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);           n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);          n ++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);         n ++;

  XtSetValues(XtParent(text),args,n); n = 0;

  XtAddCallback(shell,XmNdestroyCallback,
		(XtCallbackProc)help_dismiss,shell);

  XtManageChild(form);
  XtManageChild(shell);

  XmTextShowPosition(text,0);

  XtRealizeWidget(shell);
  XFlush(display);

}


void help_dismiss(w,wid,xp)
     Widget w;
     Widget wid;
     XtPointer xp;
{
  XtDestroyWidget(wid);

}


void help_help(w,wid,xp)
     Widget w;
     Widget wid;
     XtPointer xp;
{
  help(wid,"General Text Window","gentext.help");
}


