/* textfncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */


#include "ml.h"

Widget textshell;
int textdone;

/* private function declarations */

#ifdef __STDC__
static void delete_at(int pos1, int pos2, char *str);
static int insert_at(int pos, char *ins, char *str);

#else

static void delete_at();
static int insert_at();

#endif


void string_accept();
void string_cancel();
void string_help();


Menu input_string_menu[] = 
{
  { "Accept", "string_accept", 'A',
      string_accept, NULL, 0, NULL, NULL, BTN_ON },
  { "Cancel", "string_cancel", 'C',
      string_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "string_HELP!", 'H',
      string_help, NULL, 0, NULL, NULL, BTN_ON },
};


/* 
 * Keep from dragging the current selection in a modal list widget into
 * another widget which has no keyboard focus ability, which core dumps.
 *
 */

char GLOBAL_modal_list_translations[] =
"    <Btn2Down>:        ListEndSelect()        \n\
     <Btn2Up>:          ListEndSelect()        \n\
     <Btn2Motion>:      ListEndSelect()        \n";      

char GLOBAL_button_translations[] =
"    <Btn2Down>:          CleanupMenuBar()\n";



char GLOBAL_text_translations[] =
"       ~Meta ~Alt Ctrl<Key>a:          beginning-of-line()             \n\
        ~Meta ~Alt Ctrl<Key>b:          backward-character()            \n\
        ~Meta ~Alt Ctrl<Key>d:          delete-next-character()         \n\
        ~Meta ~Alt Ctrl<Key>e:          end-of-line()                   \n\
        ~Meta ~Alt Ctrl<Key>f:          forward-character()             \n\
        ~Meta ~Alt Ctrl<Key>g:          process-cancel()                \n\
        ~Meta ~Alt Ctrl<Key>h:          delete-previous-character()     \n\
        ~Meta ~Alt Ctrl<Key>k:          delete-to-end-of-line()         \n\
        ~Meta ~Alt Ctrl<Key>w:          cut-clipboard()                 \n\
        Meta ~Ctrl<Key>b:               backward-word()                 \n\
         Alt ~Ctrl<Key>b:               backward-word()                 \n\
        Meta ~Ctrl<Key>d:               delete-next-word()              \n\
         Alt ~Ctrl<Key>d:               delete-next-word()              \n\
        Meta ~Ctrl<Key>f:               forward-word()                  \n\
         Alt ~Ctrl<Key>f:               forward-word()                  \n\
        Meta ~Ctrl<Key>w:               copy-clipboard()                \n\
         Alt ~Ctrl<Key>w:               copy-clipboard()                \n\
        Meta ~Ctrl<Key>osfLeft:         backward-word()                 \n\
         Alt ~Ctrl<Key>osfLeft:         backward-word()                 \n\
        Meta ~Ctrl<Key>osfRight:        forward-word()                  \n\
         Alt ~Ctrl<Key>osfRight:        forward-word()                  \n\
        Meta ~Ctrl<Key>osfBackSpace:    delete-previous-word()          \n\
         Alt ~Ctrl<Key>osfBackSpace:    delete-previous-word()          \n\
        Meta ~Ctrl<Key>osfDelete:       delete-next-word()              \n\
         Alt ~Ctrl<Key>osfDelete:       delete-next-word()              \n\
                                                                        \
        ~Meta ~Alt Ctrl<Key>n:          next-line()                     \n\
        ~Meta ~Alt Ctrl<Key>p:          previous-line()                 \n\
        ~Meta ~Alt Ctrl<Key>v:          next-page()                     \n\
        Meta ~Ctrl<Key>v:               previous-page()                 \n\
         Alt ~Ctrl<Key>v:               previous-page()                 \n  ";

char GLOBAL_text_field_translations[] = 

"	~Meta ~Alt Ctrl<Key>a:		beginning-of-line()		\n\
	~Meta ~Alt Ctrl<Key>b:		backward-character()		\n\
	~Meta ~Alt Ctrl<Key>d:		delete-next-character()		\n\
	~Meta ~Alt Ctrl<Key>e:		end-of-line()			\n\
	~Meta ~Alt Ctrl<Key>f:		forward-character()		\n\
	~Meta ~Alt Ctrl<Key>g:		process-cancel()		\n\
	~Meta ~Alt Ctrl<Key>h:		delete-previous-character()	\n\
	~Meta ~Alt Ctrl<Key>k:		delete-to-end-of-line()		\n\
	~Meta ~Alt Ctrl<Key>w:		cut-clipboard()			\n\
	Meta ~Ctrl<Key>b:		backward-word()			\n\
	 Alt ~Ctrl<Key>b:		backward-word()			\n\
	Meta ~Ctrl<Key>d:		delete-next-word()		\n\
	 Alt ~Ctrl<Key>d:		delete-next-word()		\n\
	Meta ~Ctrl<Key>f:		forward-word()			\n\
	 Alt ~Ctrl<Key>f:		forward-word()			\n\
	Meta ~Ctrl<Key>w:		copy-clipboard()		\n\
	 Alt ~Ctrl<Key>w:		copy-clipboard()		\n\
	Meta ~Ctrl<Key>osfLeft:		backward-word()			\n\
	 Alt ~Ctrl<Key>osfLeft:		backward-word()			\n\
	Meta ~Ctrl<Key>osfRight:	forward-word()			\n\
	 Alt ~Ctrl<Key>osfRight:	forward-word()			\n\
	Meta ~Ctrl<Key>osfBackSpace:	delete-previous-word()		\n\
	 Alt ~Ctrl<Key>osfBackSpace:	delete-previous-word()		\n\
	Meta ~Ctrl<Key>osfDelete:	delete-next-word()		\n\
	 Alt ~Ctrl<Key>osfDelete:	delete-next-word()		\n ";


char GLOBAL_nonterminal_text_field_translations[] =
"	!<Key>Return:		next-tab-group()			\n\
	!<Key>Linefeed:		next-tab-group()			\n ";

char GLOBAL_terminal_text_field_translations[] =
"	<Key>Return:		activate()				\n\
	<Key>Linefeed:		activate()				\n ";


#ifdef __STDC__
char *GetTextField(Widget w)
#else
char *GetTextField(w)
     Widget w;
#endif
{
  return(XmTextGetString(w));

}


#ifdef __STDC__
void AppendText(Widget w, char *str)
#else
void AppendText(w, str)
     Widget w;
     char *str;
#endif
{
  
  XmTextPosition pos;

  if(!str)
    return;

  pos = XmTextGetLastPosition(w);
  XmTextInsert(w,pos,str);
  pos = XmTextGetLastPosition(w);
  XmTextSetInsertionPosition(w, pos);
  return;
}


#ifdef __STDC__
void InsertText(Widget w, char *str)
#else
void InsertText(w, str)
     Widget w;
     char *str;
#endif
{
  XmTextPosition pos;

  if(!str)
    return;

  pos = XmTextGetInsertionPosition(w);
  XmTextInsert(w,pos,str);
  XmTextSetInsertionPosition(w, pos + strlen(str));
  return;
}


#ifdef __STDC__
void text_field_edit(Widget w, XtPointer zilch, XtPointer call_data)
#else
void text_field_edit(w,zilch,call_data)
     Widget w;
     XtPointer zilch;
     XtPointer call_data;
#endif
{
  XmTextVerifyCallbackStruct *ptr = (XmTextVerifyCallbackStruct *) call_data;
  register char *n;

  if(ptr == NULL)
    return;

  if(ptr->text->length != 0) {
    for(n = ptr->text->ptr; *n != NUL_TERM; n ++) 
      if(*n == LFCHAR)
	*n = NUL_TERM;
    ptr->text->length = strlen(ptr->text->ptr);
    ptr->doit = TRUE;
  }

}


#ifdef __STDC__
void text_nospace_edit(Widget w, XtPointer zilch, XtPointer call_data)
#else
void text_nospace_edit(w,zilch,call_data)
     Widget w;
     XtPointer zilch;
     XtPointer call_data;
#endif
{
  XmTextVerifyCallbackStruct *ptr = (XmTextVerifyCallbackStruct *) call_data;
  register char *n;

  if(ptr == NULL)
    return;

  if(ptr->text->length != 0) {
    for(n = ptr->text->ptr; *n != NUL_TERM; n ++) 
      if((*n == SPACECHAR) || (*n == TABCHAR))
	*n = '_';
    ptr->text->length = strlen(ptr->text->ptr);
    ptr->doit = TRUE;
  }

}






#ifdef __STDC__
void passwd_edit(Widget w, Remote_Auth *authst, XtPointer call_data)
#else
void passwd_edit(w,authst,call_data)
     Widget w;
     Remote_Auth *authst;
     XtPointer call_data;
#endif
{
  XmTextVerifyCallbackStruct * ptr;
  int n = 0;
  int num_inserted;


  ptr = (XmTextVerifyCallbackStruct *) call_data;
  if(ptr == NULL)
    return;

  if(ptr->text->length == 0) {
    delete_at(ptr->startPos,ptr->endPos, authst->workspace);
  }
  else {
    num_inserted = insert_at(ptr->currInsert,ptr->text->ptr,authst->workspace);
    for(n = 0; n < num_inserted; n ++)
      ptr->text->ptr[n] = PASSWD_CHAR;
    ptr->doit = TRUE;
  }
}

#ifdef __STDC__
static void delete_at(int pos1, int pos2, char *str)
#else
static void delete_at(pos1,pos2,str)
     int pos1;
     int pos2;
     char *str;
#endif
{
  int i, j;
  char buf[FILEBUFFLEN];
  
  for(i = 0; i < pos1; i ++)
    buf[i] = str[i];

  j = i;
  for(i = pos1; i < pos2; i ++ )
    ;

  while(str[i]) {
    buf[j] = str[i];
    j++;
    i++;
  }

  buf[j] = NUL_TERM;
  strcpy(str,buf);

  for(i = 0; i < FILEBUFFLEN; i ++)
    buf[i] = NUL_TERM;

  return;
}


#ifdef __STDC__
static int insert_at(int pos, char *ins, char *str)
#else
static int insert_at(pos,ins,str)
     int pos;
     char *ins;
     char *str;
#endif
{
  int i, j, k;
  int base_len = strlen(str);
  int insert_len = strlen(ins);
  char buf[FILEBUFFLEN];

  if(pos >= base_len) {
    strcat(str,ins);
    return(insert_len);
  }
  else {
    for(i = 0; i < pos; i ++) 
      buf[i] = str[i];
    buf[i] = NUL_TERM;

    j = 0;
    for(k = pos; k < (pos + insert_len); k ++) {
      buf[k] = ins[j];
      j ++;
    }
    buf[pos + insert_len] = NUL_TERM;

    strcat(buf,&str[pos]);
    strcpy(str, buf);
  }
  for(i = 0; i < FILEBUFFLEN; i ++)
    buf[i] = NUL_TERM;
  return(insert_len);
}

/* 
 * scramble() produces a non readable copy of a string, 
 * in allocated space. Caller needs to free.
 */

#ifdef __STDC__
char *scramble(char *str)
#else
char *scramble(str)
     char *str;
#endif
{
  int i;
  char *ret;

  if(! str)
    return(NULL);
 
  ret = (cpystr(str));
  
  for(i = 0; ret[i]; i ++)
    ret[i] = ret[i] ^ PASSWORD_PATTERN;

  return(ret);

}


/* Zero out a text string. */


#ifdef __STDC__
void wipeout(char *str)
#else
void wipeout(str)
     char *str;
#endif
{
  register char *ptr;

  if(! str)
    return;
 
  for(ptr = str; *ptr != NUL_TERM; ptr ++)
    *ptr = NUL_TERM;

}




#ifdef __STDC__
void zap_commas(char *str)
#else
void zap_commas(str)
     char *str;
#endif
{
  register char *ptr;

  if(! str)
    return;
 
  for(ptr = str; *ptr != NUL_TERM; ptr ++)
    if(*ptr == ',')
      *ptr = SPACECHAR;

}




char *stripcr(str)
     char *str;
{
  register int i,j;
  if (str) {			
    for (i = j = 0; str[i] != NUL_TERM; i++)
      if(str[i] != CRCHAR || str[i+1] != LFCHAR ) 
	str[j++] = str[i];
    str[j] = NUL_TERM;
  }
  return (str);
}

char *striplf(str)
     char *str;
{
  register int i,j;
  if (str) {			
    for (i = j = 0; str[i] != NUL_TERM; i++)
      if(str[i] != LFCHAR ) 
	str[j++] = str[i];
    str[j] = NUL_TERM;
  }
  return (str);
}




/*
 * first_nonwhite returns a pointer to the first non-whitspace
 * character in a string. Warning: Don't free the result.
 *
 */


#ifdef __STDC__
char *first_nonwhite(char *str)
#else
char *first_nonwhite(str)
     char *str;
#endif
{
  char *ptr = str;

  if(ptr != NULL)
    while(isspace(*ptr))
	  ptr ++;

  return(ptr);

}


#ifdef __STDC__
void remove_trailing_white(char *str)
#else
void remove_trailing_white(str)
     char *str;
#endif
{

  char *ptr = NULL;

  if((str == NULL) || (*str == NUL_TERM))
    return;

  ptr = str + ((strlen(str)) - 1);

  while(isspace(*ptr)) {
    *ptr = NUL_TERM;
    ptr --;
  }

  return;
}



#ifdef __STDC__
void free_binary_buffer(Binary_Buffer *binary_buffer)
#else
void free_binary_buffer(binary_buffer)
     Binary_Buffer *binary_buffer;
#endif
{
  if(binary_buffer) {
    if(binary_buffer->data)
      fs_give((void **) &binary_buffer->data);
    fs_give((void **) &binary_buffer);
  }

}




#ifdef __STDC__
Binary_Buffer *load_binary_file(char *filename)
#else
Binary_Buffer *load_binary_file(filename)
     char *filename;
#endif
{

  FILE *fp;
  Binary_Buffer *binary_buffer = NULL;
  struct stat st;
  unsigned long bytes_read  = 0L;
  unsigned long bytes_total = 0L;
  char *ptr;

  if(((stat(filename,&st)) != SYSCALL_SUCCESS)
     || (st.st_size == 0)
     || ((fp = fopen(filename,"r")) == NULL))
    return(NULL);

  binary_buffer = (Binary_Buffer *) fs_get(sizeof(Binary_Buffer));
  binary_buffer->length = (unsigned long) st.st_size;
  binary_buffer->data = (unsigned char *) fs_get(st.st_size + 1);

  ptr = (char *) binary_buffer->data;

  do {
    bytes_read = fread(ptr, 1, ((unsigned long) st.st_size) - bytes_total, fp);
    bytes_total += bytes_read;
    ptr += bytes_read;
  } while ((bytes_read != 0) && (bytes_total < (unsigned long) st.st_size));
  
  fclose(fp);

  binary_buffer->data[binary_buffer->length] = NUL_TERM;

  if(bytes_total != (unsigned long) st.st_size) {
    free_binary_buffer(binary_buffer);
    binary_buffer = NULL;
  }

  return(binary_buffer);

}


char *wrap_text(str,linelen)
     char *str;
     int linelen;
{
  int i = 0;
  char *src = str;
  char *dst, *ptr;
  unsigned long dstsize;

  if(! str)
    return(NULL);

  /* allocate source length + overhead to allow expansion  */

  dstsize = (unsigned long) strlen(src) 
    + (((unsigned long) strlen(src)) / (unsigned long) linelen) + 2;
  
  ptr = (char *) fs_get(dstsize);
  dst = ptr;

  while( *src != NUL_TERM ) {
    i ++;
    switch(*src) {
    case TABCHAR:
      if((i + (TABSIZE - 1)) > linelen) {
	*dst = LFCHAR;
	i = 0;
	break;
      }
      *dst = *src;
      i += (TABSIZE - 1);      
      break;
    case LFCHAR:
      *dst = *src;
      i = 0;
      break;
    case SPACECHAR:
      if((i + wordlen(src + 1)) > linelen ) {
	*dst = LFCHAR;
	i = 0;
	break;
      }
      else {
	*dst = *src;
	break;
      }
    default:
      *dst = *src;
      break;
    }
    src ++;
    dst ++;
  }

  *dst = NUL_TERM;
  return(ptr);
  
}

/* returns the number of chars in the string contained in 's' up
 * to the next whitespace character.
 */

int wordlen(s)
     char *s;
{
  register int cnt = 0;
  register char *ptr = s;

  while((*ptr) && (!isspace(*ptr))) {
    ptr ++;
    cnt ++;
  }
  return(cnt);
}



char *lftocrlf(src)
     char *src;
{
  char *dst = NULL;
  register char *ptr;
  register unsigned int lines = 0;
  register unsigned int i;
  register unsigned int j;
  
  if(! src)
    return(NULL);

  for(ptr = src; *ptr != NUL_TERM ; ptr ++)
    if(*ptr == LFCHAR || *ptr == CRCHAR)
      lines ++;
  
  dst = (char *) fs_get(strlen(src) + lines + 1);
  
  for (i = j = 0; src[i] != NUL_TERM ; i++) {
    if (src[i] == LFCHAR)
      dst[j++] = CRCHAR;
    else 
      if(src[i] == CRCHAR && src[i+1] == LFCHAR)
	dst[j++] = src[i++];
    
    dst[j++] = src[i];
    
    if (src[i] == CRCHAR)
      dst[j++] = LFCHAR;
  }
    
  dst[j] = NUL_TERM;	

  return(dst);
}




char *input_string(w,title,default_string,help_file)
     Widget w;
     char *title;
     char *default_string;
     char *help_file;
{

  Arg args[ARGLISTSIZE];
  char buff[FILEBUFFLEN];
  Position x, y;
  XtTranslations trans;
  char *ret = NULL;
  int n = 0;
  int i;
  Widget form, menubar, text;
  XtTranslations translations;



  textdone = 0;
  get_pointer_position(w, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;
  XtSetArg(args[n], XmNallowShellResize, TRUE); n ++;
  XtSetArg(args[n], XmNtitle, title); n ++;

  textshell = XtCreatePopupShell("string_input",
				     transientShellWidgetClass, w,
				     args, n);
  n = 0;


  XmAddTabGroup(textshell);

  form = XmCreateForm(textshell, "form", args, n); n = 0;
  
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form,"menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, 
		      input_string_menu, 
		      XtNumber(input_string_menu), BTN_ON, help_file);


  sprintf(buff,"%s :",title);

  text = create_text_field(form, menubar, 
		      buff, default_string, 32, string_accept, NULL);

  XtManageChild(form);
  XtPopup(textshell,XtGrabExclusive); 
  set_pirate_cursors();
  modal_main_loop(&textdone);

  ret = GetTextField(text);

  XtPopdown(textshell);
  XtDestroyWidget(textshell);
  
  reset_cursors();
  if((textdone > 0) && (*ret != NUL_TERM)) 
    return(ret);

  if(ret)
    fs_give((void **) &ret);

  return(NULL);

}


void string_accept(w,zilch,xp)
     Widget w;
     XtPointer zilch;
     XtPointer xp;
{
  textdone = 1;
}


void string_cancel(w,zilch,xp)
     Widget w;
     XtPointer zilch;
     XtPointer xp;
{
  textdone = (-1);
}


void string_help(w,zilch,xp)
     Widget w;
     char *zilch;
     XtPointer xp;
{

  help(textshell,"Input Text",zilch);

}


void text_unwrap(w,xp)
     Widget w;
     XtPointer xp;
{

  XmTextPosition left, right;
  Time timestamp;
  char *the_text;
  char *ptr;

  XmTextGetSelectionPosition(w,&left,&right);
  if(left == right)
    return;

  the_text = XmTextGetSelection(w);

  if(session.compose->edit->buffer) 
    fs_give((void **) &session.compose->edit->buffer);
  session.compose->edit->buffer = cpystr(the_text);
  session.compose->edit->begin = left;
  session.compose->edit->end   = right;

  for(ptr = the_text; *ptr != NUL_TERM; ptr ++) {
    if(*ptr == LFCHAR) {
      if((*(ptr + 1)) == LFCHAR)
	ptr += 2;
      else
	*ptr = SPACECHAR;
    }
  }
  XmTextReplace(w,left,right,the_text);
  timestamp = XtLastTimestampProcessed(XtDisplay(w));
  XmTextSetSelection(w,left,right,timestamp);
  fs_give((void **) &the_text);
}




void text_strip_prefix(w,prefix)
     Widget w;
     char *prefix;
{

  XmTextPosition left, right;
  Time timestamp;
  char *the_text;
  char *ret;
  char *src;
  char *dst;

  XmTextGetSelectionPosition(w,&left,&right);
  if(left == right)
    return;

  the_text = XmTextGetSelection(w);
  ret = (char *) fs_get(strlen(the_text));

  dst = ret;
  for(src = the_text; *src != NUL_TERM; src ++) {
    if(src == the_text) {
      if(strncmp(src,prefix,strlen(prefix)) == STRMATCH) {
	src += (strlen(prefix) - 1);
	continue;
      }
    }
    if((*src == LFCHAR)) {
      if((*(src + 1)) && (strncmp(src+1,prefix,strlen(prefix)) == STRMATCH)) {
	*dst = *src;
	dst ++;
	src += strlen(prefix);
	continue;
      }
    }
    *dst = *src;
    dst ++;
  }
  *dst = NUL_TERM;

  if(session.compose->edit->buffer) 
    fs_give((void **) &session.compose->edit->buffer);
  session.compose->edit->buffer = cpystr(the_text);
  session.compose->edit->begin = left;
  session.compose->edit->end   = left + strlen(ret);

  XmTextReplace(w,left,right,ret);
  timestamp = XtLastTimestampProcessed(XtDisplay(w));
  XmTextSetSelection(w,left,left + strlen(ret),timestamp);
  fs_give((void **) &the_text);
  fs_give((void **) &ret);
}


void text_rewrap(w,wraplen)
     Widget w;
     int wraplen;
{

  XmTextPosition left, right;
  Time timestamp;
  char *the_text;
  char *ret;

  XmTextGetSelectionPosition(w,&left,&right);
  if(left == right || wraplen <= 0)
    return;


  the_text = XmTextGetSelection(w);

  ret = wrap_text(the_text,wraplen - 1);


  if(session.compose->edit->buffer) 
    fs_give((void **) &session.compose->edit->buffer);
  
  session.compose->edit->buffer = cpystr(the_text);
  session.compose->edit->begin = left;
  session.compose->edit->end   = left + strlen(ret);
  
  XmTextReplace(w,left,right,ret);
  timestamp = XtLastTimestampProcessed(XtDisplay(w));
  XmTextSetSelection(w,left,left + strlen(ret),timestamp);
  fs_give((void **) &the_text);
  fs_give((void **) &ret);
}



void text_prefix(w,prefix)
     Widget w;
     char *prefix;
{

  XmTextPosition left, right;
  Time timestamp;
  int lines;
  char *the_text;
  char *ret;
  char *src;
  char *dst;

  XmTextGetSelectionPosition(w,&left,&right);
  if(left == right)
    return;

  the_text = XmTextGetSelection(w);

  lines = count_lines(the_text);
  ret = (char *) fs_get(strlen(the_text) 
			+ ((lines * (strlen(prefix) + 1)) + 1));
  
  strcpy(ret,prefix);
  dst = ret + strlen(prefix);
  
  for(src = the_text; *src != NUL_TERM; src ++) {
    if(*src == LFCHAR) {
      *dst = *src;
      dst ++;
      strcpy(dst,prefix);
      dst += strlen(prefix);
      continue;
    }
    *dst = *src;
    dst ++;
  }
  *dst = NUL_TERM;



  if(session.compose->edit->buffer)
    fs_give((void **) &session.compose->edit->buffer);

  session.compose->edit->buffer = cpystr(the_text);
  session.compose->edit->begin = left;
  session.compose->edit->end   = left + strlen(ret);


  XmTextReplace(w,left,right,ret);
  timestamp = XtLastTimestampProcessed(XtDisplay(w));
  XmTextSetSelection(w,left,left + strlen(ret),timestamp);
  fs_give((void **) &the_text);
  fs_give((void **) &ret);
}

int count_lines(s)
     char *s;
{
  int n = 0;
  char *ptr;
  
  if(s == NULL)
    return(0);

  for(ptr = s; *ptr; ptr ++)
    if(*ptr == LFCHAR)
      n ++;

  return(n);

}


/* 
 * XmTextInsertString() seems to have a bug which screws up the scroll
 * bars when inserting more than a screenful at a time. This is a
 * function to bypass it. We break up the existing text into that before 
 * and after the insert position, and then recombine with our inserted text,
 * using XmTextSetString() to blast it onto the screen. Before finishing up,
 * the new insert position is set.
 */

void text_blast(w,str)
     Widget w;
     char *str;
{
  char *begin;
  char *end;
  char *existing;

  XmTextPosition pos = XmTextGetInsertionPosition(w);
 
  existing = XmTextGetString(w);

  if(pos) {
    begin = (char *) fs_get(pos + 1);
    strncpy(begin,existing,pos);
    begin[pos] = NUL_TERM;
  }
  else
    begin = cpystr(EMPTYSTR);
  
  end = cpystr(existing + pos);

  fs_give((void **) &existing);      /* free it up for re-use. */

  existing = (char *) fs_get(strlen(begin) + strlen(str) + strlen(end) + 1);
  strcpy(existing,begin);
  strcat(existing,str);
  strcat(existing,end);
  XmTextSetString(w, existing);
  XmTextSetInsertionPosition(w, pos + strlen(str));
  fs_give((void **) &existing);
  fs_give((void **) &begin);
  fs_give((void **) &end);
}
  






