/* structures.h
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */




typedef struct flag_to_parse_type {
  char *flag;				/* one of the flag strings */
  unsigned long token_states;		/* token equivalents */
} FLAG_TO_PARSE_TYPE;


/* 
 * This is loaded at the start of the program,
 * and remains in memory until program exit.
 */

typedef struct _LOCAL_AUTH_ {
  char *hostname;
  char *username;
  char *fullname;
  char *homedir;
  char *shell;

} Local_Auth;


/* 
 * This is a structure for any remote authorization, returned by
 * the "login()" function. We can link these together to avoid
 * requesting a login more than once for a particular service.
 * The widgets will be invalid once the information has been entered.
 */

typedef struct _REMOTE_AUTH_ {
  
  char *hostname;
  char *authtype;
  char *username;
  char *password;
  char *workspace;
  int done;
  Widget shell;
  Widget name;
  Widget pass;

  struct _REMOTE_AUTH_ * next;

} Remote_Auth;



typedef struct _KEYWORD_WIN_ {
  Widget shell;
  Widget list;
  int done;
  char *keyword;
} Keyword_Win;


/*
 * Structure for holding loaded files, which are perhaps binary.
 */

typedef struct _BINARY_BUFFER_ {

  unsigned char *data;
  unsigned long length;

} Binary_Buffer;


/*
 * Linked list of mailbox names returned by server.
 */

typedef struct _MAILBOX_LIST_ {

  char *name;

  struct _MAILBOX_LIST_ * next;
  struct _MAILBOX_LIST_ * prev;

} Mailbox_List;


/*
 * Control structure for mailbox selection windows.
 */

typedef struct _MAILBOX_WIN_ {

  Widget shell;
  Widget server;
  Widget mailbox;
  Widget list;
  int type;
  Boolean local_only;
  unsigned long button_state;
  int done;

} Mailbox_Win;


/* 
 * Used to keep the mailbox lists for every server they have been
 * requested from. It is not necessary to open a mailbox on the
 * server.
 */

typedef struct _SERVER_LIST_ {

  char *name;
  int type;

  Boolean active;
  Mailbox_List *mailbox_list;

  struct _SERVER_LIST_ *next;
  struct _SERVER_LIST_ *prev;

} Server_List;


/*
 * Linked list for holding address book entries.
 */

typedef struct _ADDRESS_BOOK_INFO_ {

  char *name;
  char *address;
  char *comment;
  struct _ADDRESS_BOOK_INFO_ *next;
  struct _ADDRESS_BOOK_INFO_ *prev;

} Address_Book_Info;

/*
 * The control structure for the address book window.
 */


typedef struct _ADDRESS_BOOK_ {
  
  Widget shell;
  Widget name;
  Widget address;
  Widget comment;
  Widget pattern;
  Widget list;
  Widget search_list;

  Widget current_list;
  Boolean is_realized;

  unsigned long button_state;
  struct _ADDRESS_BOOK_INFO_ *address_book_info;
  struct _ADDRESS_BOOK_INFO_ *current;

} Address_Book;


/*
 * Used to map a file attachment to a MIME type based on the
 * filename extension.
 */

typedef struct _FILENAME_MAP_ {

  char *suffix;
  int type;
  char *subtype;
  struct _FILENAME_MAP_ *next;

} Filename_Map;


/*
 * Structure for maintaining external (or internal?) MIME handlers
 */


typedef struct _MIME_HANDLER_ {

  int type;                        /* type this applies to */
  char *subtype;                   /* subtype this applies to */
  Boolean view_builtin;            /* not used */
  void *builtin;                   /* not used */
  char *view;                      /* executable command string to view */
  char *compose;                   /* executable command string to compose */
  struct _MIME_HANDLER_ *next;

} Mime_Handler;


/* 
 * Linked list of recognized MIME types
 */

typedef struct _MIME_TYPE_ {

  int type;
  char *subtype;
  struct _MIME_TYPE_ * next;

} Mime_Type;


/*
 * Control structure for MIME classification window
 */


typedef struct _MIME_ATTACH_ {

  Widget shell;
  Widget desc_text;
  Widget type_text;
  Widget type_list;

  char *compose;

  int done;

} Mime_Attach;

/*
 * Control structure for "linearizing" nested attachments and relating
 * them to a list widget.
 */


typedef struct _PART_LIST_ {

  int partnumber;
  PART *part;
  char *partstr;

  struct _PART_LIST_ *prev;
  struct _PART_LIST_ *next;

} Part_List;


/* 
 * Possible types of message compositions.
 */


typedef enum _COMPOSE_TYPE_ {

  COMPOSE_NEW            = 0,
  COMPOSE_REPLY          = 1,
  COMPOSE_REPLYALL       = 2,
  COMPOSE_FORWARD        = 3,
  COMPOSE_FORWARDATTACH  = 4,
  COMPOSE_REMAIL         = 5,

} Compose_Type;


/* 
 * Per-message structure for storing message compositions.
 */


typedef struct _COMPOSE_INFO_ {
  
  char *title;
  char *from;
  char *to;
  char *newsgroups;
  char *subject;
  char *cc;
  char *bcc;
  char *text;

  char *remail_header;
  char *in_reply_to;
  char *reply_text;

  MAILSTREAM *mailstream;
  unsigned long msgno;

  unsigned long button_state;

  int behaviour;                   /* ??? MAIL_BEHAVIOUR || NEWS_BEHAVIOUR */
  Boolean watch_send;              /* Enable SMTP stream debug ?       */
  Boolean keep_open;
  Compose_Type compose_type;       /* reply, remail, forward, etc. */

  int number;
  int selection;
  PART *attachments;

  struct _COMPOSE_INFO_ *next;     /* reverse order */
  struct _COMPOSE_INFO_ *prev;     /* reverse order */
  struct _PART_LIST_ *part_list;

} Compose_Info;


/*
 *  Control structure for the compose "edit tool".
 */


typedef struct _EDIT_ {
  
  Widget shell;
  Widget strip_text;
  Widget insert_text;
  Widget wrap_text;
  Widget undo;
  Widget paste;

  Boolean is_realized;
  char *buffer;
  Position begin;
  Position end;

} Edit;



/*
 * Control structure for the compose window.
 */


typedef struct _COMPOSE_ {

  Widget shell;
  Widget from_text;
  Widget to_label;
  Widget to_text;
  Widget ng_label;
  Widget ng_text;
  Widget cc_text;
  Widget bcc_text;
  Widget subject_text;
  Widget compose_text;
  Widget compose_attach;
  Widget list_shell;
  Widget list_list;
  int    list_done;

  Edit *edit;

  Compose_Info *compose_info;
  Compose_Info *current;
  
  Boolean is_realized;

} Compose;


/*
 * Data structure for the file selection window
 */

typedef struct _DIR_STRUCT_ {

  char *name;
  Boolean directory;
  struct _DIR_STRUCT_ * next;

} Dir_Struct;


/*
 * Control structure for the file selection window.
 */


typedef struct _DIRVIEW_ {

  Widget shell;
  Widget dir_path;
  Widget dir_file;
  Widget dir_pattern;
  Widget dir_dirlist;
  Widget dir_filelist;

  unsigned long button_state;

  char *cwd;
  char *pathname;

  int recurse;
  Boolean ignore_dot;

  Dir_Struct *dir_struct;
  int done;

} Dirview;


/*
 * Types of messages for the read window
 */


typedef enum _MESSAGE_TYPE_ {
  MESSAGE_NORMAL    = 0,
  MESSAGE_PART      = 1,
  MESSAGE_RAWPART   = 2,
  MESSAGE_IN_MEMORY = 3,
  MESSAGE_FROM_FILE = 4,
  
} Message_Type;


/*
 * Currently unused
 */

typedef enum _REPRESENTATION_TYPE_ {
  REP_ASCENDING     = 0,
  REP_DESCENDING    = 1,
  REP_SORT_FLAGS    = 2,
  REP_SORT_SENDER   = 3,
  REP_SORT_SUBJECT  = 4,

} Representation_Type;


/*
 * Per-message data structure for the read window
 */


typedef struct _READ_INFO_ {


  Message_Type message_type;
  int mailbox_type;
  MAILSTREAM *mailstream;
  unsigned long msgno;
  Boolean fetched;

  char *server;
  char *current_part_str;
  char *base_part_str;
  char *header;
  char *short_header;
  char *current_text;
  char *alt_text;

  PART *current_part;
  BODY *body;
  ENVELOPE *envelope;
  Boolean show_long_header;

  Boolean show_entire;
  Boolean show_alt;
  Boolean rfc_msg_leaf;
  PART *attachments;
  unsigned long button_state;

  unsigned long number; 

  unsigned long selection;

  Part_List *part_list;

  struct _READ_INFO_ *next;       /* reverse order */
  struct _READ_INFO_ *prev;       /* reverse order */


} Read_Info;


/*
 * Control structure for read window
 */

typedef struct _READ_ {

  Widget shell;
  Widget read_header;
  Widget read_text;
  Widget read_attach;

  Boolean is_realized;


  Widget list_shell;
  Widget list_list;

  int list_done;

  struct _READ_INFO_ *current;
  struct _READ_INFO_ *read_info;

} Read;


/*
 * Control structure for PGP "address book"
 */


typedef struct _PGPKV_ {

  Widget shell;
  Widget text;
  Widget list;

  int done;

  char *result;

} Pgpkv;


/*
 * Control structure for the main Preferences window
 */


typedef struct _PREFST_ {
  Widget shell;
  Widget imapname;
  Widget mailname;
  Widget smtpname;
  Widget nntpname;
  Widget replname;
  Widget pgpname;
  Widget pgppath;
  Widget sigfile;
  Widget prntcmd;
  Widget fldrpath;
  Widget helpdir;

  Boolean is_realized;
} Prefst;


typedef struct _PREF2ST_ {
  Widget shell;
  Widget dfl_action;
  Widget url_command;
  Widget savebox;
  Widget mime_dir;
  Widget defcc;
  Widget defbcc;
  Widget check_interval;
  Widget view_height;
  Widget read_height;
  Widget compose_height;
  Widget imap_port;
  Widget smtp_debug;
  Widget auto_open;
  Widget hide_empty;

  Boolean is_realized;
} Pref2st;


/* 
 * Data structure maintained for each open mailbox.
 */


typedef struct _MAILBOX_ {
  
  MAILSTREAM *mailstream;
  char *host;
  char *mailboxname;
  char *imapname;
  int type;               /* mailbox or newsgroup */
  unsigned nmsgs;         /* number of messages in the mailbox */

  Boolean fetched;        /* We've loaded the messages */
  Boolean has_new_mail;   /*
			   * Something new arrived. Triggers various
			   * later actions such as re-evaluating 
			   * logical views
			   */

  struct _MESSAGE_LIST_ *found;     /* results of mailbox search */

  /*
   * The following three items are used to indicate that something
   * has changed in the mailbox, all as a result of flag changes,
   * but all are used to control different actions. "flags_changed" 
   * indicates that the mailbox should be checkpointed (changes flushed
   * by the server) on the next new mail check. "update_needed" informs
   * us that any active filters need to be re-evaluated, and refresh_needed
   * indicates that flags changed in the current (visible) logical view,
   * so it need to be redisplayed, whether or not its actual message list
   * changes during filter updates.
   */


  unsigned long flags_changed; 

  int update_needed;
  int refresh_needed;


  XtIntervalId timer;          /* new mail check timer for this mailbox */

  struct _MAILBOX_ * next;
  struct _MAILBOX_ * prev;

} Mailbox;


/* 
 * Data structure for an individual message used by the logical views.
 *.One of these exists for each message in the mailbox. Many Message_List 
 * structures may reference each of these individual messages.
 */

typedef struct _MESSAGE_ {

                          /* 
			   * Various structures used to deal with the 
			   * IMAP c-client interface on behalf of this
			   * message.
			   */
  unsigned long msgno;
  Mailbox *mailbox;
  MAILSTREAM *mailstream;
  ENVELOPE *envelope;
  BODY *body;
  LONGCACHE *longcache;

  XmString viewline;         /* The line shown in the view window */
  Boolean in_view;           /* true if contained in ANY user defined view */

  char *header;                   /* unused? */
  char *text;                     /* unused? */
  char *ext_text;                 /* unused? */

} Message;


/*
 * Linked list of messages. This is the heart of the logical view system.
 */


typedef struct _MESSAGE_LIST_ {

  struct _MESSAGE_ *message;
  Boolean selected;
  unsigned long number;
  struct _MESSAGE_LIST_ *next;
  struct _MESSAGE_LIST_ *prev;

} Message_List;


/*
 * Types of filters
 */


typedef enum _FILTER_TYPE_ {
  
  FILTER_TYPE_UNKNOWN = 0,
  FILTER_TYPE_ALL     = 1,
  FILTER_TYPE_BUCKET  = 2,
  FILTER_TYPE_SYSTEM  = 3,
  FILTER_TYPE_USER    = 4,
  FILTER_TYPE_ONESHOT = 5,

} Filter_Type;

/*
 * Possible ways to show a message header
 */

typedef enum _HEADERMODE_ {

  HEADER_UNKNOWN = 0,
  HEADER_FULL    = 1,
  HEADER_PART    = 2,
  HEADER_NONE    = 3,

} Header_Mode;


typedef enum {
  NO_ACT       = 0,
  DELETE_ACT   = 1,
  EXPUNGE_ACT  = 2,
  COPY_ACT     = 3,
  MOVE_ACT     = 4,
  SAVE_ACT     = 5,
  SHELL_ACT    = 6,
  FLAG_ACT     = 7,
  KEYWORD_ACT  = 8,
  REPLY_ACT    = 9,
  PRINT_ACT    = 10,
  SELECT_ACT   = 11,
  NEW_ACT      = 12,
  UNSELECT_ACT = 13,
  READ_ACT     = 14,
  
 } ACTIONS;


typedef struct _actionrec {
  char *name;
  ACTIONS action;
  Boolean option;
  Boolean arg;
  Boolean implemented;
} ACTIONREC;

typedef struct _headerrec {
  char *name;
  Header_Mode hdrtype;
} HEADERREC;















/*
 * Possible ways to attach a filter to a mailbox
 */


typedef enum _ATTACH_OPERATION_ {

  ATTACH_UNKNOWN      = 0,
  ATTACH_ONCE_CURRENT = 1,
  ATTACH_ONCE_MAILBOX = 2,
  ATTACH_CURRENT      = 3,
  ATTACH_MAILBOX      = 4,

} Attach_Operation;


/*
 * Data structure for filter definitions
 */


typedef struct _FILTER_ {

  char *mailboxname;               /* mailbox we're associated with */
  char *name;                      /* filter name */
  char *text;                      /* the filter definition or rules */
  char *action;                    /* default handling "script" */ 

  LEAF *search_tree;               /* result of parsing the filter rules */
  unsigned long search_types;      /* sortof unused */
  Boolean archived;                /* unused */

  Filter_Type filter_type;

  unsigned long number;           /* list widget sequence number */

  struct _FILTER_ * next;         /* used in editor, not in logical views */
  struct _FILTER_ * prev;

} Filter;


/*
 * Control structure for the filter edit window
 */

typedef struct _EDFILTER_ {
  
  Widget shell;
  Widget name;
  Widget action;
  Widget text;
  Widget list;

  Filter *current;
  unsigned long selection;
  unsigned long button_state;
  Boolean is_realized;

} Edfilter;


/*
 * Data structure for the view window. Contains a filter and
 * a message_list which define the current view. Other items
 * included to maintain the window state.
 */

typedef struct _LVIEW_ {

  MAILSTREAM *mailstream;               /* our mailstream */
  Mailbox *mailbox;                     /* and our mailbox */
  char *title;                          /* window title */
  struct _MESSAGE_LIST_ *message_list;  /* this view's messages */
  unsigned long count;                  /* message count */
  unsigned long num_selected;           /* number selected messages */
  Boolean selected;                     /* is lview itself selected? */
  unsigned long number;                 /* lview selector list sequence */
  Boolean has_new;                      /* any new messages in the view ? */
  unsigned long button_state;           /* state of this view */
  int level;                            /* nested logical view level */

  Boolean scripting;
  char *script_arg;
  Header_Mode script_header;

  struct _FILTER_ *filter;              /* our filter definition */

  struct _LVIEW_ *parent;               /* heirarchical views. */

  struct _LVIEW_ *prev;                 
  struct _LVIEW_ *next;

} Lview;


/*
 * Control structure for the view window.
 */

typedef struct _VIEW_ {

  Widget shell;
  Widget form;
  Widget action;
  Widget list;

  Boolean is_realized;

  Widget  list_shell;
  Widget  list_list;
  Boolean list_is_realized;

  Boolean hide_empty;

  struct _LVIEW_ *current;
  struct _LVIEW_ *lview;

} View;

/*
 * Used to map a mailbox name to a file containing default filters 
 * for that mailbox.
 */


typedef struct _FILTER_MAP_ {

  char *mailboxname;
  char *filename;
  int sequence;
  struct _FILTER_MAP_ *next;

} Filter_Map;



/* 
 * Top level structure which can access most everything in the program.
 */


typedef struct _SESSION_ {

  Boolean busy;
  Mailbox *mailboxes;
  Mime_Handler *mime_handlers;
  Filter *filters;
  Server_List *server_list;
  Remote_Auth *authorizations;
  
  unsigned long button_state;
  int update_needed;                /* flags changed during a callback */
  Compose *compose;
  Read *read;
  View *view;
  Address_Book *address_book;
  Prefst *prefst;
  Pref2st *pref2st;

  Edfilter *edfilter;
  Filter_Map *filter_map;

} Session;

