
#ifdef __STDC__

/* addressfncs.c */
extern ADDRESS *text_to_address(char *text, char *host);
extern ADDRESS *copy_address(ADDRESS *src_address);

/* authenticate.c */
extern Remote_Auth *login(Widget w, char *host, char *type, 
			  char *username, char *password);
extern void free_remote_auth(Remote_Auth *authst);


/* buttons.c */
extern void create_menu_buttons(char *title, Widget menu, 
				Menu *menulist, int size,
				unsigned long state, XtPointer callback);
extern void check_buttons(Menu *menulist, int size, unsigned long state);


/* compose.c */
extern Compose_Info *compose(char *title, int behaviour, 
		      Compose_Type type, Read_Info *read_info, 
		      Lview *lview, Message *message);
extern void make_attachment_list(Compose *compose);
extern void complete_address(Widget w,XtPointer xp);
extern char *lookup_address(char *str);


/* filefncs.c */
extern char *file_select(Widget w, char *dir, char *filter, char *file,
			 Boolean op_write, Boolean *op_append);

/* localsearch.c */
char *update_dynamic_predicates(LEAF *leaf);


/* lvfncs.c */
Message_List *do_imap_search(Mailbox *mailbox, Lview *parent, LEAF * petal);

/* mailboxes.c */
extern char *format_mailbox_name(char *server,char *mailbox, int type);
extern char *format_server_name(char *server, int type);

extern char *get_mailbox_name();
extern char *fix_mailboxpath(char *str);
extern char *unfix_mailboxpath(char *str);

/* mime.c */
extern void parse_external(BODY *body, Binary_Buffer *binary_buffer);
extern Boolean get_type_from_suffix(BODY *body, char *filename);
extern int name_to_type(char *str);
extern char *type_to_name(int type);
extern Mime_Handler *get_handler(int type, char *subtype);
extern Binary_Buffer *create_mime_compose_window(Widget w, BODY *body);
extern char *find_param(BODY *body, char *s);
extern Boolean is_ftp(BODY *body);
extern Boolean is_extmail(BODY *body);
extern void get_external(BODY *body, char *text);
extern void fetch(BODY *body);

/* miscfncs.c */
extern Filter_Map *new_filter_map(void);
extern Filter_Map *get_filter_map(Lview *lview);
extern Filter_Map *generate_filter_map(Lview *lview);

extern Mailbox *find_mailbox_from_mailstream(MAILSTREAM *ms);
extern View *new_view(void);
extern Lview *new_lview(void);
extern Filter *new_filter(void);
extern Message_List *new_message_list(void);
extern Message *new_message(void);
extern Mailbox *new_mailbox(void);
extern Dir_Struct *new_dir_struct(void);
extern Address_Book_Info *new_address_book_info(void);
extern Read_Info *new_read_info(void);
extern Read *new_read(void);
extern Edit *new_edit(void);
extern Server_List *new_server_list(void);
extern Mailbox_List *new_mailbox_list(void);
extern Mime_Handler *new_mime_handler(void);
extern void free_message(Message *message);

/* ml.c */
extern void no_op();
extern void main_compose();
extern void main_open(Widget w, XtPointer cb, XtPointer xp);
extern Server_List *get_active_server_list();
extern Server_List *find_server_list();
extern void main_address_book(Widget w,XtPointer data,XtPointer xp);


/* msgfncs.c */
extern char *get_header_field_contents(char *field, char *header);
extern char *get_formatted_header_field(char *field, char *header);
extern char *get_short_header(char *full_header);
extern char *get_short_forward_line(char *header, int count);
extern unsigned long header_field_len(char *header_pointer);
extern char *get_reply_subject(char *header);
extern char *get_forward_subject(char *header);
extern char *get_forward_text(char *text);
extern char *generate_sequence(Lview *lview);
extern Message *get_message_from_mailbox(Mailbox *mailbox,unsigned long msgno);

/* parse.c */
extern ACTIONREC *find_action(char *s);
extern HEADERREC *get_hdrlist(char *s);
extern char **get_actions(char *s);
extern char *clean_and_parse_action(char *s);



/* pgp.c */
extern char *make_kv_window(Widget w);

/* preferences.c */
extern int load_defaults(void);
extern void save_defaults(void);
extern void get_resources(Widget w);
extern void sane_defaults(void);


/* read.c */



/* system.c */
extern int get_user(void);
extern char *get_qualified_host_name(char *host);
extern Binary_Buffer *read_from_pipe(char *command);

/* textfncs.c */
extern char *GetTextField(Widget w);
extern void AppendText(Widget w, char *str);
extern void text_field_edit(Widget w, XtPointer zilch, XtPointer cb);
extern void text_nospace_edit(Widget w, XtPointer zilch, XtPointer cb);
extern void passwd_edit(Widget w, Remote_Auth *authst, XtPointer call_data);
extern char *scramble(char *str);
extern char *first_nonwhite(char *str);
extern Binary_Buffer *load_binary_file(char *filename);
extern char *wrap_text(char *str, int linelen);
extern char *lftocrlf(char *src);
extern void remove_trailing_white(char *str);
extern char *input_string(Widget w, char *title, 
			  char *default_string, char *helpfile);
extern void wipeout(char *str);
extern char *stripcr(char *str);
extern char *striplf(char *str);



/* view.c */
extern Lview *get_all_lview(MAILSTREAM *mailstream);
extern Boolean has_new_messages(Lview *lview, Boolean wipe);
extern void create_lview(Lview *lview, Boolean batch);
extern char *get_keyword(Widget w, MAILSTREAM *mailstream);

/* winfncs.c */
extern void get_pointer_position(Widget w, Position *x, Position *y);
extern Boolean is_selected(XmListCallbackStruct *ptr, unsigned long num);
extern Widget create_text_field(Widget form, Widget below, char *label_string,
				char *string, int width, 
				XtPointer fn, XtPointer data);
extern Widget create_label(Widget form, Widget below, char *str);
extern void set_watch_cursors(void);
extern void set_pirate_cursors(void);
extern void reset_cursors(void);
extern void help(Widget w, char *title, char *filename);

#else /* __STDC__ */

/* addressfncs.c */
extern ADDRESS *text_to_address();
extern ADDRESS *copy_address();


/* authenticate.c */
extern Remote_Auth *login();
extern void free_remote_auth();


/* buttons.c */
extern void create_menu_buttons();
extern void check_buttons();


/* compose.c */
extern void make_attachment_list();
extern void complete_address();
extern char *lookup_address();
extern Compose_Info *compose();

/* filefncs.c */
extern char *file_select();

/* localsearch.c */
char *update_dynamic_predicates();

/* lvfncs.c */
Message_List *do_imap_search();


/* mailboxes.c */
extern char *format_mailbox_name();
extern char *format_server_name();
extern char *get_mailbox_name();
extern char *fix_mailboxpath();
extern char *unfix_mailboxpath();



/* mime.c */
extern void parse_external();
extern Boolean get_type_from_suffix();
extern int name_to_type();
extern char *type_to_name();
extern Mime_Handler *get_handler();
extern Binary_Buffer *create_mime_compose_window();
extern char *find_param();
extern Boolean is_ftp();
extern Boolean is_extmail();
extern void get_external();
extern void fetch();

/* miscfncs.c */
extern Mailbox *find_mailbox_from_mailstream();
extern Filter_Map *new_filter_map();
extern Filter_Map *get_filter_map();
extern Filter_Map *generate_filter_map();
extern View *new_view();
extern Lview *new_lview();
extern Filter *new_filter();
extern Message_List *new_message_list();
extern Message *new_message();
extern Mailbox *new_mailbox();
extern Dir_Struct *new_dir_struct();
extern Address_Book_Info *new_address_book_info();
extern Read_Info *new_read_info();
extern Read *new_read();
extern Edit *new_edit();
extern Server_List *new_server_list();
extern Mailbox_List *new_mailbox_list();
extern Mime_Handler *new_mime_handler();
extern void free_message();


/* ml.c */
extern void no_op();
extern void main_compose();
extern void main_open();
extern Server_List *get_active_server_list();
extern Server_List *find_server_list();
extern void main_address_book();


/* msgfncs.c */
extern char *get_header_field_contents();
extern char *get_formatted_header_field();
extern char *get_short_header();
extern char *get_short_forward_line();
extern unsigned long header_field_len();
extern char *get_reply_subject();
extern char *get_forward_subject();
extern char *get_forward_text();
extern char *generate_sequence();
extern Message *get_message_from_mailbox();



/* parse.c */
extern ACTIONREC *find_action();
extern HEADERREC *get_hdrlist();
extern char **get_actions();
extern char *clean_and_parse_action();




/* pgp.c */
extern char *make_kv_window();


/* preferences.c */
extern int load_defaults();
extern void save_defaults();
extern void get_resources();
extern void sane_defaults();

/* read.c */
extern char *get_header_field_contents();

/* system.c */
extern int get_user();
extern char *get_qualified_host_name();
extern Binary_Buffer *read_from_pipe();

/* textfncs.c */
extern char *GetTextField();
extern void AppendText();
extern void text_field_edit();
extern void text_nospace_edit();
extern void passwd_edit();
extern char *scramble();
extern char *first_nonwhite();
extern Binary_Buffer *load_binary_file();
extern char *wrap_text();
extern char *lftocrlf();
extern void remove_trailing_white();
extern char *input_string();
extern void wipeout();
extern char *striplf();
extern char *stripcr();

/* view.c */
extern Lview *get_all_lview();
extern Boolean has_new_messages();
extern void create_lview();
extern char *get_keyword();

/* winfuncs.c */
extern void get_pointer_position();
extern Boolean is_selected();
extern Widget create_text_field();
extern void set_watch_cursors();
extern void set_pirate_cursors();
extern void reset_cursors();
extern Widget create_label();
extern void help();

#endif /* __STDC__ */
