/* preferences.h 
 *
 *
 * $Author: mtm $
 * $Date: 1994/11/08 01:28:23 $
 * $Id: preferences.h,v 1.1 1994/11/08 01:28:23 mtm Exp mtm $
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log: preferences.h,v $
 * Revision 1.1  1994/11/08  01:28:23  mtm
 * Initial revision
 *
 * 
 */

#ifndef __ML_PREFERENCES_H__
#define __ML_PREFERENCES_H__


typedef struct _PREFERENCES_ {

  char        *imap_server;
  char        *smtp_server;
  char        *nntp_server;
  char        *default_mailbox;
  char        *default_savebox;
  char        *default_cc;
  char        *default_bcc;
  char        *default_action;
  char        *help_directory;
  char        *mime_directory;
  char        *reply_address;
  char        *print_command;
  char        *signature_file;
  char        *pgp_username;
  char        *pgp_pathname;
  char        *folder_path;
  char        *url_command;
  int          check_interval;
  int          imap_port;
  int          read_height;
  int          compose_height;
  int          view_height;
  Boolean      imap_debug;
  Boolean      smtp_debug;
  Boolean      auto_open;
  Boolean      mime_ask;
  Boolean      developer_debug;
  Boolean      confirm_quit;
  Boolean      hide_empty;

} Preferences;

#define PREF_TYPE_INT   0
#define PREF_TYPE_STR   1
#define PREF_TYPE_BOOL  2
#define PREF_TYPE_FLOAT 3

#define PREF_CATEGORY_UNKNOWN  0
#define PREF_CATEGORY_BASIC    1
#define PREF_CATEGORY_OPTION   2
#define PREF_CATEGORY_ADVANCED 3



#endif /* __ML_PREFERENCES_H__ */


