/* pgp.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"


void pgp_accept();
void pgp_cancel();
void pgp_select();
void pgp_reset();
void pgp_help();
void stuff_pgp_list();

Pgpkv *pgpkv = NULL;


Menu pgp_address_menu[] = {
  { "Accept", "PGP_ACCEPT", 'A',
      pgp_accept, NULL, 0, NULL, NULL, BTN_ON },
  { "Cancel", "PGP_CANCEL", 'C',
      pgp_cancel, NULL, 0, NULL, NULL, BTN_ON },
  { "Reset", "PGP_RESET", 'R',
      pgp_reset, NULL, 0, NULL, NULL, BTN_ON },
  { "Help", "PGP_HELP!", 'H',
      pgp_help, NULL, 0, NULL, NULL, BTN_ON },

};


char *make_kv_window(w)
     Widget w;
{

  Arg args[ARGLISTSIZE];
  int n = 0;
  Position x, y;
  Widget form, menubar;
  XtTranslations translations;
  char *ret = NULL;
  

  set_pirate_cursors();

  pgpkv = (Pgpkv *) fs_get(sizeof(Pgpkv));


  pgpkv->result = NULL;
  pgpkv->done = 0;


  get_pointer_position(w, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  XtSetArg(args[n], XtNallowShellResize, TRUE); n ++;
  pgpkv->shell = XtCreatePopupShell("PGP Address Book",
			 transientShellWidgetClass, w,
			 args, n); n = 0;

  XmAddTabGroup(pgpkv->shell);

  form = XmCreateForm(pgpkv->shell, "form", args, n ); n = 0;

  XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form, "menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, pgp_address_menu, 
		      XtNumber(pgp_address_menu),
		      BTN_ON, pgpkv);

  pgpkv->text =
    create_text_field(form, menubar, 
		      "Name   :", NULL,40, NULL, NULL);

  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n ++;
  XtSetArg(args[n], XmNlistSizePolicy,XmVARIABLE); n ++;
  XtSetArg(args[n], XmNvisibleItemCount, 10 ); n ++; 
  XtSetArg(args[n], XmNselectionPolicy,XmSINGLE_SELECT); n ++;
  pgpkv->list = XmCreateScrolledList(form,"list",args,n); n = 0;
  XtAddCallback(pgpkv->list,	XmNsingleSelectionCallback, 
		pgp_select, pgpkv);
  XtAddCallback(pgpkv->list,	XmNdefaultActionCallback, 
		pgp_select, pgpkv);

  translations = 
    XtParseTranslationTable(GLOBAL_modal_list_translations);
  XtOverrideTranslations(pgpkv->list,translations);


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, pgpkv->text); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n ++;

  XtSetValues(XtParent(pgpkv->list), args, n); n = 0;
  XtManageChild(pgpkv->list);

  XtManageChild(form);
  XtManageChild(pgpkv->shell);

  XtPopup(pgpkv->shell,XtGrabExclusive);
  stuff_pgp_list(pgpkv);

  modal_main_loop(&pgpkv->done);

  XtPopdown(pgpkv->shell);
  XtDestroyWidget(pgpkv->shell);

  reset_cursors();
  ret = pgpkv->result;
  fs_give((void **) &pgpkv);
  return(ret);

}


/* May need to be modified if "pgp -kv" output format changes... */


#define KEY_START_COL 30
#define KEY_TRAIL_TEXT "matching key"  /* i.e. "n matching keys found" */

void stuff_pgp_list(pgpkv)
     Pgpkv *pgpkv;
{

  FILE *pp;
  char buffer[FILEBUFFLEN];
  
  XmString xstr;

  XDefineCursor(display,XtWindow(pgpkv->shell), clock_cursor);
  XFlush(display);

  (void) signal(SIGPIPE, SIG_IGN); /* Don't terminate program on failure. */

  pp = popen(PGP_KV_CMD,"r");

  if(pp == NULL) {
    (void) signal(SIGPIPE, SIG_DFL);
    XUndefineCursor(display,XtWindow(pgpkv->shell));
    XFlush(display);
    return;
  }

  /* skip two lines */

  /* First one is blank, next contains the column labels */

  fgets(buffer,sizeof(buffer),pp);
  fgets(buffer,sizeof(buffer),pp);

  while((fgets(buffer,sizeof(buffer),pp)) != NULL) {
    if(strstr(buffer,KEY_TRAIL_TEXT) != NULL) 
      break;
    if(strlen(buffer) <= KEY_START_COL)
      continue;
    buffer[strlen(buffer) - 1] = NUL_TERM; 
    xstr = XmStringCreateSimple(buffer + KEY_START_COL);
    XmListAddItemUnselected(pgpkv->list,xstr,0);
    XmStringFree(xstr);
  }
  pclose(pp);
  (void) signal(SIGPIPE, SIG_DFL);
  XUndefineCursor(display,XtWindow(pgpkv->shell));
  XFlush(display);
  return;
}



void pgp_accept(w,pgpkv,xp)
     Widget w;
     Pgpkv *pgpkv;
     XtPointer xp;
{

  pgpkv->done = 1;

}



void pgp_select(w,pgpkv,cb)
     Widget w;
     Pgpkv *pgpkv;
     XmListCallbackStruct *cb;
{

  int newsize = 0;
  char *ret;
  char *str;

  XmStringGetLtoR(cb->item,XmSTRING_DEFAULT_CHARSET,&str);

  newsize = (pgpkv->result) ? strlen(pgpkv->result) : 0;
  newsize += (strlen(str) + 8);

  ret = (char *) fs_get(newsize);

  *ret = NUL_TERM;

  if(pgpkv->result)
    strcpy(ret,pgpkv->result);

  if(strlen(ret))
    strcat(ret,SPACESTR);
  strcat(ret,"'");
  strcat(ret,str);
  strcat(ret,"'");
  if(pgpkv->result)
    fs_give((void **) &pgpkv->result);
  pgpkv->result = ret;
  fs_give((void **) &str);

  XmTextSetString(pgpkv->text,EMPTYSTR);
  AppendText(pgpkv->text,pgpkv->result);
  XmListDeselectAllItems(pgpkv->list);
}



void pgp_cancel(w,pgpkv,xp)
     Widget w;
     Pgpkv *pgpkv;
     XtPointer xp;
{
  pgp_reset(w,pgpkv,xp);
  pgpkv->done = 1;

}

void pgp_help(w,pgpkv,xp)
     Widget w;
     Pgpkv *pgpkv;
     XtPointer xp;
{

  help(pgpkv->shell,"Help - PGP Address Book","pgpuser.help");

}


void pgp_reset(w,pgpkv,xp)
     Widget w;
     Pgpkv *pgpkv;
     XtPointer xp;
{
  if(pgpkv->result)
    fs_give((void **) &pgpkv->result);

  XmTextSetString(pgpkv->text,EMPTYSTR);
}
