/*
 * definitions for parsing filter booleans 
 *   Bill Yeager   23 Mai 93 */

typedef enum {
  NO_OP = 1,
  AND_OP = 2,
  OR_OP = 3
} BOOL;

#define ACTION_SEPARATOR ';'

typedef struct boolean_list {
  char *operator;
  BOOL boole;
} BLIST;

/* expression types for leafs of our tree */
typedef enum {
  simple = 1,				/* NO parenthetial influences */
  start = 2,				/* left paren influence */
  intermediate = 3,			/* start < exp < end */
  end = 4				/* right paren influence */
} expression_type;

/* How 'NOT' binds with the leaf. 
 *   o bind atom means this "simple" expression
 *   o bind expression means this expression
 *       if expression_type is "simple" then same as bind_atom
 *       if expression_type is "start" then upto the next end leaf */
typedef enum {
  no_binding = 1,
  bind_atom = 2,
  bind_expression = 3
} NOTBINDING;

/* This defines the type of predicate in the leaf */
typedef enum {
  pred_simple = 1,
  pred_field = 2,
  pred_dynamic_field = 3
} PREDTYPE;

typedef enum {
  undefined = 1,
  local = 2,
  server = 3
} SEARCHTYPE;

/* leaves of simple parse tree:
 * paren_type = left_paren if the leaf is preceded by a left parenthesis,
 *            = right_paren if the leaf is followed by a right guy */
  
typedef struct _feuilles_ {
  char *predicate;			/* search predicate */
  BOOL  operator;			/* predeceding operator */
  expression_type  expression;	        /* simple, start, or end */
  NOTBINDING atomic_not;		/* How ~ binds with this expression */
  NOTBINDING expression_not;		/*  How binds with ~(<expression>)*/
  PREDTYPE predicate_type;		/* simple_pred or field_pred */
  SEARCHTYPE search_type;		/* local or server */
  struct _feuilles_ *next;		/* link */
} LEAF;

typedef struct _leaf_macro_ {
  char *macro_name;			/* text name of this macro */
  LEAF *leaves;				/* for macro construction */
  int  n_leaves;
} LEAFMACRO;

/* leaf states */
typedef enum {
  zero_paren = 0,
  left_paren = 1,
  right_paren = 2,
  both_paren = 3
} PARENS_TYPE;

/* search token object */

typedef struct S_token {
  char *token;				/* string itself */
  Boolean field_required;		/* followed by a field if true */
  unsigned long field_attributes;	/* attributes for field */
  PARENS_TYPE  parens;			/* dynamic - left paren before, etc */
  NOTBINDING atomic_not;		/* not stuff */
  NOTBINDING expression_not;
  unsigned long token_type;		/* see values below */
  SEARCHTYPE search_type;		/* search type passed to leaf */
} STOKEN;

typedef struct S_FIELD {
  char *field;				/* ptr to field substring */
  PARENS_TYPE parens;			/* parens type */
} SFIELD;


typedef enum {
  no_error = 0,
  parse_success = 1,
  empty_filter = 2,
  illegal_token = 3,
  missing_field = 4,
  missing_dquote = 5,
  invalid_name = 6,
  expected_boolean = 7,
  missing_predicate = 8,
  parenthesis_bad = 9,
  illegal_left_paren_field = 10,
  illegal_right_paren_token = 11,
  trop_de_texte = 12,
  illegal_right_paren_termination = 13,
  illegal_numeric_field = 14,
  brackets_bad = 15,
  unprintable_chars = 16,
  misplaced_sauvage = 17

} parse_errors;

/* field  attributes */
#define NONE    (1<<0)			/* no attributes */
#define ATOMIC  (1<<1)			/* no "" used around field */
#define LE_TEMPS (1<<2)			/* THE TIME is used */
#define NUMERIC (1<<3)			/* Must be a number */
#define APPLYSEARCH (1<<4)      /* Apply substring/wildcard searches */

/* searchees */
#define TOKEN 1
#define GEORGES_BOOLE 2

/* token types - a bit mask value is defined for each token type
 * which reflects a flag or state that the user can change
 * for a give message in the user interface. Each rule we parse will
 * pass on a composite token mask to the search filter. That way
 * not all filters will necessarily need to be searched if a state change
 * signaled by the server does not include one of the token types. */

#define TYPE_NULL      0
#define TYPE_KEYWORD   (1<<0)
#define TYPE_DELETED   (1<<1)
#define TYPE_UNDELETED (1<<2)
#define TYPE_SEEN      (1<<3)
#define TYPE_UNSEEN    (1<<4)
#define TYPE_RECENT    (1<<5)
#define TYPE_ANSWERED  (1<<6)
#define TYPE_UNANSWERED (1<<7)
#define TYPE_FLAGGED   (1<<8)
#define TYPE_UNFLAGGED (1<<9)
#define TYPE_NEW       (1<<10)
#define TYPE_OLD       (1<<11)
#define TYPE_TOUS      -1

/* other definitions */

#define PARSEBUFLEN 256
#define SAUVAGE '\03'


/* Macro definitions */
#define RECIPIENT_MACRO "RECIPIENT"
#define CORRESPONDENT_MACRO "CORRESPONDENT"
#define CONVERSANT_MACRO "CONVERSANT"
