/* localsearch.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1995 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 */

/*
 * Local search routines for xlview written by
 *
 *    Bill Yeager 
 *    SSRG/KSL
 *    Stanford University
 *
 * Modified for ML by Mike Macgirvin 1/95
 *
 */

#include "ml.h"


#define SECONDS_PER_DAY (60*60*24)

static char lan[4];
static char lheure[64];

char *mois[12]= {
  "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
  "JUL", "AUG", "SEP", "OCT", "NOV", "DEC",
};

static int dpm[]= {/*dec - dec */
  31, 30, 28, 31, 30, 31, 30, 31, 31, 31, 31, 30, 31
};

static int leap_dpm[]= {/*dec - dec */
  31, 30, 29, 31, 30, 31, 30, 31, 31, 31, 31, 30, 31
};



void
set_leading_lan()
{
  struct timeval tp;
  struct timezone tzp;
  char *date;

  gettimeofday(&tp, &tzp);
  date = ctime(&tp.tv_sec);
  lan[0] = date[20];
  lan[1] = date[21];
  lan[2] = '\0';
}

char *
set_today(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_hier(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  horloge -= SECONDS_PER_DAY;
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}


char *
set_mois_dernier(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int days_last_month;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  /* Take us to the debut of last month */
					/* THe debut of this month */
  horloge = horloge - ((temps->tm_mday - 1)* SECONDS_PER_DAY); 
  /* Our month tables begin with dec, and tm_mon is 0 - 11, ie, tm_mon + 1
   * indexes THIS MONTH in our tables, alors tm_mon indexes LAST MONTH: */
  days_last_month = ((temps->tm_year % 4) == 0) ? 
    leap_dpm[temps->tm_mon] : dpm[temps->tm_mon];
  horloge -= days_last_month * SECONDS_PER_DAY;
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_mois_courant(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int days_last_month;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  sprintf(lheure, "\" 1-%s-%s%2d\"", mois[temps->tm_mon], 
	  lan, temps->tm_year);
  return lheure;
}

char *
set_january(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  sprintf(lheure, "\" 1-JAN-%s%2d\"", lan, temps->tm_year);
  return lheure;
}

char *
set_february(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-FEB-%s%2d\"", lan, year);
  return lheure;
}

char *
set_march(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-MAR-%s%2d\"", lan, year);
  return lheure;
}

char *
set_april(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-APR-%s%2d\"", lan, year);
  return lheure;
}

char *
set_may(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-MAY-%s%2d\"", lan, year);
  return lheure;
}

char *
set_june(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-JUN-%s%2d\"", lan, year);
  return lheure;
}

char *
set_july(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-JUL-%s%2d\"", lan, year);
  return lheure;
}

char *
set_august(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-AUG-%s%2d\"", lan, year);
  return lheure;
}

char *
set_september(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;
  sprintf(lheure, "\" 1-SEP-%s%2d\"", lan, year);
  return lheure;
}

char *
set_october(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-OCT-%s%2d\"", lan, year);
  return lheure;
}

char *
set_november(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-NOV-%s%2d\"", lan, year);
  return lheure;
}

char *
set_december(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;
  int year;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  year = temps->tm_year;

  sprintf(lheure, "\" 1-DEC-%s%2d\"", lan, year);
  return lheure;
}

char *
set_sunday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= temps->tm_wday * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_monday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 1) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_tuesday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 2) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_wednesday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 3) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_thursday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 4) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_friday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 5) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}

char *
set_saturday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);
  horloge -= (temps->tm_wday - 6) * SECONDS_PER_DAY;
  temps = localtime(&horloge);

  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, mois[temps->tm_mon],
	  lan, temps->tm_year);
  return lheure;
}


char *
set_lastsunday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (7 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_lastmonday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (6 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}
char *
set_lasttuesday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (5 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_lastwednesday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (4 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_lastthursday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (3 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_lastfriday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (2 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

char *
set_lastsaturday(str)
     char *str;
{
  time_t horloge;
  struct tm *temps;
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp, &tzp);
  horloge =  (time_t)tp.tv_sec;
  temps = localtime(&horloge);

  horloge = horloge - (temps->tm_wday * SECONDS_PER_DAY)
    - (1 * SECONDS_PER_DAY); 
  temps = localtime(&horloge);
  sprintf(lheure, "\"%2d-%s-%s%2d\"", temps->tm_mday, 
	  mois[temps->tm_mon], lan, temps->tm_year);
  return lheure;
}

void conjunct_and(mailbox,list1, list2)
     Mailbox *mailbox;
     Message_List *list1;
     Message_List *list2;
{

  Message_List *ptr1;
  Message_List *ptr2;
  Boolean found_it = FALSE;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  for(ptr1 = list1; ptr1; ptr1 = ptr1->next) {
    found_it = FALSE;
    for(ptr2 = list2; ptr2; ptr2 = ptr2->next) {
      if(ptr1->message == ptr2->message) {
	found_it = TRUE;
	break;
      }
    }
    if(found_it == TRUE)
      mm_searched(mailbox->mailstream,ptr1->message->msgno);
  }
}

Message *find_next_from_two_lists(ptr1,ptr2)
     Message_List **ptr1;
     Message_List **ptr2;
{
  Message *message = NULL;

  if(((*ptr1) == NULL) && ((*ptr2) == NULL))
    return(NULL);

  if((*ptr1) == NULL) {
    message = (*ptr2)->message;
    *ptr2 = (*ptr2)->next;
    return(message);
  }
  if((*ptr2) == NULL) {
    message = (*ptr1)->message;
    *ptr1 = (*ptr1)->next;
    return(message);
  }
  if( (*ptr1)->message->msgno < (*ptr2)->message->msgno ) {
    message = (*ptr1)->message;
    *ptr1 = (*ptr1)->next;
    return(message);
  }
  else {
    if( (*ptr1)->message->msgno > (*ptr2)->message->msgno ) {
      message = (*ptr2)->message;
      *ptr2 = (*ptr2)->next;
      return(message);
    }
    else {  /* equal. We only want one. Update both pointers. */
      message = (*ptr1)->message;
      *ptr1 = (*ptr1)->next;
      *ptr2 = (*ptr2)->next;
      return(message);
    }
      
  }

  /* shouldn't get here */

}



void conjunct_or(mailbox,list1, list2)
     Mailbox *mailbox;
     Message_List *list1;
     Message_List *list2;
{

  Message_List *ptr1 = list1;
  Message_List *ptr2 = list2;
  Message *message;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  while((message = find_next_from_two_lists(&ptr1,&ptr2)) != NULL)
    mm_searched(mailbox->mailstream,message->msgno);

}


void negate_search(mailbox,list1,list2)
     Mailbox *mailbox;
     Message_List *list1;
     Message_List *list2;
{
  Message_List *ptr;
  Message_List *message_list;
  Boolean found_it = FALSE;

  for(message_list = list2;
      message_list; message_list = message_list->next) {
    found_it = FALSE;
    for(ptr = list1; ptr; ptr = ptr->next) {
      if(ptr->message == message_list->message) {
	found_it = TRUE;
	break;
      }
    }
    if(found_it == FALSE)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
  }
  free_message_list(list1,TRUE,FALSE);
}


/*
 * Each of the functions below return TRUE unless the search should
 * be defaulted to the server. 
 */

Boolean
local_new_search(mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;
  
  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if((! elt->seen) && elt->recent) 
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return(TRUE);
}

/*
 * Do a search on the mailbox cache for deleted messages 
 */

Boolean
local_deleted_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{

  Message_List *message_list;

  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(elt->deleted)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return TRUE;
}

Boolean
local_undeleted_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(! elt->deleted)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return TRUE;
}

Boolean
local_flagged_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE);
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(elt->flagged)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_unflagged_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(! elt->flagged)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return TRUE;
}

Boolean
local_seen_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE);
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(elt->seen)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_unseen_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(! elt->seen)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}


Boolean
local_answered_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(elt->answered)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_unanswered_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(! elt->answered)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}


Boolean
local_recent_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(elt->recent)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_old_search (mailbox,lview)
     Mailbox *mailbox;
     Lview *lview;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if(! elt->recent)
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}


/*
 * Here we have the text searches:
 *    SUBJECT
 *    FROM
 *    TEXT
 *    BODY
 *    HEADER
 *    TO
 *    CC
 *    REPLY-TO
 *    SENDER
 *    MESSAGE-ID
 *    IN-REPLY-TO
 *    REPLY-TO
 *    return-path
 *    remail
 *    > n     if rfc822_size > n, then true ...
 */

Boolean
local_subject_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char *subject;
  int len;
  Boolean result;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if((message_list->message) && (message_list->message->envelope)) {
      subject = message_list->message->envelope->subject;
      if(subject) {
	len = strlen(subject);
	if((len) && (search(subject, len, pattern, strlen(pattern))))
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
      }
    }
  }

  return TRUE;
}


Boolean
local_body_search(mailbox,lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  return(FALSE);

/*  
 * free_message_list(mailbox->found, TRUE, FALSE); mailbox->found = NULL;

 * if(! lview)
 *   return(FALSE);
 *
 * for(message_list = lview->message_list;
 *     message_list; message_list = message_list->next) {
 *   if(message_list->message && message_list->message->longcache) {
 *     elt = &(message_list->message->longcache->elt);
 *     if(! elt || !elt->data2)
 *	return(FALSE);
 *     if(search(elt->data2,strlen(elt->data2),pattern,strlen(pattern)))
 *	mm_searched(mailbox->mailstream, message_list->message->msgno);
 *   }
 * }
 *
 * return(TRUE);
 */
}

Boolean
local_header_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  return(FALSE);

/*  
 * free_message_list(mailbox->found, TRUE, FALSE); mailbox->found = NULL;

 * if(! lview)
 *   return(FALSE);
 *
 * for(message_list = lview->message_list;
 *     message_list; message_list = message_list->next) {
 *   if(message_list->message && message_list->message->longcache) {
 *     elt = &(message_list->message->longcache->elt);
 *     if((! elt) || (! elt->data1))
 *	continue;
 *     if(search(elt->data1, strlen(elt->data1), pattern, strlen(pattern)))
 *	mm_searched(mailbox->mailstream, message_list->message->msgno);
 *   }
 * }
 * return (TRUE);
 */
}

Boolean
local_text_search(mailbox,lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  MESSAGECACHE *elt;

  return(FALSE);

/*  
 * free_message_list(mailbox->found, TRUE, FALSE); mailbox->found = NULL;

 * if(! lview)
 *   return(FALSE);
 *
 * for(message_list = lview->message_list;
 *     message_list; message_list = message_list->next) {
 *   if(message_list->message && message_list->message->longcache) {
 *     elt = &(message_list->message->longcache->elt);
 *     if((elt) && (elt->data1) && (elt->data2))
 *	if((search(elt->data1,strlen(elt->data1),pattern,strlen(pattern)))
 *	   || (search(elt->data2,strlen(elt->data2),pattern,strlen(pattern))))
 *	  mm_searched(mailbox->mailstream, message_list->message->msgno);
 *   }
 * }
 *
 * return(TRUE);
 */
}

Boolean
local_msgid_search(mailbox,lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char *msgid;


  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if((message_list->message) && (message_list->message->envelope)) {
      msgid = message_list->message->envelope->message_id;
      if((msgid) && (strlen(msgid)) 
	 && search(msgid,strlen(msgid),pattern,strlen(pattern)))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

/* NOT yet implemented in parser cause remail info is not present
 * en the envelope */

Boolean
local_remail_search(mailbox,lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char *remail;

  
  free_message_list(mailbox->found, TRUE, FALSE);
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      remail = message_list->message->envelope->remail;
      if((remail) && (strlen(remail)) 
	 && (search(remail,strlen(remail),pattern,strlen(pattern))))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return(TRUE);
}

Boolean
local_size_plus_grand_que(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  MESSAGECACHE *elt;
  unsigned long size = (unsigned long) atol(pattern);

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if((elt) && (elt->rfc822_size > size))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return TRUE;
}

Boolean
local_inreplyto_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char *in_reply_to;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      in_reply_to = message_list->message->envelope->in_reply_to;
      if((in_reply_to) && (strlen(in_reply_to))
	 && search(in_reply_to,strlen(in_reply_to), pattern,strlen(pattern)))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }
  return TRUE;
}

/*
 * Date searches ON SINCE BEFORE */

Boolean
local_on_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  unsigned long date, msg_date;
  MESSAGECACHE *elt;
  MESSAGECACHE tmp_elt;

  if (!mail_parse_date (&tmp_elt, pattern))
    return(FALSE);

  date = (tmp_elt.year << 9) + (tmp_elt.month << 5) + tmp_elt.day;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      msg_date = (elt->year << 9) + (elt->month << 5) + elt->day;
      if (msg_date == date) 		/* message on the date */
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_since_search(mailbox,lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  unsigned long date, msg_date;
  MESSAGECACHE *elt;
  MESSAGECACHE tmp_elt;

  if (!mail_parse_date (&tmp_elt, pattern))
    return(TRUE);

  date = (tmp_elt.year << 9) + (tmp_elt.month << 5) + tmp_elt.day;

  
  free_message_list(mailbox->found, TRUE, FALSE);
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      msg_date = (elt->year << 9) + (elt->month << 5) + elt->day;
      if (msg_date >= date) 
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_before_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{

  Message_List *message_list;
  unsigned long date, msg_date;
  MESSAGECACHE *elt;
  MESSAGECACHE tmp_elt;

  if (!mail_parse_date (&tmp_elt, pattern))
    return(TRUE);

  date = (tmp_elt.year << 9) + (tmp_elt.month << 5) + tmp_elt.day;

  
  free_message_list(mailbox->found, TRUE, FALSE); mailbox->found = NULL;
  lview = get_all_lview(mailbox->mailstream);
  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      msg_date = (elt->year << 9) + (elt->month << 5) + elt->day;
      if (msg_date < date) 
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return TRUE;
}

Boolean
local_keyword_search(mailbox, lview,  pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  MESSAGECACHE *elt;
  char **user_flags = mailbox->mailstream->user_flags;
  int i;
  long keyword = 0;
  char *key;

  if (user_flags[0] == NULL)
    return TRUE;			/* No user flags */

  for (i = 0; i < NUSERFLAGS && (key = user_flags[i]); ++i) {
    if (strcasecmp(pattern, key) == STRMATCH) {
      keyword = 1 << i;
      break;
    }
  }
  if (!keyword)
    return TRUE;			/* keyword not in list */


  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->longcache) {
      elt = &(message_list->message->longcache->elt);
      if((elt) && (elt->user_flags & keyword))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return(TRUE);
}

Boolean
local_from_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->from;
      local_make_addr_str(base,addr);
      len = strlen(addr);
      if((len) && (search(addr,len,pattern,strlen(pattern))))
	mm_searched(mailbox->mailstream, message_list->message->msgno);
    }
  }

  return(TRUE);
}

Boolean
local_to_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->to;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
  
}


Boolean
local_cc_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE);
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->cc;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
}


Boolean
local_reply_to_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->reply_to;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
}

Boolean
local_sender_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->sender;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
}


Boolean
local_replyto_search(mailbox, lview,  pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->reply_to;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
}



Boolean
local_returnpath_search(mailbox, lview, pattern)
     Mailbox *mailbox;
     Lview *lview;
     char *pattern;
{
  Message_List *message_list;
  char addr[FILEBUFFLEN];
  ADDRESS *base;
  int len;

  
  free_message_list(mailbox->found, TRUE, FALSE); 
  mailbox->found = NULL;

  if(! lview)
    return(TRUE);

  for(message_list = lview->message_list;
      message_list; message_list = message_list->next) {
    if(message_list->message && message_list->message->envelope) {
      base = message_list->message->envelope->return_path;
      while(base) {
	local_make_addr_str(base,addr);
	len = strlen(addr);
	if((len) && (search(addr,len,pattern,strlen(pattern)))) {
	  mm_searched(mailbox->mailstream, message_list->message->msgno);
	  break;
	}
	else
	  base = base->next;
      }
    }
  }

  return(TRUE);
}




/*
 * IF the predicate type requires a dynamic field, ie, one whose
 * value is set at search time, then set its value. We remake the
 * predicate/field pair, and return it to be used in search */

typedef struct _dynanisme_ {
  char *value;				/* dynamic predicate name */
  char *(*set_dynamic)();		/* creates real predicate */
} DYNAMIC;

DYNAMIC d_group[]= {
  "\"TODAY\"",
  set_today,

  "\"YESTERDAY\"",
  set_hier,

  "\"LASTMONTH\"",
  set_mois_dernier,

  "\"THISMONTH\"",
  set_mois_courant,

  "\"JANUARY\"",
  set_january,

  "\"FEBRUARY\"",
  set_february,

  "\"MARCH\"",
  set_march,

  "\"APRIL\"",
  set_april,

  "\"MAY\"",
  set_may,

  "\"JUNE\"",
  set_june,

  "\"JULY\"",
  set_july,

  "\"AUGUST\"",
  set_august,

  "\"SEPTEMBER\"",
  set_september,

  "\"OCTOBER\"",
  set_october,

  "\"NOVEMBER\"",
  set_november,

  "\"DECEMBER\"",
  set_december,

  "\"SUNDAY\"",
  set_sunday,

  "\"MONDAY\"",
  set_monday,

  "\"TUESDAY\"",
  set_tuesday,

  "\"WEDNESDAY\"",
  set_wednesday,

  "\"THURSDAY\"",
  set_thursday,

  "\"FRIDAY\"",
  set_friday,

  "\"SATURDAY\"",
  set_saturday,

  "\"LASTSUNDAY\"",
  set_lastsunday,

  "\"LASTMONDAY\"",
  set_lastmonday,

  "\"LASTTUESDAY\"",
  set_lasttuesday,

  "\"LASTWEDNESDAY\"",
  set_lastwednesday,

  "\"LASTTHURSDAY\"",
  set_lastthursday,

  "\"LASTFRIDAY\"",
  set_lastfriday,

  "\"LASTSATURDAY\"",
  set_lastsaturday,

  NULL,
  NULL,
};

typedef struct _chercheurs_ {
  char *token;
  Boolean (*chercheur)();
} SEARCHERS;

/*
 * local search dispatching done here */

SEARCHERS local_chercheurs_simple[]= {
  "NEW",
  local_new_search,
  
  "OLD", 
  local_old_search, 

  "DELETED",
  local_deleted_search,

  "UNDELETED", 
  local_undeleted_search,
  
  "SEEN", 
  local_seen_search,

  "UNSEEN", 
  local_unseen_search,

  "RECENT", 
  local_recent_search,

  "ANSWERED", 
  local_answered_search,

  "UNANSWERED",
  local_unanswered_search,

  "FLAGGED", 
  local_flagged_search,

  "UNFLAGGED", 
  local_unflagged_search,
    
  NULL, NULL,
};

/* These require a search pattern */

SEARCHERS local_chercheurs_grands[] = {
  "SUBJECT",
  local_subject_search,

  "FROM",
  local_from_search,

  "TO",
  local_to_search,

  "CC",
  local_cc_search,

  "ON",
  local_on_search,

  "SINCE",
  local_since_search,

  "BEFORE",
  local_before_search,

  "KEYWORD",
  local_keyword_search,

  "MESSAGE-ID",
  local_msgid_search,

  "SENDER",
  local_sender_search,

  "IN-REPLY-TO",
  local_inreplyto_search,

  "RETURN-PATH",
  local_returnpath_search,

  ">",
  local_size_plus_grand_que,

  "HEADER",
  local_header_search,

  "TEXT",
  local_text_search,

  "BODY",
  local_body_search,

  NULL, NULL,
};


char *update_dynamic_predicates(leaf)
     LEAF *leaf;
{
  char tmp[FILEBUFFLEN];
  char *field;
  char *dynamic_value;
  DYNAMIC *dyn;
  int len;
  char *nouveau;

  if (leaf->predicate_type != pred_dynamic_field)
    return NULL;

  /* Isolate the field */

  field = strchr(leaf->predicate,(int) SPACECHAR) + 1;
  /* dispatch on field value */
  for (dynamic_value = NULL, dyn = d_group; dyn->value; ++dyn) {
    if (strcasecmp(field, dyn->value) == STRMATCH) {
      dynamic_value = (*dyn->set_dynamic)(field);
      break;
    }
  }

  if (!dynamic_value) {
    /* Dynamic values NOT required in dynamic fields */
    return NULL;
  }

  /*
   * Remake predicate with dynamic value */

  strcpy(tmp, leaf->predicate);
  strtok(tmp, " ");			/* NULL terminate predicate */
  len = strlen(tmp) + strlen(dynamic_value) + 2; /* SPACE and NULL too */
  nouveau = (char *)fs_get(len);
  sprintf(nouveau, "%s %s", tmp, dynamic_value);
  return nouveau;
}

/*
 * The dispatcher */


void
local_select_field(str, obuf)
     char *str;
     char *obuf;
{
  char *fin;

   /* clear any leading SPACES */
   while (*str == ' ') ++str;
 
   /* Now a possibly leading \" */
   if (*str && *str == '\"') ++str;
 
   /* copy the rest into out output buffer */

  strcpy(obuf, str);
  /* now step on the last " */
  if(obuf[strlen(obuf) - 1] == '\"')
    obuf[strlen(obuf) - 1] = NUL_TERM;

}



Boolean 
local_search(mailbox, lview,  predicate)
     Mailbox *mailbox;
     Lview *lview;
     char *predicate;
{
  char token[PARSEBUFLEN];
  char field[PARSEBUFLEN];

  char *chemise= token;
  SEARCHERS *chs;
  SEARCHERS *gchs;

  /* strip off the chemise */
  while (*predicate && *predicate != ' ')
    *chemise++ = *predicate++;
  *chemise = '\0';
  
  /* OK, find the local chercheur */
  for (chs = local_chercheurs_simple; chs->token; ++chs) {
    if (strcasecmp(chs->token, token) == STRMATCH) {
      return (*chs->chercheur)(mailbox, lview);
    }
  }
  for (gchs = local_chercheurs_grands; gchs->token; ++gchs) {
    if (strcasecmp(gchs->token, token) == STRMATCH) {

      local_select_field(predicate, field);
      return (*gchs->chercheur)(mailbox, lview, field);
    }
  }
  return FALSE;
}
