/* imapfncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"

/* globals defined here */

char last_notify_string[FILEBUFFLEN];
MAILSTREAM *last_notify_stream;



void mm_mailbox(name)
     char *name;
{

  Mailbox_List *mailbox_list = new_mailbox_list();
  Server_List *server_list = get_active_server_list();
  if(! server_list) {
    fs_give((void **) &mailbox_list);
    return;
  }

  mailbox_list->name = cpystr(name);
  mailbox_list->prev = server_list->mailbox_list;
  server_list->mailbox_list = mailbox_list;


}

void mm_bboard(name)
     char *name;
{
  Mailbox_List *mailbox_list = new_mailbox_list();
  Server_List *server_list = get_active_server_list();
  if(! server_list) {
    fs_give((void **) &mailbox_list);
    return;
  }

  mailbox_list->name = cpystr(name);
  mailbox_list->prev = server_list->mailbox_list;
  server_list->mailbox_list = mailbox_list;



}



void mm_searched( stream, msgno )
     MAILSTREAM *stream;
     int msgno;
{
  Mailbox *mailbox;
  Message_List *message_list;
  Message_List *prev = NULL;
  Message *message;

  mailbox = find_mailbox_from_mailstream(stream);
  if(mailbox == NULL)
    return;

  message = get_message_from_mailbox(mailbox,msgno);
  if(message) {
    message_list = new_message_list();
    message_list->message = message;
    if(mailbox->found) {
      for(prev = mailbox->found; prev->next; prev = prev->next)
	;
    }
    if(! prev) {
      mailbox->found = message_list;
      message_list->prev = NULL;
    }
    else {
      prev->next = message_list;
      message_list->prev = prev;
    }
  }
}


void mm_exists( stream, number )
     MAILSTREAM *stream;
     int number;
{

  Mailbox *mailbox;

  char buffer[FILEBUFFLEN];

  int delta;

  mailbox = find_mailbox_from_mailstream(stream);
  if(! mailbox)
    return;

  if(mailbox->nmsgs < number) {
    delta = number - mailbox->nmsgs;
    sprintf(buffer,"%d New Message%s.",delta, (delta == 1) ? "" : "s" );
    mm_log(buffer,NIL);
    mailbox->has_new_mail = TRUE;
  }

  mailbox->nmsgs = number;

}


void mm_expunged( stream, msgno )
     MAILSTREAM *stream;
     int msgno;
{
  Mailbox *mailbox;
  char buffer[FILEBUFFLEN];

  mailbox = find_mailbox_from_mailstream(stream);
  if(! mailbox)
    return;

  mailbox->nmsgs --;

  view_expunge(stream,msgno);
  read_expunge(stream,msgno);
  compose_expunge(stream,msgno);

}



void mm_notify( stream, string, errorflag )
     MAILSTREAM *stream;
     char *string;
     short errorflag;
{

  if(string == NULL)
    return;

  /* 
   * Save the results in case we need to refer to 
   * them from the program, like "[TRYCREATE]" 
   */

  strcpy(last_notify_string, string );
  last_notify_stream = stream;

  /* 
   * Ignore parse errors. They only confuse the user, thinking it's
   * a major error, and it's almost always because the sender had 
   * fat fingers on a Cc: address.. We'll show it for those who like
   * to read lots of useless information. 
   */

  if((strstr(string,"[PARSE]")) && (! preferences.developer_debug))
    return;

  mm_log(string,errorflag);
  return;
}


void mm_log( string, errorflag )
     char *string;
     short errorflag;
{
  time_t t;
  struct tm *local_time;
  char t_buf[CURRTIMESIZE];


  if(string == NULL)
    string = "<NULL>";


  if(strncasecmp(string, CHECKMSG, strlen(CHECKMSG)) == 0) 
    return;






  t = time(0);
  local_time = localtime(&t);
  if(local_time) {
    strftime(t_buf,sizeof(t_buf),LOGTIME_FMT,local_time);
    AppendText(status, t_buf);
  }

  switch(errorflag) {
  case NIL:
  case BYE:
    break;
  case MLNOTIFY:
    XBell(display,1000);
    XRaiseWindow(display,XtWindow(top));
    break;
  case WARN:
    XBell(display,1000);
    XRaiseWindow(display,XtWindow(top));
    AppendText(status, "Warning: ");
    break;
  case ERROR:
  default:
    XBell(display,1000);
    XRaiseWindow(display,XtWindow(top));
    AppendText(status, "ERROR: ");
    break;
  }

  AppendText(status, string);
  if(string[strlen(string) - 1] != LFCHAR)
    AppendText(status, LFSTR);
  XFlush(XtDisplay(status));
  return;
}


void mm_dlog( string )
     char *string;
{

  AppendText(status, ">> ");
  AppendText(status, string );
  AppendText(status, LFSTR );

}


void mm_login ( host, username, password, trial )
     char *host;
     char *username;
     char *password;
     short trial;
{

  Remote_Auth *authst = NULL, *authtmp = NULL;
  char *tmp = NULL;

  /*
   * First check to see if we can re-use previous credentials.
   * If we have stashed auth credentials and we're being asked a
   * second time for authentication, the stashed ones aren't any good. 
   * Unfortunately, there's no way to dump the cache from the program,
   * in case somebody wants to login to a previously opened server under
   * a different account. Sorry. that's the way it is. They'll have to
   * run a second instance of the program.
   */

  if(trial > 0) { /* dump old credentials */
    authtmp = session.authorizations;
    if(authtmp) {
      session.authorizations = authtmp->next;
      free_Remote_Auth(authtmp);
    }
  }
  else {   /* reuse the last valid credentials, if possible */
    for(authtmp = session.authorizations; authtmp; authtmp = authtmp->next) {
      if(((strcmp(host, authtmp->hostname)) == STRMATCH) &&
	 ((strcmp(authtmp->authtype,"IMAP")) == STRMATCH)) {
	strcpy(username,(authtmp->username) ? authtmp->username : EMPTYSTR );
	if((tmp = scramble(authtmp->password)) != NULL) {
	  strcpy(password,tmp);
	  wipeout(tmp);
	  fs_give((void **) &tmp);
	}
	return;
      }
    }
  }
	
  /* no stashed credentials, fresh authentication */

  authst = login(top, host, "IMAP", local_auth.username, NULL );
  
  if(authst) {
    strcpy(username,(authst->username) ? authst->username : EMPTYSTR );
    if((tmp = scramble(authst->password)) != NULL) {
      strcpy(password,tmp);
      wipeout(tmp);
      fs_give((void **) &tmp);
    }

    /* save for re-use */
    if((*username != NUL_TERM) && (*password != NUL_TERM)) {
      authst->next = session.authorizations;
      session.authorizations = authst;
    }
  }
  return;
}



void mm_critical( stream )
     MAILSTREAM *stream;
{
  return;
}

void mm_nocritical( stream )
     MAILSTREAM *stream;
{
  return;
}


void mm_fatal( string )
     char *string;
{

  /* We're going to crash... */

  mm_log(string,ERROR);
  return;

}



long mm_diskerror( stream, errcode, serious )
     MAILSTREAM *stream;
     int         errcode;
     int         serious;
{
    return(0);
}

void mm_flags ( stream, msgno )
     MAILSTREAM *stream;
     int msgno;
{
  update_view_line_stream_msgno(stream,msgno);
}


