/* authenticate.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */

#include "ml.h"


void login_done();
void login_abort();
void login_help();
void passwd_edit();

Menu login_menu[] = {
  { "Accept", "ACCEPT", 'A', login_done, NULL, 0, NULL, NULL, 0 },
  { "Cancel", "CANCEL", 'C', login_abort, NULL, 0, NULL, NULL, 0 },
  { "Help",   "HELP!",  'H', login_help, NULL, 0, NULL, NULL, 0 },
};



#ifdef __STDC__
Remote_Auth * login(Widget w, char *where, char *type, 
		    char *defuser, char *defpass)
#else
Remote_Auth * login(w,where, type, defuser, defpass)
     Widget w;
     char *where;
     char *type;
     char *defuser;
     char *defpass;
#endif
{
  Arg args[ARGLISTSIZE];
  char buff[FILEBUFFLEN];
  Position x, y;
  XtTranslations translations;
  int n = 0;
  int i;
  Widget form, menubar, label1, label2, label3;
  Remote_Auth *authst;
  
  authst = (Remote_Auth *) fs_get(sizeof(Remote_Auth));
  authst->done = 0;
  authst->hostname = cpystr((where) ? where : UNKNOWNSTR);
  authst->workspace = (char *) fs_get(FILEBUFFLEN + 1);
  authst->workspace[0] = '\0';
  authst->authtype = cpystr((type) ? type : EMPTYSTR );

  XtSetArg(args[n], XmNallowShellResize, TRUE); n ++;

  get_pointer_position(w, &x, &y);

  XtSetArg(args[n], XtNx, x); n ++;
  XtSetArg(args[n], XtNy, y); n ++;

  authst->shell = XtCreatePopupShell("Authenticate",
				     transientShellWidgetClass, w,
				     args, n);
  n = 0;


  XmAddTabGroup(authst->shell);

  form = XmCreateForm(authst->shell, "form", args, n); n = 0;
  
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  menubar = XmCreateMenuBar(form,"menubar", args, n); n = 0;
  XtManageChild(menubar);

  create_menu_buttons(NULL, menubar, 
		      login_menu, XtNumber(login_menu),0, authst);

  
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, menubar); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNborderWidth, 0); n ++;
  sprintf(buff,AUTHLABELSTR,(where) ? where : UNKNOWNSTR);
  label1 = XmCreateLabel(form,buff,args,n); n = 0;
  XtManageChild(label1);

  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, label1); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;

  XtSetArg(args[n], XmNborderWidth, 0); n ++;

  label2 = XmCreateLabel(form,USERNAMESTR, args, n); n = 0;
  XtManageChild(label2);

  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, label1); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNleftWidget,label2); n ++;
  XtSetArg(args[n], XmNcolumns, AUTHSTR_WIDTH); n ++;
  
  authst->name = XmCreateTextField(form,"name", args, n); n = 0;
  XtManageChild(authst->name);
  if(defuser)
    AppendText(authst->name,defuser);

  translations = XtParseTranslationTable(GLOBAL_text_field_translations);
  XtOverrideTranslations(authst->name,translations);
  translations = 
    XtParseTranslationTable(GLOBAL_nonterminal_text_field_translations);
  XtOverrideTranslations(authst->name,translations);


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, authst->name); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n ++;
  
  XtSetArg(args[n], XmNborderWidth, 0); n ++;


  label3 = XmCreateLabel(form,PASSWORDSTR, args, n); n = 0;
  XtManageChild(label3);


  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNtopWidget, authst->name); n ++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n ++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n ++;
  XtSetArg(args[n], XmNleftWidget,label3); n ++;
  XtSetArg(args[n], XmNcolumns, AUTHSTR_WIDTH); n ++;

  authst->pass = XmCreateTextField(form,"pass", args, n); n = 0;
  XtManageChild(authst->pass);
  if(defpass) {
    strcpy(authst->workspace,defpass);
    for(i = 0; i < strlen(authst->workspace); i ++)
      AppendText(authst->pass,PASSWD_STR);
  }

  XtAddCallback(authst->pass, XmNactivateCallback, 
		(XtCallbackProc) login_done, authst);

  XtAddCallback(authst->pass, XmNmodifyVerifyCallback, 
		(XtCallbackProc) passwd_edit, authst);


  translations = XtParseTranslationTable(GLOBAL_text_field_translations);
  XtOverrideTranslations(authst->pass,translations);
  translations = 
    XtParseTranslationTable(GLOBAL_terminal_text_field_translations);
  XtOverrideTranslations(authst->pass,translations);

  XtManageChild(form);
  XtPopup(authst->shell,XtGrabExclusive); 
  set_pirate_cursors();

  modal_main_loop(&authst->done);

  XtPopdown(authst->shell);
  XtDestroyWidget(authst->shell);

  XFlush(XtDisplay(top));
  reset_cursors();
  return(authst);
}

void login_done(w,authst,e)
     Widget w;
     Remote_Auth *authst;
     XEvent *e;
{
  authst->username = XmTextGetString(authst->name);
  authst->password = scramble(authst->workspace);
  wipeout(authst->workspace);
  fs_give((void **) &authst->workspace);
  authst->done = 1;
}


void login_abort(w, authst,e)
     Widget w;
     Remote_Auth *authst;
     XEvent *e;
{
  authst->username = NULL;
  authst->password = NULL;
  wipeout(authst->workspace);
  fs_give((void **) &authst->workspace);
  authst->done = 1;
}


void login_help(w,authst,e)
     Widget w;
     Remote_Auth *authst;
     XEvent *e;
{

  help(authst->shell,"Help - Authentication","authenticate.help");

}

void free_Remote_Auth(authst)
     Remote_Auth *authst;
{
  if(authst) {
    if(authst->password) {
      wipeout(authst->password);
      fs_give((void **) &authst->password);
    }
    if(authst->username)
      fs_give((void **) &authst->username);
    if(authst->hostname)
      fs_give((void **) &authst->hostname);
    if(authst->authtype)
      fs_give((void **) &authst->authtype);
    
    fs_give((void **) &authst);
  }
}


