/* addressfncs.c
 *
 *
 * $Author$
 * $Date$
 * $Id$
 *
 * Mike Macgirvin <Mike_Macgirvin@CAMIS.Stanford.EDU>
 *
 * Copyright 1994 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL 
 * WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR 
 * UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 */

/*
 * $Log$
 * 
 */


#include "ml.h"






#ifdef __STDC__
ADDRESS *text_to_address(char *text,char *host)
#else
ADDRESS *text_to_address(text,host)
     char *text;
     char *host;
#endif
{
  ADDRESS *address = NULL;

  if(host == NULL)
    host = EMPTYSTR;

  if((text != NULL) && (*text != NUL_TERM))
    rfc822_parse_adrlist(&address,text,host);
  return(address);

}

#ifdef __STDC__
ADDRESS *copy_address(ADDRESS *src_address)
#else
ADDRESS *copy_address(src_address)
     ADDRESS *src_address;
#endif
{
  ADDRESS *new_address = (ADDRESS*) NULL;
  
  new_address = mail_newaddr();
  
  if (new_address != NULL ) {
    
    new_address->personal   = 
      ((src_address->personal) ? cpystr(src_address->personal) : NULL);
    new_address->adl        = 
      ((src_address->adl) ? cpystr(src_address->adl) : NULL);
    new_address->mailbox    = 
      ((src_address->mailbox) ? cpystr(src_address->mailbox) : NULL);
    new_address->host       = 
      ((src_address->host) ? cpystr(src_address->host) : NULL );
    new_address->error      = 
      ((src_address->error) ? cpystr(src_address->error) : NULL);
    
    if (src_address->next)
      new_address->next = copy_address( src_address->next );
  }
  
  return(new_address);
}



void local_make_addr_str(adr, obuf)
     ADDRESS *adr;
     char *obuf;
{
  if (!adr->host || !adr->mailbox) {
    sprintf(obuf, " ");
    return;
  }
  if (adr->personal)
    sprintf(obuf, "\"%s\" <%s@%s>", adr->personal, adr->mailbox, adr->host);
  else
    sprintf(obuf, "%s@%s", adr->mailbox, adr->host);
}
