/*
 * Program:	AIX server login
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	1 August 1988
 * Last Edited:	23 February 1995
 *
 * Copyright 1995 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made available
 * "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/* This code is identical to the code in log_std.c, with one major exception.

   Some brain-dead idiot at IBM mucked with getpwnam() so that it accepts
   the upper case form of the user name.  But!!!  It returns the user's
   argument in the pw_uid field of the returned structure, instead of the
   actual user name from the /etc/passwd file.  So much for being able to
   figure out the name of the /usr/spool/mail file.

   What's worse, if there are upper case characters in the user's argument,
   it randomly (but seemingly load-dependent) returns some other directory
   in pw_dir instead of the user's home directory.

   The workaround in this case is to force the user's argument to lower
   case before it ever gets to getpwnam().  Of course, this makes it
   impossible to have mixed-case user names on AIX, the way you can on just
   about every modern version of UNIX.  Sorry, you don't have UNIX.  You
   have AIX.

   This crap is what anyone who has had experience with IBM has come to
   expect.  For the past 40 years, IBM has reliably stood for egregious
   cretinism in software design, foisted upon the computing industry by
   their undeserved monopoly position.  IBM proudly holds up the banner of
   needless complexity, fragile software, obtuse documentation, and
   perversion of the English language into jargon-saturated gibberish.

   Why anyone, after all these years, would continue to buy IBM products
   bewilders me.  Managers continue to buy IBM garbage, and programmers
   waste incredible amounts of their life trying to make it work.  And
   nothing ever really does work on IBM.  At best, it hangs on with a
   shoestring and a prayer, until the next release from IBM breaks it.

   And I haven't even gotten started on the AIX C computer; how no two AIX
   machines have the same version of the C compiler, and how most of them
   generate bad code.

   Take my advice, my friend; if you have read this far, obviously you are
   trying to track down some new AIX-induced stupidity.  You'll be a lot
   happer if you trash the AIX machines (RS/6000s make great boat anchors)
   and buy your systems from a real vendor that understands Unix.

   And if you are so unfortunate as to *work* for IBM, and wise enough to
   recognize the truth in what I've written above, don't waste your life
   trying to fix things inside IBM.  There have been many before you who
   have tried and failed.  The IBM corporate culture will crush you.  But
   don't worry; there are plenty of good employers who'll hire ex-IBMers
   who have seen the light.
 */
 
/* Server log in
 * Accepts: user name string
 *	    password string
 *	    optional place to return home directory
 * Returns: T if password validated, NIL otherwise
 */

long server_login (char *user,char *pass,char **home,int argc,char *argv[])
{
  char tmp[MAILTMPLEN];
				/* force case-independent match */
  struct passwd *pw = getpwnam (lcase (strcpy (tmp,user)));
				/* no entry for this user or root */
  if (!(pw && pw->pw_uid)) return NIL;
				/* validate password */
  if (strcmp (pw->pw_passwd,(char *) crypt (pass,pw->pw_passwd))) return NIL;
  setgid (pw->pw_gid);		/* all OK, login in as that user */
  initgroups (user,pw->pw_gid);	/* initialize groups */
  setuid (pw->pw_uid);
				/* note home directory */
  if (home) *home = cpystr (pw->pw_dir);
  return env_init (pw->pw_name,pw->pw_dir);
}
