/*
 * tcp.h  interface to MCS's TCP routines
 */
 
#include <Dialogs.h>
#include "MacTCPCommonTypes.h"
#include "AddressXlation.h"
#include "TCPPB.h"
#include "GetMyIPAddr.h"

#ifndef TCP_BUFSIZ
#define TCP_BUFSIZ	8192
#endif /* TCP_BUFSIZ */

typedef struct tcpstream {
	StreamPtr			tcps_sptr;			/* stream pointer for MacTCP TCP PB calls */
	short				tcps_data;			/* count of packets on read queue */
	short				drefnum;			/* driver ref num, for convenience */
	Boolean				tcps_connected;		/* true if connection was made */
	Boolean				tcps_terminated;	/* true if connection no longer exists */
	unsigned char		*tcps_buffer;		/* buffer given over to system to use */
	struct tcpstream	*tcps_next;			/* next one in chain */
} tcpstream, *tcpstreamptr;

/*
 * the Unix-y struct timeval
 */
struct timeval {
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* and microseconds */
};


/*
 * function prototypes
 */
tcpstream 	*tcpopen( unsigned char * buf, long buflen );
tcp_port	tcpconnect( tcpstream *s, ip_addr addr, tcp_port port );
short		tcpclose( tcpstream *s );
long		tcpread(  tcpstream *s, byte timeout, unsigned char * rbuf,
				unsigned short rbuflen, DialogPtr dlp );
short		tcpwrite( tcpstream *s, unsigned char * wbuf, unsigned short wbuflen );
short		tcpselect( tcpstream *s, struct timeval * timeout );

short		gethostinfobyname( char * host, struct hostInfo * );
short		gethostinfobyaddr( ip_addr addr, struct hostInfo * );
