/*
 *  Copyright (c) 1990 Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  unbind.c
 */

#ifndef lint 
static char copyright[] = "@(#) Copyright (c) 1990 Regents of the University of Michigan.\nAll rights reserved.\n";
#endif

#include "lber.h"
#include "ldap.h"
#include <stdio.h>
#include <string.h>
#ifdef MACOS
#include <stdlib.h>
#include "macos.h"
#else /* MACOS */
#ifdef DOS
#include "msdos.h"
#ifdef NCSA
#include "externs.h"
#endif /* NCSA */
#else /* DOS */
#include <sys/types.h>
#include <sys/time.h>
#endif /* DOS */
#endif /* MACOS */

#ifdef MACOS
#define tcp_close( s )		tcpclose( s )
#else /* MACOS */
#ifdef DOS
#ifdef PCNFS
#define tcp_close( s )		close( s )
#endif /* PCNFS */
#ifdef NCSA
#define tcp_close( s )		netclose( s ); netshut()
#endif /* NCSA */
#ifdef WINSOCK
#define tcp_close( s )		closesocket( s ); WSACleanup();
#endif /* WINSOCK */
#else /* DOS */
#define tcp_close( s )		close( s )
#endif /* DOS */
#endif /* MACOS */

ldap_unbind( ld )
LDAP	*ld;
{
	BerElement	*ber;
	LDAPMessage	*lm, *next;
	int		err = 0;

	Debug( LDAP_DEBUG_TRACE, "ldap_unbind\n", 0, 0, 0 );

	/* create a message to send */
	if ( (ber = ber_alloc()) == NULLBER ) {
		ld->ld_errno = LDAP_LOCAL_ERROR;
		err = -1;
	}

	/* fill it in */
	if ( !err && ber_printf( ber, "{it{n}}", ++ld->ld_msgid,
	    LDAP_REQ_UNBIND ) == -1 ) {
		ld->ld_errno = LDAP_ENCODING_ERROR;
		ber_free( ber, 1 );
		err = -1;
	}

	/* send the message */
	if ( !err && ber_flush( &ld->ld_sb, ber, 1 ) == -1 ) {
		ld->ld_errno = LDAP_SERVER_DOWN;
		ber_free( ber, 1 );
		err = -1;
	}

	/* free LDAP structure and outstanding requests/responses */
	for ( lm = ld->ld_requests; lm != NULL; lm = next ) {
		next = lm->lm_next;
		ldap_msgfree( lm );
	}

	for ( lm = ld->ld_responses; lm != NULL; lm = next ) {
		next = lm->lm_next;
		ldap_msgfree( lm );
	}

	tcp_close( ld->ld_sb.sb_sd );

	if ( ld->ld_cache != NULL )
		ldap_destroy_cache( ld );
	if ( ld->ld_error != NULL )
		free( ld->ld_error );
	if ( ld->ld_host != NULL )
		free( ld->ld_host );
	if ( ld->ld_sb.sb_ber.ber_buf != NULL )
		free( ld->ld_sb.sb_ber.ber_buf );
	free( (char *) ld );

	return( err );
}

ldap_unbind_s( ld )
LDAP	*ld;
{
	return( ldap_unbind( ld ) );
}

