/* dtest.c - lber decoding test program */
/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#ifdef MACOS
#include <stdlib.h>
#include <console.h>
#endif /* MACOS */
#include "lber.h"

static usage( name )
char	*name;
{
	fprintf( stderr, "usage: %s [-i] [-n] [-o] [-seq] [-set]\n", name );
}

main( argc, argv )
int	argc;
char	**argv;
{
	long		i, i2, num;
	unsigned long	len;
	int		tag;
	char		*str, *s1, *s2;
	BerElement	ber;
	Sockbuf		sb;
	extern char	*optarg;

#ifdef MACOS
	ccommand( &argv );
	cshow( stdout );
#endif /* MACOS */

	sb.sb_sd = 0;
	sb.sb_ber.ber_buf = NULL;
	if ( (tag = ber_get_next( &sb, &len, &ber )) == -1 ) {
		perror( "ber_get_next" );
		exit( 1 );
	}
	printf( "message has tag 0x%x and length %ld\n", tag, len );

	if ( ber_scanf( &ber, "i", &i ) == -1 ) {
		fprintf( stderr, "ber_scanf returns -1\n" );
		exit( 1 );
	}
	printf( "got int %d\n", i );
	exit( 0 );

	while ( (i = getopt( argc, argv, "inos:" )) != EOF ) {
		switch ( i ) {
		case 'i':	/* decode an integer */
			if ( (tag = ber_get_int( &ber, &num )) == -1 )
				perror( "ber_get_int" );
			else
				printf( "got %d with tag 0x%x\n", num, tag );
			break;

		case 'n':	/* decode a null */
			if ( (tag = ber_get_null( &ber )) == -1 )
				perror( "ber_get_null" );
			else
				printf( "got tag 0x%x\n", num, tag );
			break;

		case 'o':	/* decode an octet string */
			if ( (tag = ber_get_stringa( &ber, &str )) == -1 )
				perror( "ber_get_stringa" );
			else
				printf( "got (%s) with tag 0x%x\n", str, tag );
			break;

		case 's':	/* start to decode a set or sequence */
			/* sequence */
			if ( strcmp( optarg, "eq" ) == 0 ) {
				if ( (tag = ber_skip_tag( &ber, &len )) == -1 )
					perror( "ber_skip_tag" );
				else
					printf( "starting seq with tag 0x%x\n",
					    tag );
			/* set */
			} else if ( strcmp( optarg, "et" ) == 0 ) {
				if ( (tag = ber_skip_tag( &ber, &len )) == -1 )
					perror( "ber_skip_tag" );
				else
					printf( "starting set with tag 0x%x\n",
					    tag );
			} else {
				usage( argv[0] );
			}
			break;

		default:
			usage( argv[0] );
			break;
		}
	}

	exit( 0 );
}
