/* geompk.f -- translated by f2c (version of 22 July 1992  22:54:52).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    integer ierr;
} gerror_;

#define gerror_1 gerror_

struct {
    doublereal pi, tol;
} gconst_;

#define gconst_1 gconst_

struct {
    integer iprt, msglvl;
} gprint_;

#define gprint_1 gprint_

/* Table of constant values */

static integer c__350 = 350;
static integer c__2000 = 2000;
static integer c__900 = 900;
static integer c__5000 = 5000;
static integer c__1500 = 1500;
static integer c__8000 = 8000;


/*     Written and copyright by: */
/*        Barry Joe, Dept. of Computing Science, Univ. of Alberta */
/*        Edmonton, Alberta, Canada  T6G 2H1 */
/*        Phone: (403) 492-5757      Email: barry@cs.ualberta.ca */

/*     Modifications by Jason Gobat (jgobat@ucsd.edu) to turn what */
/*     was a main program into a subroutine to interface with the */
/*     FElt system (this is the only Fortran routine that FElt calls). */

/* Subroutine */ int geompk_(tolin, angspc, angtol, kappa, dmin__, nmin, 
	ntrid, nvc, ncur, nvbc, vcl, til, ntri, istat)
doublereal *tolin, *angspc, *angtol, *kappa, *dmin__;
integer *nmin, *ntrid, *nvc, *ncur, *nvbc;
doublereal *vcl;
integer *til, *ntri, *istat;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static doublereal area[350], iang[2000];
    static integer irdr, vnum[2000];
    extern doublereal umdf2_();
    static doublereal h[350];
    static logical hflag;
    static integer imeas, nhola, nhole, npolg, nvert;
    extern /* Subroutine */ int cvdec2_(), spdec2_(), eqdis2_(), tripr2_();
    static integer nh;
    static doublereal wk[1500];
    extern /* Subroutine */ int initcb_(), dsmcpr_();
    static integer regnum[350], tstart[350], vstart[2000], hvl[350], iwk[900];

    static doublereal psi[350];
    static integer pvl[8000]	/* was [4][2000] */;


/*     Driver routine for interfacing the Geompack library */





/*     Read in vertices of general polygonal region. */
/*     CASE = 1 : simple polygon or multiply connected polygonal region */


    /* Parameter adjustments */
    til -= 4;
    vcl -= 3;
    --nvbc;

    /* Function Body */
    irdr = 5;
    imeas = 7;
    initcb_(tolin);
    *angspc = *angspc * gconst_1.pi / 180.;
    *angtol = *angtol * gconst_1.pi / 180.;
    hflag = *kappa >= 0. && *kappa <= 1.;
    if (*nvc > 5000) {
	*istat = 24;
	return 0;
    } else if (*ncur > 30) {
	*istat = 24;
	return 0;
    }

/*     Call routine DSMCPR or DSPGDC to set data structures in arrays */
/*     REGNUM, HVL, PVL, IANG, HOLV = IWK. */

    nhole = *ncur - 1;
    dsmcpr_(&nhole, &nvbc[1], &vcl[3], &c__350, &c__2000, &c__900, nvc, &
	    npolg, &nvert, &nhola, regnum, hvl, pvl, iang, iwk);
    if (gerror_1.ierr != 0) {
	*istat = gerror_1.ierr;
	return 0;
    }
    nh = (nhole << 1) + nhola;

/*     Obtain simple and convex polygon decompositions, and print */
/*     measurements. */

    i__1 = 900 - nh;
    spdec2_(angspc, angtol, nvc, &npolg, &nvert, &nhole, &nhola, &c__5000, &
	    c__350, &c__2000, &i__1, &c__1500, iwk, &vcl[3], regnum, hvl, pvl,
	     iang, &iwk[nh], wk);
    cvdec2_(angspc, angtol, nvc, &npolg, &nvert, &c__5000, &c__350, &c__2000, 
	    &c__900, &c__1500, &vcl[3], regnum, hvl, pvl, iang, iwk, wk);
    if (gerror_1.ierr != 0) {
	*istat = gerror_1.ierr;
	return 0;
    }

/*     Obtain further convex polygon decomposition based on mesh */
/*     distribution function, and triangle sizes for the polygons. */
/*     Then print measurements. */

    eqdis2_(&hflag, umdf2_, kappa, angspc, angtol, dmin__, nmin, ntrid, nvc, &
	    npolg, &nvert, &c__5000, &c__350, &c__2000, &c__900, &c__1500, &
	    vcl[3], regnum, hvl, pvl, iang, area, psi, h, iwk, wk);
    if (gerror_1.ierr != 0) {
	*istat = gerror_1.ierr;
	return 0;
    }

/*     Triangulate each convex polygon in decomposition according to */
/*     mesh spacings in H array. */

    tripr2_(nvc, &npolg, &nvert, &c__5000, &c__8000, &c__900, &c__1500, h, &
	    vcl[3], hvl, pvl, iang, ntri, &til[4], vstart, vnum, tstart, iwk, 
	    wk);
    if (gerror_1.ierr != 0) {
	*istat = gerror_1.ierr;
	return 0;
    }

/*     Check for errors, if none we succeeded */

    if (gerror_1.ierr != 0) {
	*istat = gerror_1.ierr;
	return 0;
    }
    *istat = 0;
/* L610: */
} /* geompk_ */

/* Subroutine */ int geompk___(tolin, angspc, angtol, kappa, dmin__, nmin, 
	ntrid, nvc, ncur, nvbc, vcl, til, ntri, istat)
doublereal *tolin, *angspc, *angtol, *kappa, *dmin__;
integer *nmin, *ntrid, *nvc, *ncur, *nvbc;
doublereal *vcl;
integer *til, *ntri, *istat;
{
    extern /* Subroutine */ int geompk_();


/*     Driver routine for interfacing the Geompack library */





    /* Parameter adjustments */
    til -= 4;
    vcl -= 3;
    --nvbc;

    /* Function Body */
    geompk_(tolin, angspc, angtol, kappa, dmin__, nmin, ntrid, nvc, ncur, &
	    nvbc[1], &vcl[3], &til[4], ntri, istat);
} /* geompk___ */

