#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "parser.y"
/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	parser.y						*
 *									*
 * Description:	This file contains the yacc specification for the	*
 *		input file parser.					*
 ************************************************************************/

# include <stdio.h>
# include <string.h>
# include <math.h>
# include "problem.h"
# include "allocate.h"
# include "objects.h"
# include "error.h"

# define ln problem.line
# define MNPE MaxNodesPerElement

static double		  lastx;		/* last x coordinate	    */
static double		  lasty;		/* last y coordinate	    */
static double		  lastz;		/* last z coordinate	    */
static char		 *lastconstraint;	/* name of last constraint  */
static char		 *lastmaterial;		/* name of last material    */
static int		  intarray [MNPE];	/* integer array	    */
static int		 *intptr;		/* pointer into array	    */
static Pair		  pairarray [MNPE];	/* pair array		    */
static Pair		 *pairptr;		/* pointer into array	    */
static Node		  node;			/* current node		    */
static Element		  element;		/* current element	    */
static Material		  material;		/* current material	    */
static Force		  force;		/* current force	    */
static Constraint	  constraint;		/* current constraint       */
static Distributed        distributed;		/* current distributed load */
static Definition	  definition;		/* current definition	    */
static struct node	  dummy_node;		/* dummy node		    */
static struct element     dummy_element;	/* dummy element	    */
static struct force	  dummy_force;		/* dummy force		    */
static struct material    dummy_material;	/* dummy material	    */
static struct constraint  dummy_constraint;	/* dummy constraint	    */
static struct distributed dummy_distributed;	/* dummy distributed load   */
#line 63 "parser.y"
typedef union {
    double d;
    int	   i;
    char  *s;
    Pair   p;
} YYSTYPE;
#line 73 "y.tab.c"
#define UNARY 257
#define DOUBLE 258
#define INTEGER 259
#define STRING 260
#define BOLINTEGER 261
#define BOLSTRING 262
#define PROBLEM 263
#define NODES 264
#define ELEMENTS 265
#define MATERIALS 266
#define FORCES 267
#define CONSTRAINTS 268
#define DISTRIBUTED 269
#define END 270
#define TITLE_EQ 271
#define NODES_EQ 272
#define ELEMENTS_EQ 273
#define MATERIAL_EQ 274
#define FORCE_EQ 275
#define CONSTRAINT_EQ 276
#define DIR_EQ 277
#define VALUES_EQ 278
#define LOAD_EQ 279
#define X_EQ 280
#define Y_EQ 281
#define Z_EQ 282
#define E_EQ 283
#define IX_EQ 284
#define IY_EQ 285
#define IZ_EQ 286
#define A_EQ 287
#define J_EQ 288
#define G_EQ 289
#define T_EQ 290
#define RHO_EQ 291
#define NU_EQ 292
#define KAPPA_EQ 293
#define FX_EQ 294
#define FY_EQ 295
#define FZ_EQ 296
#define MX_EQ 297
#define MY_EQ 298
#define MZ_EQ 299
#define TX_EQ 300
#define TY_EQ 301
#define TZ_EQ 302
#define RX_EQ 303
#define RY_EQ 304
#define RZ_EQ 305
#define SIN 306
#define COS 307
#define TAN 308
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    4,    6,    6,    7,    7,    8,    8,    8,    5,
    5,    9,    9,    9,    9,    9,   16,    9,   10,   10,
   15,   15,   11,   11,   12,   12,   13,   13,   14,   14,
   24,   17,   17,   26,   18,   18,   28,   19,   19,   30,
   20,   20,   32,   21,   21,   34,   22,   22,   23,   23,
   25,   25,   27,   27,   29,   29,   31,   31,   33,   33,
   35,   35,   35,   35,   35,   36,   36,   36,   37,   37,
   37,   37,   37,   37,   37,   37,   37,   37,   37,   38,
   38,   38,   38,   38,   38,   39,   39,   39,   39,   39,
   39,   40,   40,    1,    1,   41,   41,   42,   42,    3,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,
};
short yylen[] = {                                         2,
    3,    1,    2,    0,    2,    0,    2,    2,    2,    2,
    0,    2,    2,    2,    2,    2,    0,    3,    2,    0,
    2,    0,    2,    0,    2,    0,    2,    0,    2,    0,
    0,    3,    1,    0,    3,    1,    0,    3,    1,    0,
    3,    1,    0,    3,    1,    0,    3,    1,    2,    0,
    2,    0,    2,    0,    2,    0,    2,    0,    2,    0,
    2,    2,    2,    2,    2,    4,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    1,    1,    1,    1,    1,
    1,    1,    2,    2,    1,    2,    1,    2,    1,    4,
    3,    3,    3,    3,    2,    2,    3,    4,    4,    4,
    1,    1,
};
short yydefred[] = {                                      0,
    6,    0,   11,    2,    0,    0,    0,    0,    0,    5,
   20,   17,   24,   26,   28,   30,    1,   10,    9,    7,
    8,    0,   22,    0,    0,    0,    0,   33,   31,   19,
    0,   39,   37,   23,   42,   40,   25,   45,   43,   27,
   48,   46,   29,   50,   36,   34,   21,   54,   56,   58,
   60,    0,   52,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   53,    0,    0,    0,    0,
    0,    0,   55,   86,   87,   88,   89,   90,   91,   57,
   92,    0,   59,   64,   65,    0,    0,  111,  112,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   99,    0,
  106,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   67,   95,    0,    0,   98,    0,    0,    0,  107,
    0,    0,  103,  104,   97,    0,   94,    0,  108,  109,
  110,   96,   66,  100,
};
short yydgoto[] = {                                       2,
  144,  104,  129,    3,    6,    4,    5,   10,   18,   22,
   24,   25,   26,   27,   31,   23,   30,   47,   34,   37,
   40,   43,   52,   44,   64,   53,   54,   48,   55,   49,
   56,   50,   57,   51,   63,  110,   76,   83,   90,   93,
  156,  130,
};
short yysindex[] = {                                   -256,
    0,    0,    0,    0, -183, -194, -237, -214, -181,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -80,    0, -179, -141,  -98,  -97,    0,    0,    0,
  -41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -234,    0, -253, -102,  234, -267, -169, -144,  -40,
  -40,  -40,    0, -220,  -40,  -40,  -40,  -40,  -40,  -40,
  -40,  -40,  -40,  -40,  -40,    0,  -40,  -40,  -40,  -40,
  -40,  -40,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   39,    0,    0,    0,  -40,  -40,    0,    0,   63,
   77,   78,  -40,  327,  327,  327,   28, -124, -110,    0,
  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
  327,  327,  327,  327,  327,  327,  327, -108,    0,   39,
    0,    0,  -40,  -40,  -40,   15,  -40,  -40,  -40,  -40,
  -84,    0,    0,  -99,  -40,    0,   59,  137,  268,    0,
  174,  174,    0,    0,    0,  -92,    0,  283,    0,    0,
    0,    0,    0,    0,
};
short yyrindex[] = {                                   -135,
    0,    0,    0,    0, -121,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   74,    0,   88,  118,  156,  194,    0,    0,    0,
  232,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  591,    0,  606,  621,  636,  651,    0,    0,    0,
    0,    0,    0,  666,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  491,  513,  535,    0,    0,    0,    0,
  -79,  111,  149,  187,  225,  263,  301,  339,  377,  415,
  453, -201, -157, -142,  -96,   52,   67,    0,    0,  576,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  557,    0,    0,    0,    0,    0,    0,
  -39,    8,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
    0,  -53,   32,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
#define YYTABLESIZE 936
short yytable[] = {                                     103,
  163,  101,   96,  101,   97,  101,    1,  105,  106,   91,
   92,  111,  112,  113,  114,  115,  116,  117,  118,  119,
  120,  121,   19,  122,  123,  124,  125,  126,  127,   65,
   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
   58,   59,  131,  132,   20,   60,   61,   62,  102,  136,
  102,  107,  102,  108,   80,  150,  139,  137,  109,  138,
   80,  140,   80,   80,   80,   80,   80,   80,   80,   11,
   12,   13,   14,   15,   16,   17,   32,   21,  128,  147,
  148,  149,   33,  151,  152,  153,  154,    7,    8,    9,
   94,  158,   80,   80,   80,   80,   80,   80,   81,  159,
  139,  137,  133,  138,   81,  140,   81,   81,   81,   81,
   81,   81,   81,   82,   35,   95,  134,  135,  141,   82,
   36,   82,   82,   82,   82,   82,   82,   82,    4,    4,
    4,    4,    4,    4,    4,  142,   81,   81,   81,   81,
   81,   81,    3,    3,    3,    3,    3,    3,    3,  143,
  145,   82,   82,   82,   82,   82,   82,   38,   41,   83,
  157,  146,    0,   39,   42,   83,  162,   83,   83,   83,
   83,   83,   83,   83,  155,   28,   69,  160,  139,  137,
   29,  138,   69,  140,   69,   69,   69,   69,   69,   69,
   69,   77,   78,   79,   80,   81,   82,   83,   83,   83,
   83,   83,   83,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   45,  139,  101,   98,   99,   46,
  140,  101,  101,    0,  101,  101,  101,  101,  101,  101,
  101,    0,    0,    0,    0,  101,  101,    0,    0,    0,
  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
    0,    0,    0,  102,    0,  100,  101,  102,  102,  102,
    0,  102,  102,  102,  102,  102,  102,  102,    0,    0,
    0,    0,  102,  102,    0,    0,    0,  102,  102,  102,
  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
  102,  102,  102,  102,  102,  102,  102,   84,  161,  139,
  137,    0,  138,   84,  140,   84,   84,   84,   84,   84,
   84,   84,   85,  164,  139,  137,    0,  138,   85,  140,
   85,   85,   85,   85,   85,   85,   85,   12,   12,   12,
   12,   12,   12,   12,    0,   84,   84,   84,   84,   84,
   84,   13,   13,   13,   13,   13,   13,   13,    0,    0,
   85,   85,   85,   85,   85,   85,   70,    0,  139,  137,
    0,  138,   70,  140,   70,   70,   70,   70,   70,   70,
   70,   14,   14,   14,   14,   14,   14,   14,    0,    0,
    0,    0,    0,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   71,    0,    0,    0,    0,    0,
   71,    0,   71,   71,   71,   71,   71,   71,   71,   15,
   15,   15,   15,   15,   15,   15,    0,    0,    0,    0,
    0,   71,   71,   71,   71,   71,   71,   71,   71,   71,
   71,   71,   72,    0,    0,    0,    0,    0,   72,    0,
   72,   72,   72,   72,   72,   72,   72,   16,   16,   16,
   16,   16,   16,   16,    0,    0,    0,    0,    0,   72,
   72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
   73,    0,    0,    0,    0,    0,   73,    0,   73,   73,
   73,   73,   73,   73,   73,   18,   18,   18,   18,   18,
   18,   18,    0,    0,    0,    0,    0,   73,   73,   73,
   73,   73,   73,   73,   73,   73,   73,   73,   74,    0,
    0,    0,    0,    0,   74,    0,   74,   74,   74,   74,
   74,   74,   74,   84,   85,   86,   87,   88,   89,    0,
    0,    0,    0,    0,    0,   74,   74,   74,   74,   74,
   74,   74,   74,   74,   74,   74,   75,    0,    0,    0,
    0,    0,   75,    0,   75,   75,   75,   75,   75,   75,
   75,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   75,   75,   75,   75,   75,   75,   75,
   75,   75,   75,   75,   76,    0,    0,    0,    0,    0,
   76,    0,   76,   76,   76,   76,   76,   76,   76,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   77,    0,    0,    0,    0,    0,   77,    0,
   77,   77,   77,   77,   77,   77,   77,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   77,
   77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
   78,    0,    0,    0,    0,    0,   78,    0,   78,   78,
   78,   78,   78,   78,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   78,   78,   78,
   78,   78,   78,   78,   78,   78,   78,   78,   79,    0,
    0,    0,    0,    0,   79,    0,   79,   79,   79,   79,
   79,   79,   79,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   79,   79,   79,   79,   79,
   79,   79,   79,   79,   79,   79,   61,    0,    0,    0,
    0,   61,    0,    0,   61,   61,   61,   61,   61,   61,
   61,    0,    0,    0,    0,   61,   61,    0,   62,    0,
   61,   61,   61,   62,    0,    0,   62,   62,   62,   62,
   62,   62,   62,    0,    0,    0,    0,   62,   62,    0,
   63,    0,   62,   62,   62,   63,    0,    0,   63,   63,
   63,   63,   63,   63,   63,    0,    0,    0,    0,   63,
   63,    0,   68,    0,   63,   63,   63,   68,    0,    0,
   68,   68,   68,   68,   68,   68,   68,    0,   68,    0,
   68,   93,    0,    0,    0,   68,    0,   93,    0,   93,
   93,   93,   93,   93,   93,   93,   32,    0,    0,    0,
    0,   32,   93,   93,   32,   32,   32,   32,   32,   32,
   32,   38,    0,    0,    0,    0,    0,   38,    0,   38,
   38,   38,   38,   38,   38,   38,   41,    0,    0,    0,
    0,    0,   41,    0,   41,   41,   41,   41,   41,   41,
   41,   44,    0,    0,    0,    0,    0,   44,    0,   44,
   44,   44,   44,   44,   44,   44,   47,    0,    0,    0,
    0,    0,   47,    0,   47,   47,   47,   47,   47,   47,
   47,   35,    0,    0,    0,    0,   35,    0,    0,   35,
   35,   35,   35,   35,   35,   35,
};
short yycheck[] = {                                      40,
   93,   41,   43,   43,   45,   45,  263,   61,   62,  277,
  278,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,  260,   77,   78,   79,   80,   81,   82,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  275,  276,   96,   97,  259,  280,  281,  282,   41,  103,
   43,  272,   45,  274,  256,   41,   42,   43,  279,   45,
  262,   47,  264,  265,  266,  267,  268,  269,  270,  264,
  265,  266,  267,  268,  269,  270,  256,  259,   40,  133,
  134,  135,  262,  137,  138,  139,  140,  271,  272,  273,
  260,  145,  294,  295,  296,  297,  298,  299,  256,   41,
   42,   43,   40,   45,  262,   47,  264,  265,  266,  267,
  268,  269,  270,  256,  256,  260,   40,   40,   91,  262,
  262,  264,  265,  266,  267,  268,  269,  270,  264,  265,
  266,  267,  268,  269,  270,  260,  294,  295,  296,  297,
  298,  299,  264,  265,  266,  267,  268,  269,  270,  260,
  259,  294,  295,  296,  297,  298,  299,  256,  256,  256,
  260,  130,   -1,  262,  262,  262,  259,  264,  265,  266,
  267,  268,  269,  270,  259,  256,  256,   41,   42,   43,
  261,   45,  262,   47,  264,  265,  266,  267,  268,  269,
  270,  294,  295,  296,  297,  298,  299,  294,  295,  296,
  297,  298,  299,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  256,   42,  256,  258,  259,  261,
   47,  261,  262,   -1,  264,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,   -1,  275,  276,   -1,   -1,   -1,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
   -1,   -1,   -1,  256,   -1,  306,  307,  308,  261,  262,
   -1,  264,  265,  266,  267,  268,  269,  270,   -1,   -1,
   -1,   -1,  275,  276,   -1,   -1,   -1,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  256,   41,   42,
   43,   -1,   45,  262,   47,  264,  265,  266,  267,  268,
  269,  270,  256,   41,   42,   43,   -1,   45,  262,   47,
  264,  265,  266,  267,  268,  269,  270,  264,  265,  266,
  267,  268,  269,  270,   -1,  294,  295,  296,  297,  298,
  299,  264,  265,  266,  267,  268,  269,  270,   -1,   -1,
  294,  295,  296,  297,  298,  299,  256,   -1,   42,   43,
   -1,   45,  262,   47,  264,  265,  266,  267,  268,  269,
  270,  264,  265,  266,  267,  268,  269,  270,   -1,   -1,
   -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,  264,  265,  266,  267,  268,  269,  270,  264,
  265,  266,  267,  268,  269,  270,   -1,   -1,   -1,   -1,
   -1,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,
  264,  265,  266,  267,  268,  269,  270,  264,  265,  266,
  267,  268,  269,  270,   -1,   -1,   -1,   -1,   -1,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  264,  265,
  266,  267,  268,  269,  270,  264,  265,  266,  267,  268,
  269,  270,   -1,   -1,   -1,   -1,   -1,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  256,   -1,
   -1,   -1,   -1,   -1,  262,   -1,  264,  265,  266,  267,
  268,  269,  270,  300,  301,  302,  303,  304,  305,   -1,
   -1,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  264,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,  264,  265,  266,  267,  268,  269,  270,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,
  264,  265,  266,  267,  268,  269,  270,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  264,  265,
  266,  267,  268,  269,  270,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  256,   -1,
   -1,   -1,   -1,   -1,  262,   -1,  264,  265,  266,  267,
  268,  269,  270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  256,   -1,   -1,   -1,
   -1,  261,   -1,   -1,  264,  265,  266,  267,  268,  269,
  270,   -1,   -1,   -1,   -1,  275,  276,   -1,  256,   -1,
  280,  281,  282,  261,   -1,   -1,  264,  265,  266,  267,
  268,  269,  270,   -1,   -1,   -1,   -1,  275,  276,   -1,
  256,   -1,  280,  281,  282,  261,   -1,   -1,  264,  265,
  266,  267,  268,  269,  270,   -1,   -1,   -1,   -1,  275,
  276,   -1,  256,   -1,  280,  281,  282,  261,   -1,   -1,
  264,  265,  266,  267,  268,  269,  270,   -1,  272,   -1,
  274,  256,   -1,   -1,   -1,  279,   -1,  262,   -1,  264,
  265,  266,  267,  268,  269,  270,  256,   -1,   -1,   -1,
   -1,  261,  277,  278,  264,  265,  266,  267,  268,  269,
  270,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  264,
  265,  266,  267,  268,  269,  270,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  264,  265,  266,  267,  268,  269,
  270,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  264,
  265,  266,  267,  268,  269,  270,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  264,  265,  266,  267,  268,  269,
  270,  256,   -1,   -1,   -1,   -1,  261,   -1,   -1,  264,
  265,  266,  267,  268,  269,  270,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 308
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'['",0,"']'",0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"UNARY","DOUBLE","INTEGER","STRING","BOLINTEGER","BOLSTRING","PROBLEM","NODES",
"ELEMENTS","MATERIALS","FORCES","CONSTRAINTS","DISTRIBUTED","END","TITLE_EQ",
"NODES_EQ","ELEMENTS_EQ","MATERIAL_EQ","FORCE_EQ","CONSTRAINT_EQ","DIR_EQ",
"VALUES_EQ","LOAD_EQ","X_EQ","Y_EQ","Z_EQ","E_EQ","IX_EQ","IY_EQ","IZ_EQ",
"A_EQ","J_EQ","G_EQ","T_EQ","RHO_EQ","NU_EQ","KAPPA_EQ","FX_EQ","FY_EQ","FZ_EQ",
"MX_EQ","MY_EQ","MZ_EQ","TX_EQ","TY_EQ","TZ_EQ","RX_EQ","RY_EQ","RZ_EQ","SIN",
"COS","TAN",
};
char *yyrule[] = {
"$accept : specification",
"specification : description definition_list END",
"description : optional_info",
"optional_info : PROBLEM info_list",
"optional_info :",
"info_list : info_list info",
"info_list :",
"info : NODES_EQ INTEGER",
"info : ELEMENTS_EQ INTEGER",
"info : TITLE_EQ STRING",
"definition_list : definition_list definition",
"definition_list :",
"definition : NODES node_list",
"definition : MATERIALS material_list",
"definition : FORCES force_list",
"definition : CONSTRAINTS constraint_list",
"definition : DISTRIBUTED distributed_list",
"$$1 :",
"definition : ELEMENTS $$1 element_list",
"node_list : node_list node",
"node_list :",
"element_list : element_list element",
"element_list :",
"material_list : material_list material",
"material_list :",
"force_list : force_list force",
"force_list :",
"constraint_list : constraint_list constraint",
"constraint_list :",
"distributed_list : distributed_list distributed",
"distributed_list :",
"$$2 :",
"node : BOLINTEGER $$2 node_arg_list",
"node : error",
"$$3 :",
"element : BOLINTEGER $$3 element_arg_list",
"element : error",
"$$4 :",
"material : BOLSTRING $$4 material_arg_list",
"material : error",
"$$5 :",
"force : BOLSTRING $$5 force_arg_list",
"force : error",
"$$6 :",
"constraint : BOLSTRING $$6 constraint_arg_list",
"constraint : error",
"$$7 :",
"distributed : BOLSTRING $$7 distributed_arg_list",
"distributed : error",
"node_arg_list : node_arg_list node_arg",
"node_arg_list :",
"element_arg_list : element_arg_list element_arg",
"element_arg_list :",
"material_arg_list : material_arg_list material_arg",
"material_arg_list :",
"force_arg_list : force_arg_list force_arg",
"force_arg_list :",
"constraint_arg_list : constraint_arg_list constraint_arg",
"constraint_arg_list :",
"distributed_arg_list : distributed_arg_list distributed_arg",
"distributed_arg_list :",
"node_arg : X_EQ expression",
"node_arg : Y_EQ expression",
"node_arg : Z_EQ expression",
"node_arg : FORCE_EQ STRING",
"node_arg : CONSTRAINT_EQ STRING",
"element_arg : NODES_EQ '[' integer_list ']'",
"element_arg : MATERIAL_EQ STRING",
"element_arg : LOAD_EQ string_list",
"material_arg : E_EQ expression",
"material_arg : IX_EQ expression",
"material_arg : IY_EQ expression",
"material_arg : IZ_EQ expression",
"material_arg : A_EQ expression",
"material_arg : J_EQ expression",
"material_arg : G_EQ expression",
"material_arg : T_EQ expression",
"material_arg : RHO_EQ expression",
"material_arg : NU_EQ expression",
"material_arg : KAPPA_EQ expression",
"force_arg : FX_EQ expression",
"force_arg : FY_EQ expression",
"force_arg : FZ_EQ expression",
"force_arg : MX_EQ expression",
"force_arg : MY_EQ expression",
"force_arg : MZ_EQ expression",
"constraint_arg : TX_EQ",
"constraint_arg : TY_EQ",
"constraint_arg : TZ_EQ",
"constraint_arg : RX_EQ",
"constraint_arg : RY_EQ",
"constraint_arg : RZ_EQ",
"distributed_arg : DIR_EQ",
"distributed_arg : VALUES_EQ pair_list",
"string_list : string_list STRING",
"string_list : STRING",
"integer_list : integer_list INTEGER",
"integer_list : INTEGER",
"pair_list : pair_list pair",
"pair_list : pair",
"pair : '(' INTEGER expression ')'",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '-' expression",
"expression : '+' expression",
"expression : '(' expression ')'",
"expression : SIN '(' expression ')'",
"expression : COS '(' expression ')'",
"expression : TAN '(' expression ')'",
"expression : DOUBLE",
"expression : INTEGER",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 92 "parser.y"
{
		if (problem.numerrors) {
		    error ("%d error(s) found in input", problem.numerrors);
		    return problem.numerrors;
		}

		if (resolvenames ( ))
		    return problem.numerrors;
	    }
break;
case 2:
#line 106 "parser.y"
{
		problem.node_tree        = TreeCreate (node_cmp);
		problem.element_tree     = TreeCreate (element_cmp);
		problem.force_tree       = TreeCreate (force_cmp);
		problem.material_tree    = TreeCreate (material_cmp);
		problem.constraint_tree  = TreeCreate (constraint_cmp);
		problem.distributed_tree = TreeCreate (distributed_cmp);

		lastx = lasty = lastz = 0;
		lastconstraint = lastmaterial = NULL;

		memset (&dummy_node, 0, sizeof (struct node));
		memset (&dummy_element, 0, sizeof (struct element));
		memset (&dummy_force, 0, sizeof (struct force));
		memset (&dummy_material, 0, sizeof (struct material));
		memset (&dummy_constraint, 0, sizeof (struct constraint));
		memset (&dummy_distributed, 0, sizeof (struct distributed));
	    }
break;
case 4:
#line 130 "parser.y"
{
		problem.numnodes = 0;
		problem.numelements = 0;
		problem.title = NULL;
	    }
break;
case 7:
#line 145 "parser.y"
{problem.numnodes = yyvsp[0].i;}
break;
case 8:
#line 147 "parser.y"
{problem.numelements = yyvsp[0].i;}
break;
case 9:
#line 149 "parser.y"
{problem.title = yyvsp[0].s;}
break;
case 17:
#line 166 "parser.y"
{definition = defnlookup (yyvsp[0].s); Deallocate (yyvsp[0].s);
	     if (definition == NULL) return -1;}
break;
case 31:
#line 210 "parser.y"
{
		Item found;


		if (yyvsp[0].i < 1 || yyvsp[0].i > problem.numnodes) {
		    error ("node number %d is illegal (near line %d)", yyvsp[0].i, ln);
		    node = &dummy_node;
		    problem.numerrors ++;
		    break;
		}

		node = CreateNode (yyvsp[0].i);
		found = TreeInsert (problem.node_tree, node);

		if ((Node) found != node) {
		    error ("node number %d is repeated (near line %d)", yyvsp[0].i, ln);
		    DestroyNode (node);
		    node = &dummy_node;
		    problem.numerrors ++;
		    break;
		}

		node -> x	   = lastx;
		node -> y	   = lasty;
		node -> z	   = lastz;
		node -> constraint = (Constraint) lastconstraint;
	    }
break;
case 34:
#line 244 "parser.y"
{
	        Item found;


		if (yyvsp[0].i < 1 || yyvsp[0].i > problem.numelements) {
		    error ("element number %d is illegal (near line %d)",yyvsp[0].i,ln);
		    element = &dummy_element;
		    problem.numerrors ++;
		    break;
		}

		element = CreateElement (yyvsp[0].i, definition);
		found = TreeInsert (problem.element_tree, element);

		if ((Element) found != element) {
		    error("element number %d is repeated (near line %d)",yyvsp[0].i,ln);
		    DestroyElement (element);
		    element = &dummy_element;
		    problem.numerrors ++;
		    break;
		}

		element -> material = (Material) lastmaterial;
	    }
break;
case 37:
#line 275 "parser.y"
{
		Item found;


		material = CreateMaterial (yyvsp[0].s);
		found = TreeInsert (problem.material_tree, material);

		if ((Material) found != material) {
		    error ("material %s is previously defined", yyvsp[0].s);
		    DestroyMaterial (material);
		    material = &dummy_material;
		    problem.numerrors ++;
		}
	    }
break;
case 40:
#line 296 "parser.y"
{
		Item found;


		force = CreateForce (yyvsp[0].s);
		found = TreeInsert (problem.force_tree, force);

		if ((Force) found != force) {
		    error ("force %s is previously defined", yyvsp[0].s);
		    DestroyForce (force);
		    force = &dummy_force;
		    problem.numerrors ++;
		}
	    }
break;
case 43:
#line 317 "parser.y"
{
		Item found;


		constraint = CreateConstraint (yyvsp[0].s);
		found = TreeInsert (problem.constraint_tree, constraint);

		if ((Constraint) found != constraint) {
		    error ("constraint %s is previously defined", yyvsp[0].s);
		    DestroyConstraint (constraint);
		    constraint = &dummy_constraint;
		    problem.numerrors ++;
		}
	    }
break;
case 46:
#line 338 "parser.y"
{
		Item found;


		distributed = CreateDistributed (yyvsp[0].s, 0);
		found = TreeInsert (problem.distributed_tree, distributed);

		if ((Distributed) found != distributed) {
		    error ("distributed load %s is previously defined", yyvsp[0].s);
		    DestroyDistributed (distributed);
		    distributed = &dummy_distributed;
		    problem.numerrors ++;
		}
	    }
break;
case 61:
#line 394 "parser.y"
{lastx = node -> x = yyvsp[0].d;}
break;
case 62:
#line 396 "parser.y"
{lasty = node -> y = yyvsp[0].d;}
break;
case 63:
#line 398 "parser.y"
{lastz = node -> z = yyvsp[0].d;}
break;
case 64:
#line 400 "parser.y"
{node -> force = (Force) yyvsp[0].s;}
break;
case 65:
#line 402 "parser.y"
{node -> constraint = (Constraint) yyvsp[0].s;
				 lastconstraint = yyvsp[0].s;}
break;
case 66:
#line 409 "parser.y"
{
		int i, size;


		if (element == &dummy_element)
		    break;

		size = intptr - intarray;

		if (size != element -> definition -> numnodes) {
		    error ("incorrect number of nodes for element %d",
			    element -> number);
		    problem.numerrors ++;
		    break;
		}

		for (i = 1; i <= size; i ++)
		    element -> node [i] = (Node) intarray [i - 1];
	    }
break;
case 67:
#line 430 "parser.y"
{
		element -> material = (Material) (lastmaterial = yyvsp[0].s);
	    }
break;
case 69:
#line 439 "parser.y"
{material -> E = yyvsp[0].d;}
break;
case 70:
#line 441 "parser.y"
{material -> Ix = yyvsp[0].d;}
break;
case 71:
#line 443 "parser.y"
{material -> Iy = yyvsp[0].d;}
break;
case 72:
#line 445 "parser.y"
{material -> Iz = yyvsp[0].d;}
break;
case 73:
#line 447 "parser.y"
{material -> A = yyvsp[0].d;}
break;
case 74:
#line 449 "parser.y"
{material -> J = yyvsp[0].d;}
break;
case 75:
#line 451 "parser.y"
{material -> G = yyvsp[0].d;}
break;
case 76:
#line 453 "parser.y"
{material -> t = yyvsp[0].d;}
break;
case 77:
#line 455 "parser.y"
{material -> rho = yyvsp[0].d;}
break;
case 78:
#line 457 "parser.y"
{material -> nu = yyvsp[0].d;}
break;
case 79:
#line 459 "parser.y"
{material -> kappa = yyvsp[0].d;}
break;
case 80:
#line 464 "parser.y"
{force -> force [Fx] = yyvsp[0].d;}
break;
case 81:
#line 466 "parser.y"
{force -> force [Fy] = yyvsp[0].d;}
break;
case 82:
#line 468 "parser.y"
{force -> force [Fz] = yyvsp[0].d;}
break;
case 83:
#line 470 "parser.y"
{force -> force [Mx] = yyvsp[0].d;}
break;
case 84:
#line 472 "parser.y"
{force -> force [My] = yyvsp[0].d;}
break;
case 85:
#line 474 "parser.y"
{force -> force [Mz] = yyvsp[0].d;}
break;
case 86:
#line 479 "parser.y"
{constraint->constraint[Tx] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 87:
#line 481 "parser.y"
{constraint->constraint[Ty] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 88:
#line 483 "parser.y"
{constraint->constraint[Tz] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 89:
#line 485 "parser.y"
{constraint->constraint[Rx] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 90:
#line 487 "parser.y"
{constraint->constraint[Ry] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 91:
#line 489 "parser.y"
{constraint->constraint[Rz] = (yyvsp[0].i == 'c' || yyvsp[0].i == 'C');}
break;
case 92:
#line 495 "parser.y"
{
		switch (yyvsp[0].i) {
		case 'x': distributed -> direction = DirX; break;
		case 'y': distributed -> direction = DirY; break;
		case 'z': distributed -> direction = DirZ; break;
		case 'p': distributed -> direction = Perpendicular; break;
		case '|': distributed -> direction = Parallel; break;
		}
	    }
break;
case 93:
#line 507 "parser.y"
{
		int i, size;


		if (distributed == &dummy_distributed)
		    break;

		size = pairptr - pairarray;

		if (!(distributed -> value = Allocate (Pair, size)))
		    Fatal ("unable to allocate memory for pairs");

		UnitOffset (distributed -> value);
		distributed -> nvalues = size;

		for (i = 1; i <= size; i ++)
		    distributed -> value [i] = pairarray [i - 1];
	    }
break;
case 94:
#line 530 "parser.y"
{
		if (element -> numdistributed == 3) {
		    error ("element %d has too many loads", element -> number);
		    break;
		}

		element -> distributed [++ element -> numdistributed] =
							(Distributed) yyvsp[0].s;
	    }
break;
case 95:
#line 541 "parser.y"
{
		element -> distributed [++ element -> numdistributed] =
							(Distributed) yyvsp[0].s;
	    }
break;
case 96:
#line 550 "parser.y"
{
		if (yyvsp[0].i < 0 || yyvsp[0].i > problem.numnodes) {
		    error ("node number %d is illegal (near line %d)", yyvsp[0].i, ln);
		    problem.numerrors ++;
		}

		*intptr ++ = yyvsp[0].i;
	    }
break;
case 97:
#line 560 "parser.y"
{
		if (yyvsp[0].i < 0 || yyvsp[0].i > problem.numnodes) {
		    error ("node number %d is illegal (near line %d)", yyvsp[0].i, ln);
		    problem.numerrors ++;
		}

		intptr = intarray;
		*intptr ++ = yyvsp[0].i;
	    }
break;
case 98:
#line 574 "parser.y"
{
		if (yyvsp[0].p.node < 1 || yyvsp[0].p.node > problem.numnodes) {
		    error ("node number %d is illegal (near line %d)",
			   yyvsp[0].p.node, ln);
		    problem.numerrors ++;
		}

		*pairptr ++ = yyvsp[0].p;
	    }
break;
case 99:
#line 585 "parser.y"
{
		if (yyvsp[0].p.node < 1 || yyvsp[0].p.node > problem.numnodes) {
		    error ("node number %d is illegal (near line %d)",
			   yyvsp[0].p.node, ln);
		    problem.numerrors ++;
		}

		pairptr = pairarray;
		*pairptr ++ = yyvsp[0].p;
	    }
break;
case 100:
#line 600 "parser.y"
{
		yyval.p.node = yyvsp[-2].i;
		yyval.p.magnitude = yyvsp[-1].d;
	    }
break;
case 101:
#line 608 "parser.y"
{yyval.d = yyvsp[-2].d + yyvsp[0].d;}
break;
case 102:
#line 610 "parser.y"
{yyval.d = yyvsp[-2].d - yyvsp[0].d;}
break;
case 103:
#line 612 "parser.y"
{yyval.d = yyvsp[-2].d * yyvsp[0].d;}
break;
case 104:
#line 614 "parser.y"
{yyval.d = yyvsp[0].d ? yyvsp[-2].d / yyvsp[0].d : 0;}
break;
case 105:
#line 616 "parser.y"
{yyval.d = -yyvsp[0].d;}
break;
case 106:
#line 618 "parser.y"
{yyval.d = yyvsp[0].d;}
break;
case 107:
#line 620 "parser.y"
{yyval.d = yyvsp[-1].d;}
break;
case 108:
#line 622 "parser.y"
{yyval.d = sin (yyvsp[-1].d * M_PI / 180);}
break;
case 109:
#line 624 "parser.y"
{yyval.d = cos (yyvsp[-1].d * M_PI / 180);}
break;
case 110:
#line 626 "parser.y"
{yyval.d = tan (yyvsp[-1].d * M_PI / 180);}
break;
case 111:
#line 628 "parser.y"
{yyval.d = yyvsp[0].d;}
break;
case 112:
#line 630 "parser.y"
{yyval.d = yyvsp[0].i;}
break;
#line 1200 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
