/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	problem.h						*
 *									*
 * Description:	This file contains the type and function declarations 	*
 *		which relate to the problem instance.			*
 *									*
 * History:	V1.0 by Jason Gobat and Darren C. Atkinson		*
 ************************************************************************/

# ifndef _PROBLEM_H
# define _PROBLEM_H
# include "fe.h"
# include "Tree.h"

# define MaxNodesPerElement 100

typedef struct {
    char    *title;			/* title of problem		*/
    Node    *nodes;			/* array of nodes		*/
    Element *elements;			/* array of elements		*/
    Tree     node_tree;			/* node tree			*/
    Tree     element_tree;		/* element tree			*/
    Tree     force_tree;		/* force tree			*/
    Tree     material_tree;		/* material tree		*/
    Tree     constraint_tree;		/* constraint tree		*/
    Tree     distributed_tree;		/* distributed load tree	*/
    unsigned numnodes;			/* number of nodes		*/
    unsigned numelements;		/* number of elements		*/
    unsigned line;			/* current line number		*/
    unsigned numerrors;			/* number of errors		*/
} Problem;

extern Problem problem;


# if defined (__STDC__) || defined (__GNUC__)

extern int        yyparse         (void);
extern int        yylex           (void);
extern void       yyerror         (char *);
extern int        node_cmp        (Item, Item);
extern int        element_cmp     (Item, Item);
extern int        material_cmp    (Item, Item);
extern int        force_cmp       (Item, Item);
extern int        constraint_cmp  (Item, Item);
extern int        distributed_cmp (Item, Item);
extern Definition defnlookup      (char *);
extern int        resolvenames    (void);
extern void       RestartLexer    (FILE *);
extern int        GetProblem      (FILE *, Element **, Node **, unsigned *,
                                   unsigned *, char **);

# else

extern int        yyparse         ( );
extern int        yylex           ( );
extern void       yyerror         ( );
extern int        node_cmp        ( );
extern int        element_cmp     ( );
extern int        material_cmp    ( );
extern int        force_cmp       ( );
extern int        constraint_cmp  ( );
extern int        distributed_cmp ( );
extern Definition defnlookup      ( );
extern int        resolvenames    ( );
extern void       RestartLexer    ( );
extern int        GetProblem      ( );

# endif

# endif /* _PROBLEM_H */
