/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/***************************************************************************
*
* File:		forms.h
* 
* Description:	Header information for the all the different widget form 
*		functions.
*
* History:	by Jason Gobat and Darren Atkinson
*
****************************************************************************/

# ifndef _FORMS_H
# define _FORMS_H

	/*
	 * Text forms
	 */

# define TEXT_AND_NUMERIC 1
# define NUMERIC_ONLY     2
# define READ_ONLY	  3

typedef struct {
   unsigned	number;
   struct {
      String	label;
      unsigned  type;
   } info [20];
} EntryRecord;
   
typedef struct {
    Widget   topwidget;
    Widget   shellwidget;
    Widget   formwidget;
    Widget   *labelwidget;
    Widget   *entrywidget;
    Widget   buttonwidget;
} TextEntryForm;

# if defined (__STDC__) || defined (__GNUC__)
    extern TextEntryForm  *CreateTextEntryForm (Widget, EntryRecord);
    extern unsigned GetEntryFormValues (TextEntryForm *, EntryRecord, String *);
    extern void FillTextBuffers  (TextEntryForm *, EntryRecord, String *);
# else
    extern TextEntryForm  *CreateTextEntryForm  ( );
    extern unsigned GetEntryFormValues   ( );
    extern void FillTextBuffers   ( );
# endif

	/*
	 * List forms
	 */

typedef struct {
    Widget   topwidget;
    Widget   shellwidget;
    Widget   formwidget;
    Widget   labelwidget;
    Widget   viewportwidget;
    Widget   listwidget;
    Widget   dialogwidget;
} ListForm;

# if defined (__STDC__) || defined (__GNUC__)
    extern ListForm  *CreateListForm  (Widget, String);
    extern int GetListFormValue   (ListForm *, int);
    extern void SetListItems (ListForm *, String *, int);
# else
    extern ListForm  *CreateListForm  ( );
    extern int GetListFormValue   ( );
    extern void SetListItems ( );
# endif

	/*
	 * Toggle forms
	 */

typedef struct {
   unsigned	number;
   String	entryLabel;
   String	label [20];
} ToggleRecord;
   
typedef struct {
    Widget   topwidget;
    Widget   shellwidget;
    Widget   formwidget;
    Widget   *togglewidget;
    Widget   dialogwidget;
} ToggleForm;

# if defined (__STDC__) || defined (__GNUC__)
    extern ToggleForm  *CreateToggleForm  (Widget, ToggleRecord);
    extern unsigned GetToggleFormValues (ToggleForm *, ToggleRecord, Boolean *, 
                                         String *);
    extern Boolean FlipToggleState (ToggleForm *, unsigned);
    extern void   SetToggleStates (ToggleForm *, ToggleRecord, Boolean *, String);
# else
    extern ToggleForm  *CreateToggleForm  ( );
    extern unsigned GetToggleFormValues   ( );
    extern Boolean FlipToggleState        ( );
    extern void    SetToggleStates        ( );
# endif

# endif
