# ifndef _ELEMENT_H
# define _ELEMENT_H
# include "fe.h"
# include "error.h"

# define trussType 0
extern struct definition trussDefinition;
extern int trussEltStiffness ( );
extern int trussEltStress ( );

# define beamType 1
extern struct definition beamDefinition;
extern int beamEltStiffness ( );
extern int beamEltStress ( );

# define beam3dType 2
extern struct definition beam3dDefinition;
extern int beam3dEltStiffness ( );
extern int beam3dEltStress ( );

# define CSTPlaneStrainType 3
extern struct definition CSTPlaneStrainDefinition;
extern int CSTPlaneStrainEltStiffness ( );
extern int CSTPlaneStrainEltStress ( );

# define CSTPlaneStressType 4
extern struct definition CSTPlaneStressDefinition;
extern int CSTPlaneStressEltStiffness ( );
extern int CSTPlaneStressEltStress ( );

# define iso2d_PlaneStrainType 5
extern struct definition iso2d_PlaneStrainDefinition;
extern int iso2d_PlaneStrainEltStiffness ( );
extern int iso2d_PlaneStrainEltStress ( );

# define iso2d_PlaneStressType 6
extern struct definition iso2d_PlaneStressDefinition;
extern int iso2d_PlaneStressEltStiffness ( );
extern int iso2d_PlaneStressEltStress ( );

# define quad_PlaneStrainType 7
extern struct definition quad_PlaneStrainDefinition;
extern int quad_PlaneStrainEltStiffness ( );
extern int quad_PlaneStrainEltStress ( );

# define quad_PlaneStressType 8
extern struct definition quad_PlaneStressDefinition;
extern int quad_PlaneStressEltStiffness ( );
extern int quad_PlaneStressEltStress ( );

# ifdef ELEMENTS
static struct {
    char      *name;
    int      (*stiffness) ( );
    int      (*stress) ( );
    Definition definition;
} ElementArray [ ] = {
    {"truss", trussEltStiffness, trussEltStress, &trussDefinition},
    {"beam", beamEltStiffness, beamEltStress, &beamDefinition},
    {"beam3d", beam3dEltStiffness, beam3dEltStress, &beam3dDefinition},
    {"CSTPlaneStrain", CSTPlaneStrainEltStiffness, CSTPlaneStrainEltStress, &CSTPlaneStrainDefinition},
    {"CSTPlaneStress", CSTPlaneStressEltStiffness, CSTPlaneStressEltStress, &CSTPlaneStressDefinition},
    {"iso2d_PlaneStrain", iso2d_PlaneStrainEltStiffness, iso2d_PlaneStrainEltStress, &iso2d_PlaneStrainDefinition},
    {"iso2d_PlaneStress", iso2d_PlaneStressEltStiffness, iso2d_PlaneStressEltStress, &iso2d_PlaneStressDefinition},
    {"quad_PlaneStrain", quad_PlaneStrainEltStiffness, quad_PlaneStrainEltStress, &quad_PlaneStrainDefinition},
    {"quad_PlaneStress", quad_PlaneStressEltStiffness, quad_PlaneStressEltStress, &quad_PlaneStressDefinition},
    {0, 0, 0, 0}
};
# endif

# endif /* _ELEMENT_H */
