/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/****************************************************************************
* 
* File:		text.c
* 
* Description:	contains the clipboard functionality for the main edit
*		widget.
*
****************************************************************************/

# include <stdio.h>
# include <string.h>
# include <malloc.h>
# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/AsciiText.h>
# include "procedures.h"
# include "dialog.h"
# include "forms.h"
# include "globals.h"

void SetClipboard ( );

void CopyText ()
{
   XawTextPosition	begin,
			end;
   XawTextPosition	length,total;
   XawTextBlock		block;

   XawTextGetSelectionPos (editwin, &begin, &end);
   if (begin == end)
      return;

   length = end - begin;
   total = XawTextSourceRead (XawTextGetSource(editwin),begin,&block,length);

   SetClipboard (block.ptr, (int) length);
   clipboard_length = length;
}

void PasteText ()
{
   XawTextPosition 	position;	
   XawTextBlock		block;
   int			status;

   if (clipboard_length > 0) {
      position = XawTextGetInsertionPoint (editwin);

      block.ptr = clipboard;
      block.length = clipboard_length;
      block.format = FMT8BIT;
      block.firstPos = 0;

      status = XawTextReplace (editwin, position, position, &block); 
      XawTextSetInsertionPoint (editwin, position + clipboard_length);
   }
}

void CutText ()
{
   XawTextPosition	begin,
			end;
   XawTextPosition	length,total;
   XawTextBlock		block;

   XawTextGetSelectionPos (editwin, &begin, &end);
   if (begin == end)
      return;

   length = end - begin;
   total = XawTextSourceRead (XawTextGetSource(editwin),begin,&block,length);

   SetClipboard (block.ptr, (int) length);
   clipboard_length = length;

   strcpy (block.ptr, "");
   block.length = 0;
   XawTextReplace (editwin, begin, end+1, &block);

   XawTextSetInsertionPoint (editwin, begin);
}

void ZapText ()
{
   XawTextPosition	begin,
			end;
   XawTextBlock		block;

   XawTextGetSelectionPos (editwin, &begin, &end);
   if (begin == end)
      return;

   block.length = 0;
   block.format = FMT8BIT;
   block.firstPos = 0;
   block.ptr = strdup ("");

   XawTextReplace (editwin, begin, end+1, &block);

   XawTextSetInsertionPoint (editwin, begin);
   
   free (block.ptr);
}

void SetClipboard (ptr, length)
   char		*ptr;
   int		length;
{
   if (clipboard == NULL)
      clipboard = (char *) malloc (sizeof(char)*length);
   else {
      free (clipboard);
      clipboard = (char *) malloc (sizeof(char)*length);
   }
      
   if (clipboard == NULL) {
      PopupDialog (error_dialog, "could not allocate clipboard", NULL, NULL);
      return;
   }

   strncpy (clipboard, ptr, (int) length);
}
