/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/***************************************************************************
*
* File:		panel.h
* 
* Description:	Contains header information for all of the action
*		procedure / callback type functions for the main 
*		control panel of the xfelt application.
*
***************************************************************************/

/* the simple functions */

void OpenFile ();
void WriteFeltFile ();
void WriteNamedFile ();
void StartNew ();
void Quit ();
void ExecuteFelt ();
void UpdateLabel ();
void SetFeltOptions ();
void ConfigureXFelt ();
void PrintEditContents ();
void PrintWidgetXWD ();
void SaveWidgetXWD ();
void FlipDrawToggle ();
void CutText ();
void CopyText ();
void PasteText ();
void ZapText ();

void DrawStructure2D ();
void DrawStructure3D ();
