/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		globals.h
*
* Description:	This file contains various global information for
*		the velvet routines.
*
*************************************************************************/

# ifndef _GLOBALS_H
# define _GLOBALS_H

# define Float2Arg(x)     (*((XtArgVal *) &(x)))

/* Global widgets */

extern XtAppContext app_context;

extern Widget toplevel;
extern Widget form;
extern Widget control;
extern Widget editwin;
extern Widget outputShell;
extern Widget outputwin;
extern Widget drawingShell;
extern Widget drawing;

extern Pixmap question;
extern Pixmap computer;
extern Pixmap truss;
	      


/* Global dialogs */

extern Dialog *proceed_dialog;
extern Dialog *error_dialog;
extern Dialog *info_dialog;
extern Dialog *file_dialog;
extern Dialog *qsave_dialog;


extern ToggleForm    *option_form;
extern TextEntryForm *setup_form;

extern Boolean    nocpp;
extern Boolean    material;
extern Boolean    draw2d;
extern Boolean	  draw3d;

extern String filename;

/* the commands to execute for various user functions */

extern String felt_command;
extern String lp_command;
extern String lp_graphics;
extern String xpr_command;

extern char            *clipboard;
extern XawTextPosition clipboard_length;

/* Unique ids for each menu item on the control panel */

typedef enum {
   Load, Save, SaveAs, Print, New, Exit, Configure,
   Cut, Copy, Paste, 
   Info, Options, Run
} PanelId;


typedef struct {
    char	*name;
    WidgetClass *class;
    Cardinal	 numentries;
    struct {
	char	*name;
	PanelId  id;
	Widget	 widget;
    } menuentry [6];
    Widget 	 button;
    Widget	 menu;
} Panel;

# endif
