/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*****************************************************************************
 *
 * File:	output.c
 *
 ****************************************************************************/

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Xaw/AsciiText.h>
# include <X11/Xaw/Form.h>
# include <X11/Xaw/Label.h>
# include <X11/Xaw/Dialog.h>
# include <X11/Xaw/Viewport.h>
# include <X11/Shell.h>
# include "dialog.h"
# include "forms.h"
# include "fe.h"
# include "Tree.h"
# include "globals.h"
# include "procedures.h"
 
static unsigned OkayButton  = 1;
static unsigned SaveButton  = 2;

static void OutputButtonActions ();
static void InfoButtonActions ();

static char info_translations [ ] =
   "<Btn1Down>:	  DoNothing()\n\
    <Btn1Up>:     DoNothing()\n\
    <Btn1Motion>: DoNothing()\n\
    <Btn2Down>:   DoNothing()\n\
    <Btn3Up>:     DoNothing()\n\
    <Btn3Motion>: DoNothing()\n\
    <Btn3Down>:   DoNothing()";

Widget CreateOutputShell ()
{
   Arg	        arglist[10];
   Cardinal     count;
   Widget       formwidget,
		buttonwidget;

   outputShell   = XtCreatePopupShell
                ("outputShell", transientShellWidgetClass, toplevel, NULL, 0);

   formwidget    = XtCreateManagedWidget
                ("form", formWidgetClass, outputShell, NULL, 0);

   count = 0;
   XtSetArg (arglist [count], XtNeditType, XawtextEdit); count++;
   XtSetArg (arglist [count], XtNtype, XawAsciiFile); count++;
   outputwin     = XtCreateManagedWidget
                ("outputwin", asciiTextWidgetClass, formwidget, arglist, count);

   XawTextDisplayCaret (outputwin, False);

   count = 0;
   XtSetArg (arglist [count], XtNlabel, ""); count++;
   XtSetArg (arglist [count], XtNborderWidth, 0); count++;
   XtSetArg (arglist [count], XtNtop, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNbottom, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNleft, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNright, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNfromVert, outputwin); count++;

   buttonwidget  = XtCreateManagedWidget 
                ("buttons", dialogWidgetClass, formwidget, arglist, count); 

   XawDialogAddButton (buttonwidget, "okay", OutputButtonActions,&OkayButton);
   XawDialogAddButton (buttonwidget, "save", OutputButtonActions,&SaveButton);

   	/*
	 * This is a kludge because the stupid widget won't initialize
	 * as read-only with no file specified, so we'll just send all
	 * keyboard input from this widget into the dialog widget.
	 */

   XtSetKeyboardFocus (formwidget, buttonwidget);

   return outputShell;
}

void CreateInformationShell (shell,shell_name,edit,window_name,popped)
   Widget	*shell;
   Widget	*edit;
   String	shell_name;
   String	window_name;
   Boolean     *popped;
{
   Arg	        arglist[10];
   Cardinal     count;
   Widget       formwidget,
		buttonwidget;
  
   *shell   = XtCreatePopupShell
                (shell_name, transientShellWidgetClass, toplevel, NULL, 0);

   formwidget    = XtCreateManagedWidget
                ("form", formWidgetClass, *shell, NULL, 0);

   count = 0;
   XtSetArg (arglist [count], XtNeditType, XawtextRead); count++;
   XtSetArg (arglist [count], XtNresize, XawtextResizeBoth); count++;
   XtSetArg (arglist [count], XtNbottom, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNtop, XawChainTop); count++;
   XtSetArg (arglist [count], XtNtype, XawAsciiString); count++;
   *edit     = XtCreateManagedWidget
                (window_name, asciiTextWidgetClass, formwidget, arglist, count);

   XawTextDisplayCaret (*edit, False);

   XtOverrideTranslations (*edit, XtParseTranslationTable (info_translations));
   count = 0;
   XtSetArg (arglist [count], XtNlabel, ""); count++;
   XtSetArg (arglist [count], XtNborderWidth, 0); count++;
   XtSetArg (arglist [count], XtNtop, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNbottom, XawChainBottom); count++;
   XtSetArg (arglist [count], XtNleft, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNright, XawChainLeft); count++;
   XtSetArg (arglist [count], XtNfromVert, *edit); count++;

   buttonwidget  = XtCreateManagedWidget 
                ("buttons", dialogWidgetClass, formwidget, arglist, count); 

   XawDialogAddButton (buttonwidget, "okay",InfoButtonActions,shell);
}

void UpdateOutputWindow (output)
   char		*output;
{
   Arg		arglist [1];

   XtSetArg (arglist [0], XtNstring, output);
   XtSetValues (outputwin, arglist, 1);

   XtPopup (outputShell, XtGrabNone);
}

static void OutputButtonActions (w, client_data, call_data)
   Widget 	w;
   XtPointer	client_data,
		call_data;
{
   unsigned    selected = *(unsigned *) client_data;
 
   unsigned    dialog_status;
   String      ans;

   if (selected == OkayButton) 
      XtPopdown (outputShell); 

   else if (selected == SaveButton) {
      SetShellTitle (file_dialog -> shellwidget, "Save Output");
      dialog_status = PopupDialog (file_dialog, "Save as:", "", &ans);
      if (dialog_status == Okay && ans != NULL) 
         XawAsciiSaveAsFile (XawTextGetSource (outputwin),  ans);
   }
}

static void InfoButtonActions (w, client_data, call_data)
   Widget	w;
   XtPointer	client_data,
		call_data;
{
   Widget	shell = *(Widget *) client_data;

   XtPopdown (shell);
   XtUnrealizeWidget (shell);
}
