/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		globals.c
*
* Description:	Contains declarations for the uninitialized global
*		variables
*
**************************************************************************/

# include <X11/Intrinsic.h>
# include "fe.h"
# include "dialog.h"
# include "forms.h"

/* Global widgets */

XtAppContext app_context;

Widget bottom;
Widget control;
Widget coord;
Widget drawing;
Widget entry;
Widget form;
Widget status;
Widget toplevel;
Widget viewport;
Widget abortbutton;
Widget quitbutton;

Widget outputShell;
Widget outputwin;
Widget nodeShell;
Widget nodewin;
Widget elementShell;
Widget elementwin;

Pixmap checkmark;
Pixmap question;
Pixmap menu16;
Pixmap truss;

/* Global dialogs */

Dialog *proceed_dialog;
Dialog *error_dialog;
Dialog *info_dialog;
Dialog *file_dialog;
Dialog *qsave_dialog;


/* Global value forms */

TextEntryForm *force_form;
TextEntryForm *material_form;
TextEntryForm *canvas_form;
TextEntryForm *config_form;
TextEntryForm *load_form;
TextEntryForm *node_form;
TextEntryForm *element_form;
TextEntryForm *trimesh_form;

ToggleForm    *constraint_form;
ListForm      *material_list;
ListForm      *element_list;
ListForm      *force_list;
ListForm      *constraint_list;
ListForm      *load_list;


/* Strings to store the current configuration */

String	elt_color;
String 	node_color;
String 	label_font;
String	tool_color;
String	text_font;


/* Actual finite element stuff */

Node	  *node = NULL;
unsigned  numnodes = 0;
Element	  *element = NULL;
unsigned  numelts = 0;

char filename [2048] = {""};
String title = NULL;

Node displayed_node = NULL;
Node displayed_element = NULL;

String *material_names = NULL;
Material active_material = NULL;
int active_material_number = -1;

String *constraint_names = NULL;
Constraint active_constraint = NULL;
int active_constraint_number = -1;

String *force_names = NULL;
Force active_force = NULL;
int active_force_number = -1;

String *distributed_names = NULL;
Distributed active_distributed = NULL;
int active_distributed_number = -1;

Definition active_definition = NULL;
int active_definition_number = -1;

Boolean sensitive_menus = True;
