/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*************************************************************************
*
* File:		definitions.h
*
* Description:	contains information to describe the gui for velvet
*		(menu members, buttons, forms, etc.)
*
* Note:		This isn't exactly the traditional way to organize
*		all this stuff, but it keeps velvet.c from getting
*		way out of hand.  This file should ONLY be included
*		by velvet.c (essentially, it's a part of that file, not
*		a traditional header file).
*
**************************************************************************/

# ifndef _DEFINITIONS_H
# define _DEFINITIONS_H

/* The control panel */

Panel panel [ ] = {
    {"nodes",	    &menuButtonWidgetClass, 2,
	{{"add", AddNode}, {"delete", DeleteNode}}},

    {"elements",    &menuButtonWidgetClass, 4,
	{{"add", AddElt}, {"delete", DeleteElt},
        {"set_type", SetType}, {"generate", Generate}}},

    {"materials",   &menuButtonWidgetClass, 6,
	{{"define", DefMaterial}, {"set_active", SetMaterial},
	{"edit", EditMaterial}, {"delete", DelMaterial},
	{"open", OpenMaterial}, {"save_to", SaveMaterial}}},

    {"forces",	    &menuButtonWidgetClass, 5,
	{{"define", DefForce}, {"set_active", SetForce},
	{"edit", EditForce}, {"delete", DelForce}, {"apply", ApplyForce}}},

    {"loads",	    &menuButtonWidgetClass, 5,
	{{"define", DefLoad}, {"set_active", SetLoad},
	{"edit", EditLoad}, {"delete", DelLoad}, {"apply", ApplyLoad}}},

    {"constraints", &menuButtonWidgetClass, 5,
	{{"define", DefConstraint}, {"set_active", SetConstraint},
	{"edit", EditConstraint}, {"delete", DelConstraint},
	{"apply", ApplyConstraint}}},

    {"problem",	    &menuButtonWidgetClass, 8,
        {{"solve", Solve}, {"define", Define},
	{"new", NewId}, {"open", Open}, {"save", Save}, {"save_as", SaveAs},
	{"restore", Restore}, {"exit", Exit}}},

    {"canvas",	    &menuButtonWidgetClass, 8,
	{{"parameters", Parameters}, {"zoomOut", ZoomOut}, {"zoomIn", ZoomIn}, 
        {"configure", Configure}, {"save_xwd", SaveXWD},
        {"numbering", NumbersOnOff},  {"snap", SnapOnOff}, 
        {"grid", GridOnOff}}},

    {"tools",	    &menuButtonWidgetClass, 7,
	{{"line", LineTool}, {"circle", Circle}, {"arc", Arc},
	{"rectangle", Rectangle}, {"polygon",Polygon}, 
        {"text",Text},{"delete",DeleteTool}}},

    {"info",	    &commandWidgetClass, 0, {{"", Info}}},

    {"spacer",	    &labelWidgetClass,   0},

};

/* 
 * The format of these are simple, the command as it would be typed
 * and a PanelId for the appropriate action.
 */

TextCommand commands [ ] = {
   {"add node", AddNode},
   {"delete node", DeleteNode},
   {"edit node", EditNode},
   {"move node", MoveNodeId},

   {"add element", AddElt},
   {"delete element", DeleteElt},
   {"set element", SetType}, {"set element type", SetType}, {"set type", SetType},
   {"generate", Generate},
   {"edit element", EditElement},

   {"define material", DefMaterial},
   {"set material", SetMaterial}, {"set active material", SetMaterial},
   {"edit material", EditMaterial},
   {"delete material", DelMaterial},
   {"open database", OpenMaterial},
   {"save database", SaveMaterial}, {"update database", SaveMaterial},

   {"define force", DefForce},
   {"set force", SetForce}, {"set active force", SetForce},
   {"edit force", EditForce},
   {"delete force", DelForce},
   {"apply force", ApplyForce},

   {"define load", DefLoad},
   {"set load", SetLoad}, {"set active load", SetLoad},
   {"edit load", EditLoad},
   {"delete load", DelLoad},
   {"apply load", ApplyLoad},

   {"define constraint",DefConstraint},
   {"set constraint", SetConstraint}, {"set active constraint", SetConstraint},
   {"edit constraint", EditConstraint},
   {"delete constraint", DelConstraint},
   {"apply constraint", ApplyConstraint},

   {"solve", Solve},
   {"define", Define},
   {"new", NewId},
   {"open", Open}, {"load", Open},
   {"save", Save},
   {"save as", SaveAs},
   {"restore", Restore},
   {"exit", Exit}, {"quit", Exit},

   {"parameters", Parameters},
   {"zoom all", ZoomOut}, {"zoom out", ZoomOut},
   {"zoom", ZoomIn}, {"zoom window", ZoomIn},
   {"configure", Configure},
   {"dump", SaveXWD},
   {"numbers", NumbersOnOff},
   {"snap", SnapOnOff},
   {"grid", GridOnOff},

   {"draw line" ,LineTool},
   {"draw rectangle", Rectangle},
   {"draw circle", Circle},
   {"draw arc", Arc},
   {"draw polygon", Polygon},
   {"draw text", Text},
   {"delete figure", DeleteTool}, {"delete tool", DeleteTool},

   {"dummy", -1},
};


/* 
 * The default translations.  For the keyboard shortcuts to menu entries
 * I call ActionToPanelConverter with the menuentry name (not the PanelId)
 * of the appropriate action, because I have to pass it as a string.
 */

char default_translations [ ] = 
   "Meta<Key>q:     ActionToPanelConverter(exit)\n\
    Meta<Key>x:     ActionToPanelConverter(exit)\n\
    Meta<Key>s:     ActionToPanelConverter(snap)\n\
    Meta<Key>g:     ActionToPanelConverter(grid)\n\
    Meta<Key>n:     ActionToPanelConverter(numbering)\n\
    Ctrl<Key>c:     AbortEdit()\n\
    <Key>Escape:    QuitEdit()\n\
    <Key>Return:    ParseEntryLine()"; 

/* and some actions to go along with them */

XtActionsRec actiontable [ ] = {
   {"ParseEntryLine", ParseEntryLine},
   {"QuitEdit", QuitEdit},
   {"AbortEdit", AbortEdit},
   {"AbortAddElement", AbortAddElement},
   {"QuitMoveNode", QuitMoveNode},
   {"DoNothing", DoNothing},
   {"AddNodeAP", AddNodeAP},
   {"EditNodeAP", EditNodeAP},
   {"MoveNodeAP", MoveNodeAP},
   {"WalkNodeAP", WalkNodeAP},
   {"DeleteNodeAP", DeleteNodeAP},
   {"AddElementAP", AddElementAP},
   {"DeleteEltAP", DeleteEltAP},
   {"EditElementAP", EditElementAP},
   {"ApplyForceAP", ApplyForceAP},
   {"ApplyLoadAP", ApplyLoadAP},
   {"ApplyConstraintAP", ApplyConstraintAP},
   {"DoRectangleAP", DoRectangleAP},
   {"DoCircleAP", DoCircleAP},
   {"DoLineAP", DoLineAP},
   {"DoTextAP", DoTextAP},
   {"ZoomAP", ZoomAP},
   {"GridAP", GridAP},
   {"FinishCurve", FinishCurve},
   {"AbortTriMesh", AbortTriMesh},
   {"AddCurvePointAP", AddCurvePointAP},
   {"BackupOnePoint", BackupOnePoint},
   {"ActionToPanelConverter", ActionToPanelConverter},
   {"DeleteGroupAP", DeleteGroupAP},
};


/* Information for the text entry forms */

EntryRecord force_entries = {
   7, {{"Name",TEXT_AND_NUMERIC},
       {"ForceX",NUMERIC_ONLY},
       {"ForceY",NUMERIC_ONLY},
       {"ForceZ",NUMERIC_ONLY},
       {"MomentX",NUMERIC_ONLY},
       {"MomentY",NUMERIC_ONLY},
       {"MomentZ",NUMERIC_ONLY}}
};

EntryRecord load_entries = {
   4, {{"Name",TEXT_AND_NUMERIC},
       {"Direction",TEXT_AND_NUMERIC},
       {"Node & Magnitude (1)",TEXT_AND_NUMERIC},
       {"Node & Magnitude (2)",TEXT_AND_NUMERIC}}
};

EntryRecord material_entries = {
   12, {{"Name",TEXT_AND_NUMERIC},
        {"E",NUMERIC_ONLY},
        {"A",NUMERIC_ONLY},
        {"Ix",NUMERIC_ONLY},
        {"Iy",NUMERIC_ONLY},
        {"Iz",NUMERIC_ONLY},
        {"J",NUMERIC_ONLY},
        {"G",NUMERIC_ONLY},
        {"nu",NUMERIC_ONLY},
	{"kappa",NUMERIC_ONLY},
        {"t",NUMERIC_ONLY},
        {"rho",NUMERIC_ONLY}}
};


EntryRecord canvas_entries = {
   6, {{"x - minimum", NUMERIC_ONLY},
       {"x - maximum", NUMERIC_ONLY},
       {"y - minimum", NUMERIC_ONLY},
       {"y - maximum", NUMERIC_ONLY},
       {"grid size", NUMERIC_ONLY},
       {"snap size", NUMERIC_ONLY}}
};


EntryRecord config_entries = {
   5, {{"element color", TEXT_AND_NUMERIC},
       {"node color", TEXT_AND_NUMERIC},
       {"label font", TEXT_AND_NUMERIC},
       {"tool color", TEXT_AND_NUMERIC},
       {"tool font", TEXT_AND_NUMERIC}}
};    


EntryRecord node_entries = {
   6, {{"Number", NUMERIC_ONLY},
       {"Force", TEXT_AND_NUMERIC},
       {"Constraint", TEXT_AND_NUMERIC},
       {"X", NUMERIC_ONLY},
       {"Y", NUMERIC_ONLY},
       {"Z", READ_ONLY}}
};


EntryRecord element_entries = {
   7, {{"Number", NUMERIC_ONLY},
       {"Type",  READ_ONLY},
       {"Nodes", TEXT_AND_NUMERIC},
       {"Material", TEXT_AND_NUMERIC},
       {"Load 1", TEXT_AND_NUMERIC},
       {"Load 2", TEXT_AND_NUMERIC},
       {"Load 3", TEXT_AND_NUMERIC}}
};


EntryRecord trimesh_entries = {
   8, {{"tolin", NUMERIC_ONLY},
       {"angspc", NUMERIC_ONLY},
       {"angtol", NUMERIC_ONLY},
       {"dmin", NUMERIC_ONLY},
       {"kappa", NUMERIC_ONLY},
       {"min", NUMERIC_ONLY},
       {"max", NUMERIC_ONLY},
       {"numholes", NUMERIC_ONLY}}
};


/* Information for the constraint toggles */

ToggleRecord constraint_entries = {
   6, "Constraint name:", {"Tx","Ty","Tz","Rx","Ry","Rz"}
};


# endif
