/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	error.c							*
 *									*
 * Description:	This file contains the error handling routines.		*
 *									*
 * History:	V1.0 by Jason Gobat and Darren C. Atkinson		*
 ************************************************************************/

# include <stdio.h>
# include <varargs.h>
# include "error.h"


/************************************************************************
 * Function:	 error							*
 *									*
 * Parameters:	 error message						*
 *									*
 * Return value: none							*
 *									*
 * Calls:	 none							*
 *									*
 * Called by:	 other routines						*
 *									*
 * Global data:	 none							*
 *									*
 * Description:	 Error prints the error message specified as a format	*
 *		 string and arguments to standard error.		*
 ************************************************************************/

/* VARARGS */
void error (va_alist)
    va_dcl
{
    char   *format;
    va_list ap;

    va_start (ap);
    format = va_arg (ap, char *);
    fprintf (stderr, "felt: ");
    vfprintf (stderr, format, ap);
    fprintf (stderr, "\n");
    va_end (ap);
}


/************************************************************************
 * Function:	 Fatal							*
 *									*
 * Parameters:	 error message						*
 *									*
 * Return value: none							*
 *									*
 * Calls:	 none							*
 *									*
 * Called by:	 other routines						*
 *									*
 * Global data:	 none							*
 *									*
 * Description:	 Fatal prints the error message specified as a format	*
 *		 string and arguments to standard error and exits the	*
 *		 program.						*
 ************************************************************************/

/* VARARGS */
void Fatal (va_alist)
    va_dcl
{
    char   *format;
    va_list ap;

    va_start (ap);
    format = va_arg (ap, char *);
    fprintf (stderr, "felt: ");
    vfprintf (stderr, format, ap);
    fprintf (stderr, "\n");
    va_end (ap);
    exit (1);
}
