#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "parser.y"
/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	parser.y						*
 *									*
 * Description:	This file contains the yacc specification for the	*
 *		input file parser.					*
 ************************************************************************/

# include <stdio.h>
# include <string.h>
# include <math.h>
# include "generator.h"
# include "allocate.h"
# include "error.h"

# define ln generator.line

static Line		  line;			/* current line		    */
static Grid		  grid;			/* current grid	   	    */
static TriMesh		  trimesh;		/* current triangle mesh    */
static Curve		  hole;			/* current hole	    	    */
static Curve	  	  boundary;		/* current boundary         */
static int		  numholes;		/* current # of holes	    */
static int		  nhpts;		/* number of hole points    */
static int		  nbpts;	        /* number of boundary pts   */
static int		  nlines;
static int		  ngrids;
static int		  ntrimeshes;
static int		  maxnbpts;
static int		  maxnhpts;
static int		  i;
#line 53 "parser.y"
typedef union {
    char   *s;
    double  d;
    int	    i;
    GPair   p;
    Triplet t;
} YYSTYPE;
#line 64 "y.tab.c"
#define UNARY 257
#define DOUBLE 258
#define INTEGER 259
#define STRING 260
#define BOLINTEGER 261
#define BOLSTRING 262
#define PROBLEM 263
#define LINES 264
#define GRIDS 265
#define TRIANGLE 266
#define BOUNDARY 267
#define HOLE 268
#define END 269
#define LINES_EQ 270
#define GRIDS_EQ 271
#define TRIANGLES_EQ 272
#define HOLES_EQ 273
#define RULE_EQ 274
#define TOLIN_EQ 275
#define ANGSPC_EQ 276
#define ANGTOL_EQ 277
#define KAPPA_EQ 278
#define DMIN_EQ 279
#define MIN_EQ 280
#define MAX_EQ 281
#define XNUMBER_EQ 282
#define YNUMBER_EQ 283
#define ZNUMBER_EQ 284
#define NUMBER_EQ 285
#define FIRST_EQ 286
#define LAST_EQ 287
#define X_EQ 288
#define Y_EQ 289
#define Z_EQ 290
#define SIN 291
#define COS 292
#define TAN 293
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    4,    6,    6,    7,    7,    7,    5,    5,    8,
    8,    8,    9,    9,   10,   10,   11,   11,   16,   12,
   12,   18,   13,   13,   20,   14,   14,   15,   15,   17,
   17,   19,   19,   21,   21,   21,   21,   22,   22,   22,
   22,   22,   23,   23,   23,   23,   23,   23,   23,   23,
    2,    3,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,
};
short yylen[] = {                                         2,
    3,    2,    2,    0,    2,    2,    2,    2,    0,    2,
    2,    2,    2,    0,    2,    0,    2,    0,    0,    3,
    1,    0,    3,    1,    0,    3,    1,    2,    0,    2,
    0,    2,    0,    2,    2,    2,    1,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    4,    7,    3,    3,    3,    3,    2,    2,    3,    4,
    4,    4,    1,    1,
};
short yydefred[] = {                                      0,
    4,    0,    9,    0,    0,    0,    0,    0,    3,   14,
   16,   18,    1,    8,    5,    6,    7,    0,    0,    0,
   21,   19,   13,   24,   22,   15,   27,   25,   17,   29,
   31,   33,    0,    0,    0,   37,    0,    0,    0,   28,
    0,    0,    0,    0,    0,   30,    0,    0,    0,    0,
    0,    0,    0,    0,   32,   36,    0,   34,   35,   40,
   41,   42,   38,   39,   50,    0,    0,   63,   64,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   49,   48,
    0,   58,   57,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   59,    0,    0,   55,   56,
    0,   60,   61,   62,    0,    0,   52,
};
short yydgoto[] = {                                       2,
   74,    0,   58,    3,    5,    4,    9,   14,   18,   19,
   20,   23,   26,   29,   33,   30,   34,   31,   35,   32,
   40,   46,   55,
};
short yysindex[] = {                                   -262,
    0,    0,    0,   33, -130, -257, -255, -252,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -240, -212, -190,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -254, -225,  -70,    0, -244,    2,    2,    0,
 -203, -189, -186,    2,    2,    0, -171,  -40,  -40,  -40,
  -40,  -40, -163, -160,    0,    0,  -40,    0,    0,    0,
    0,    0,    0,    0,    0,  -40,  -40,    0,    0,   29,
   78,   81,  -40,   50,   50,   50,   50,   50,    0,    0,
   40,    0,    0,  -40,  -40,  -40,   -2,  -40,  -40,  -40,
  -40,  -40,  234,  241,  248,    0,   72,   72,    0,    0,
   66,    0,    0,    0,  -40,  255,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0, -104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -77,  -52,  -42,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -239,  -71,  -65,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -201, -175, -149, -123,  -97,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -35,   -7,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
  -38,    0,  -21,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,
};
#define YYTABLESIZE 305
short yytable[] = {                                      73,
    1,   15,   66,   16,   67,   53,   17,   53,   53,   53,
   75,   76,   77,   78,   56,   21,   20,   59,   81,   36,
   22,   20,   63,   64,   20,   20,   20,   82,   83,   20,
   37,   38,   39,   54,   87,   54,   54,   54,   96,   90,
   88,   57,   89,   24,   91,   93,   94,   95,   25,   97,
   98,   99,  100,  101,   43,   60,   41,   42,   43,   43,
   44,   45,   43,   43,   43,   27,  106,   43,   84,   61,
   28,   43,   62,   43,   43,   43,   43,   43,   43,   43,
   44,   90,   88,   92,   89,   44,   91,   65,   44,   44,
   44,   90,   88,   44,   89,   79,   91,   44,   80,   44,
   44,   44,   44,   44,   44,   44,   45,   90,   88,  105,
   89,   45,   91,   90,   45,   45,   45,   85,   91,   45,
   86,    0,    0,   45,    0,   45,   45,   45,   45,   45,
   45,   45,   46,   10,   11,   12,    0,   46,   13,    0,
   46,   46,   46,    0,    0,   46,    0,    0,    0,   46,
    0,   46,   46,   46,   46,   46,   46,   46,   47,    2,
    2,    2,    0,   47,    2,    0,   47,   47,   47,    0,
    0,   47,    0,    0,    0,   47,    0,   47,   47,   47,
   47,   47,   47,   47,   23,    0,   10,   10,   10,   23,
   26,   10,   23,   23,   23,   26,    0,   23,   26,   26,
   26,    0,   47,   26,   48,   49,   50,   51,   52,   53,
   54,   11,   11,   11,    0,    0,   11,   68,   69,    0,
   53,   12,   12,   12,    0,   53,   12,    0,   53,   53,
   53,    0,    0,   53,    0,    0,    0,   53,    0,   53,
   53,   53,   53,   53,   53,   53,    0,    0,   54,    0,
   70,   71,   72,   54,    0,    0,   54,   54,   54,    0,
    0,   54,    0,    0,    0,   54,    0,   54,   54,   54,
   54,   54,   54,   54,  102,   90,   88,    0,   89,    0,
   91,  103,   90,   88,    0,   89,    0,   91,  104,   90,
   88,    0,   89,    0,   91,  107,   90,   88,    0,   89,
    0,   91,    6,    7,    8,
};
short yycheck[] = {                                      40,
  263,  259,   43,  259,   45,   41,  259,   43,   44,   45,
   49,   50,   51,   52,  259,  256,  256,   39,   57,  274,
  261,  261,   44,   45,  264,  265,  266,   66,   67,  269,
  285,  286,  287,   41,   73,   43,   44,   45,   41,   42,
   43,   40,   45,  256,   47,   84,   85,   86,  261,   88,
   89,   90,   91,   92,  256,  259,  282,  283,  284,  261,
  286,  287,  264,  265,  266,  256,  105,  269,   40,  259,
  261,  273,  259,  275,  276,  277,  278,  279,  280,  281,
  256,   42,   43,   44,   45,  261,   47,  259,  264,  265,
  266,   42,   43,  269,   45,  259,   47,  273,  259,  275,
  276,  277,  278,  279,  280,  281,  256,   42,   43,   44,
   45,  261,   47,   42,  264,  265,  266,   40,   47,  269,
   40,   -1,   -1,  273,   -1,  275,  276,  277,  278,  279,
  280,  281,  256,  264,  265,  266,   -1,  261,  269,   -1,
  264,  265,  266,   -1,   -1,  269,   -1,   -1,   -1,  273,
   -1,  275,  276,  277,  278,  279,  280,  281,  256,  264,
  265,  266,   -1,  261,  269,   -1,  264,  265,  266,   -1,
   -1,  269,   -1,   -1,   -1,  273,   -1,  275,  276,  277,
  278,  279,  280,  281,  256,   -1,  264,  265,  266,  261,
  256,  269,  264,  265,  266,  261,   -1,  269,  264,  265,
  266,   -1,  273,  269,  275,  276,  277,  278,  279,  280,
  281,  264,  265,  266,   -1,   -1,  269,  258,  259,   -1,
  256,  264,  265,  266,   -1,  261,  269,   -1,  264,  265,
  266,   -1,   -1,  269,   -1,   -1,   -1,  273,   -1,  275,
  276,  277,  278,  279,  280,  281,   -1,   -1,  256,   -1,
  291,  292,  293,  261,   -1,   -1,  264,  265,  266,   -1,
   -1,  269,   -1,   -1,   -1,  273,   -1,  275,  276,  277,
  278,  279,  280,  281,   41,   42,   43,   -1,   45,   -1,
   47,   41,   42,   43,   -1,   45,   -1,   47,   41,   42,
   43,   -1,   45,   -1,   47,   41,   42,   43,   -1,   45,
   -1,   47,  270,  271,  272,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 293
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"UNARY","DOUBLE","INTEGER","STRING","BOLINTEGER","BOLSTRING","PROBLEM","LINES",
"GRIDS","TRIANGLE","BOUNDARY","HOLE","END","LINES_EQ","GRIDS_EQ","TRIANGLES_EQ",
"HOLES_EQ","RULE_EQ","TOLIN_EQ","ANGSPC_EQ","ANGTOL_EQ","KAPPA_EQ","DMIN_EQ",
"MIN_EQ","MAX_EQ","XNUMBER_EQ","YNUMBER_EQ","ZNUMBER_EQ","NUMBER_EQ","FIRST_EQ",
"LAST_EQ","X_EQ","Y_EQ","Z_EQ","SIN","COS","TAN",
};
char *yyrule[] = {
"$accept : specification",
"specification : description definition_list END",
"description : PROBLEM info_list",
"info_list : info_list info",
"info_list :",
"info : LINES_EQ INTEGER",
"info : GRIDS_EQ INTEGER",
"info : TRIANGLES_EQ INTEGER",
"definition_list : definition_list definition",
"definition_list :",
"definition : LINES line_list",
"definition : GRIDS grid_list",
"definition : TRIANGLE triangle_list",
"line_list : line_list line",
"line_list :",
"grid_list : grid_list grid",
"grid_list :",
"triangle_list : triangle_list triangle",
"triangle_list :",
"$$1 :",
"line : BOLINTEGER $$1 line_arg_list",
"line : error",
"$$2 :",
"grid : BOLINTEGER $$2 grid_arg_list",
"grid : error",
"$$3 :",
"triangle : BOLINTEGER $$3 triangle_arg_list",
"triangle : error",
"line_arg_list : line_arg_list line_arg",
"line_arg_list :",
"grid_arg_list : grid_arg_list grid_arg",
"grid_arg_list :",
"triangle_arg_list : triangle_arg_list triangle_arg",
"triangle_arg_list :",
"line_arg : FIRST_EQ triplet",
"line_arg : LAST_EQ triplet",
"line_arg : NUMBER_EQ INTEGER",
"line_arg : RULE_EQ",
"grid_arg : FIRST_EQ triplet",
"grid_arg : LAST_EQ triplet",
"grid_arg : XNUMBER_EQ INTEGER",
"grid_arg : YNUMBER_EQ INTEGER",
"grid_arg : ZNUMBER_EQ INTEGER",
"triangle_arg : TOLIN_EQ expression",
"triangle_arg : ANGSPC_EQ expression",
"triangle_arg : ANGTOL_EQ expression",
"triangle_arg : KAPPA_EQ expression",
"triangle_arg : DMIN_EQ expression",
"triangle_arg : MAX_EQ INTEGER",
"triangle_arg : MIN_EQ INTEGER",
"triangle_arg : HOLES_EQ INTEGER",
"gpair : expression ',' expression ','",
"triplet : '(' expression ',' expression ',' expression ')'",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '-' expression",
"expression : '+' expression",
"expression : '(' expression ')'",
"expression : SIN '(' expression ')'",
"expression : COS '(' expression ')'",
"expression : TAN '(' expression ')'",
"expression : DOUBLE",
"expression : INTEGER",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 83 "parser.y"
{
		if (generator.numerrors) {
		    error ("%d error(s) found in input", generator.numerrors);
		    return generator.numerrors;
		}
	    }
break;
case 2:
#line 94 "parser.y"
{
			trimesh = NULL;	
			nlines = 0;
  			ngrids = 0;
			ntrimeshes = 0;
			maxnbpts = 50;
			maxnhpts = 30;
		}
break;
case 5:
#line 110 "parser.y"
{
				   generator.numlines = yyvsp[0].i;
 				   if (yyvsp[0].i != 0)
				      generator.lines = Allocate (Line, yyvsp[0].i);
				}
break;
case 6:
#line 116 "parser.y"
{
				   generator.numgrids = yyvsp[0].i;
 				   if (yyvsp[0].i != 0)
				       generator.grids = Allocate (Grid, yyvsp[0].i);
				}
break;
case 7:
#line 122 "parser.y"
{
				   generator.numtrimeshes = yyvsp[0].i;
 				   if (yyvsp[0].i != 0)
				      generator.tris = Allocate (TriMesh, yyvsp[0].i);
				}
break;
case 19:
#line 162 "parser.y"
{

		line = Allocate (struct _line, 1);
                generator.lines [nlines++] = line;

	    }
break;
case 22:
#line 175 "parser.y"
{

		grid = Allocate (struct _grid, 1);
                generator.grids [ngrids++] = grid;

	    }
break;
case 25:
#line 188 "parser.y"
{

		trimesh = Allocate (struct _trimesh, 1);
                generator.tris [ntrimeshes++] = trimesh;
                numholes = 0;

	    }
break;
case 34:
#line 218 "parser.y"
{line -> xs = yyvsp[0].t.x;
			     line -> ys = yyvsp[0].t.y;
			     line -> zs = yyvsp[0].t.z;}
break;
case 35:
#line 222 "parser.y"
{line -> xe = yyvsp[0].t.x;
			     line -> ye = yyvsp[0].t.y;
			     line -> ze = yyvsp[0].t.z;}
break;
case 36:
#line 227 "parser.y"
{line -> number = yyvsp[0].i;}
break;
case 37:
#line 230 "parser.y"
{
		switch (yyvsp[0].i) {
		case 'o': line -> rule = LOG; break;
		case 'i': line -> rule = LINEAR; break;
		}
	    }
break;
case 38:
#line 241 "parser.y"
{grid -> xs = yyvsp[0].t.x;
		             grid -> ys = yyvsp[0].t.y;
			     grid -> zs = yyvsp[0].t.z;}
break;
case 39:
#line 245 "parser.y"
{grid -> xe = yyvsp[0].t.x;
			     grid -> ye = yyvsp[0].t.y;
			     grid -> ze = yyvsp[0].t.z;}
break;
case 40:
#line 249 "parser.y"
{grid -> xnumber = yyvsp[0].i;}
break;
case 41:
#line 251 "parser.y"
{grid -> ynumber = yyvsp[0].i;}
break;
case 42:
#line 253 "parser.y"
{grid -> znumber = yyvsp[0].i;}
break;
case 43:
#line 258 "parser.y"
{trimesh -> tolin = yyvsp[0].d;}
break;
case 44:
#line 260 "parser.y"
{trimesh -> angspc = yyvsp[0].d;}
break;
case 45:
#line 262 "parser.y"
{trimesh -> angtol = yyvsp[0].d;}
break;
case 46:
#line 264 "parser.y"
{trimesh -> kappa = yyvsp[0].d;}
break;
case 47:
#line 266 "parser.y"
{trimesh -> dmin = yyvsp[0].d;}
break;
case 48:
#line 268 "parser.y"
{trimesh -> max = yyvsp[0].i;}
break;
case 49:
#line 270 "parser.y"
{trimesh -> min = yyvsp[0].i;}
break;
case 50:
#line 272 "parser.y"
{
				   trimesh -> numcurves = yyvsp[0].i + 1;
				   trimesh -> curves = Allocate (Curve, yyvsp[0].i+1);
				}
break;
case 51:
#line 281 "parser.y"
{
		yyval.p.x = (double) yyvsp[-3].d;
		yyval.p.y = (double) yyvsp[-1].d;
	   }
break;
case 52:
#line 290 "parser.y"
{
 		yyval.t.x = (double) yyvsp[-5].d;
		yyval.t.y = (double) yyvsp[-3].d;
		yyval.t.z = (double) yyvsp[-1].d;
	    }
break;
case 53:
#line 299 "parser.y"
{yyval.d = yyvsp[-2].d + yyvsp[0].d;}
break;
case 54:
#line 301 "parser.y"
{yyval.d = yyvsp[-2].d - yyvsp[0].d;}
break;
case 55:
#line 303 "parser.y"
{yyval.d = yyvsp[-2].d * yyvsp[0].d;}
break;
case 56:
#line 305 "parser.y"
{yyval.d = yyvsp[0].d ? yyvsp[-2].d / yyvsp[0].d : 0;}
break;
case 57:
#line 307 "parser.y"
{yyval.d = -yyvsp[0].d;}
break;
case 58:
#line 309 "parser.y"
{yyval.d = yyvsp[0].d;}
break;
case 59:
#line 311 "parser.y"
{yyval.d = yyvsp[-1].d;}
break;
case 60:
#line 313 "parser.y"
{yyval.d = sin (yyvsp[-1].d * M_PI / 180);}
break;
case 61:
#line 315 "parser.y"
{yyval.d = cos (yyvsp[-1].d * M_PI / 180);}
break;
case 62:
#line 317 "parser.y"
{yyval.d = tan (yyvsp[-1].d * M_PI / 180);}
break;
case 63:
#line 319 "parser.y"
{yyval.d = yyvsp[0].d;}
break;
case 64:
#line 321 "parser.y"
{yyval.d = yyvsp[0].i;}
break;
#line 708 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
